/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.ContactMarshaller;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.io.vcard.ItemHandlerManager;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.versitio.versitItem;
import net.wimpi.pim.util.versitio.versitToken;
import net.wimpi.pim.util.versitio.versitWriter;

public class vCardMarshaller
implements ContactMarshaller {
    private String m_Encoding = null;
    private versitItem m_ENDITEM = new versitItem("END", "VCARD");
    private versitItem m_STARTITEM = new versitItem("BEGIN", "VCARD");
    private versitItem m_V3ITEM = new versitItem("VERSION", "3.0");
    private versitItem m_PRODIDITEM = new versitItem("PRODID", "jpim.sourceforge.net");
    private ItemHandlerManager m_ItemHandlerManager = ItemHandlerManager.getReference();

    public vCardMarshaller() {
    }

    public vCardMarshaller(String string) {
        this.m_Encoding = string;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public void setEncoding(String string) {
        this.m_Encoding = string;
    }

    public void marshallContact(OutputStream outputStream, Contact contact) {
        Contact[] contactArray = new Contact[]{contact};
        this.marshallContacts(outputStream, contactArray);
    }

    public void marshallContacts(OutputStream outputStream, Contact[] contactArray) {
        try {
            for (int i = 0; i < contactArray.length; ++i) {
                this.marshallCard(outputStream, contactArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void marshallCard(OutputStream outputStream, Contact contact) {
        ArrayList<versitItem> arrayList = new ArrayList<versitItem>(20);
        arrayList.add(this.m_STARTITEM);
        arrayList.add(this.m_V3ITEM);
        for (int i = 0; i < versitToken.VCARD_ITEM_LIST.length; ++i) {
            this.addItem(arrayList, versitToken.VCARD_ITEM_LIST[i], contact);
        }
        String[] stringArray = this.m_ItemHandlerManager.listExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(arrayList, stringArray[i], contact);
        }
        if (Pim.isAnnounced()) {
            arrayList.add(this.m_PRODIDITEM);
        }
        arrayList.add(this.m_ENDITEM);
        try {
            versitWriter versitWriter2 = null;
            versitWriter2 = this.m_Encoding != null ? new versitWriter(outputStream, this.m_Encoding) : new versitWriter(outputStream);
            versitWriter2.writeCard(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addItem(List list, String string, Contact contact) {
        ItemHandler itemHandler = this.m_ItemHandlerManager.getItemHandler(string);
        if (itemHandler != null) {
            versitItem[] versitItemArray = itemHandler.createItems(contact);
            for (int i = 0; i < versitItemArray.length; ++i) {
                list.add(versitItemArray[i]);
            }
        }
    }
}

