/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Organization;
import net.wimpi.pim.contact.model.OrganizationalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class XORGURLItemHandler
implements ItemHandler {
    XORGURLItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        Organization organization;
        OrganizationalIdentity organizationalIdentity = contact.getOrganizationalIdentity();
        if (organizationalIdentity == null) {
            organizationalIdentity = Pim.getContactModelFactory().createOrganizationalIdentity();
            contact.setOrganizationalIdentity(organizationalIdentity);
        }
        if ((organization = organizationalIdentity.getOrganization()) == null) {
            organization = Pim.getContactModelFactory().createOrganization();
            organizationalIdentity.setOrganization(organization);
        }
        organization.setURL(versitItem2.getDecodedValue());
    }

    public versitItem[] createItems(Contact contact) throws IndexOutOfBoundsException {
        OrganizationalIdentity organizationalIdentity = contact.getOrganizationalIdentity();
        if (organizationalIdentity == null) {
            return new versitItem[0];
        }
        Organization organization = organizationalIdentity.getOrganization();
        if (organization == null) {
            return new versitItem[0];
        }
        String string = organization.getURL();
        if (StringUtil.isValidString(string)) {
            versitItem[] versitItemArray = new versitItem[]{new versitItem("X-ORG-URL", string)};
            return versitItemArray;
        }
        return new versitItem[0];
    }
}

