/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PhoneNumber;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class TELItemHandler
implements ItemHandler {
    TELItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        boolean bl = false;
        PhoneNumber phoneNumber = Pim.getContactModelFactory().createPhoneNumber();
        phoneNumber.setNumber(versitItem2.getDecodedValue());
        String[] stringArray = versitItem2.getParameter("TYPE");
        if (stringArray == null) {
            stringArray = versitItem2.getParameter("DEFAULT");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].toUpperCase();
                if (string.equals("HOME")) {
                    phoneNumber.setHome(true);
                    continue;
                }
                if (string.equals("WORK")) {
                    phoneNumber.setWork(true);
                    continue;
                }
                if (string.equals("VOICE")) {
                    phoneNumber.setVoice(true);
                    continue;
                }
                if (string.equals("FAX")) {
                    phoneNumber.setFax(true);
                    continue;
                }
                if (string.equals("MSG")) {
                    phoneNumber.setMessaging(true);
                    continue;
                }
                if (string.equals("CELL")) {
                    phoneNumber.setCellular(true);
                    continue;
                }
                if (string.equals("PAGER")) {
                    phoneNumber.setPager(true);
                    continue;
                }
                if (string.equals("BBS")) {
                    phoneNumber.setBBS(true);
                    continue;
                }
                if (string.equals("MODEM")) {
                    phoneNumber.setMODEM(true);
                    continue;
                }
                if (string.equals("CAR")) {
                    phoneNumber.setCellular(true);
                    continue;
                }
                if (string.equals("ISDN")) {
                    phoneNumber.setISDN(true);
                    continue;
                }
                if (string.equals("PREF")) {
                    phoneNumber.setPreferred(true);
                    continue;
                }
                if (string.equals("VIDEO")) {
                    phoneNumber.setVideo(true);
                    continue;
                }
                if (string.equals("CAR")) {
                    phoneNumber.setCar(true);
                    continue;
                }
                if (string.equals("PCS")) {
                    phoneNumber.setPCS(true);
                    continue;
                }
                if (!string.equals("PREF")) continue;
                bl = true;
            }
        } else {
            phoneNumber.setVoice(true);
        }
        Communications communications = contact.getCommunications();
        if (communications == null) {
            communications = Pim.getContactModelFactory().createCommunications();
            contact.setCommunications(communications);
        }
        communications.addPhoneNumber(phoneNumber);
        if (bl) {
            communications.setPreferredPhoneNumber(phoneNumber);
        }
    }

    public versitItem[] createItems(Contact contact) {
        if (!contact.hasCommunications()) {
            return new versitItem[0];
        }
        Communications communications = contact.getCommunications();
        versitItem[] versitItemArray = new versitItem[communications.getPhoneNumberCount()];
        int n = 0;
        Iterator iterator = communications.getPhoneNumbers();
        while (iterator.hasNext()) {
            PhoneNumber phoneNumber = (PhoneNumber)iterator.next();
            if (phoneNumber == null) {
                return new versitItem[0];
            }
            String string = phoneNumber.getNumber();
            if (!StringUtil.isValidString(string)) {
                return new versitItem[0];
            }
            versitItem versitItem2 = new versitItem("TEL");
            if (phoneNumber.isPreferred()) {
                versitItem2.addParameter("TYPE", "PREF");
            }
            if (phoneNumber.isWork()) {
                versitItem2.addParameter("TYPE", "WORK");
            }
            if (phoneNumber.isHome()) {
                versitItem2.addParameter("TYPE", "HOME");
            }
            if (phoneNumber.isVoice()) {
                versitItem2.addParameter("TYPE", "VOICE");
            }
            if (phoneNumber.isFax()) {
                versitItem2.addParameter("TYPE", "FAX");
            }
            if (phoneNumber.isMessaging()) {
                versitItem2.addParameter("TYPE", "MSG");
            }
            if (phoneNumber.isCellular()) {
                versitItem2.addParameter("TYPE", "CELL");
            }
            if (phoneNumber.isPager()) {
                versitItem2.addParameter("TYPE", "PAGER");
            }
            if (phoneNumber.isBBS()) {
                versitItem2.addParameter("TYPE", "BBS");
            }
            if (phoneNumber.isMODEM()) {
                versitItem2.addParameter("TYPE", "MODEM");
            }
            if (phoneNumber.isISDN()) {
                versitItem2.addParameter("TYPE", "ISDN");
            }
            if (phoneNumber.isVideo()) {
                versitItem2.addParameter("TYPE", "VIDEO");
            }
            if (phoneNumber.isPCS()) {
                versitItem2.addParameter("TYPE", "PCS");
            }
            if (phoneNumber.isCar()) {
                versitItem2.addParameter("TYPE", "CAR");
            }
            if (communications.isPreferredPhoneNumber(phoneNumber)) {
                versitItem2.addParameter("TYPE", "PREF");
            }
            versitItem2.setValue(string);
            versitItemArray[n] = versitItem2;
            ++n;
        }
        return versitItemArray;
    }
}

