/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Address;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class ADRItemHandler
implements ItemHandler {
    ADRItemHandler() {
    }

    public void handleItem(Contact contact, versitItem versitItem2) {
        int n;
        boolean bl = false;
        String[] stringArray = StringUtil.split(versitItem2.getDecodedValue(), ";");
        Address address = Pim.getContactModelFactory().createAddress();
        block9: for (n = 0; n < stringArray.length; ++n) {
            switch (n) {
                case 0: {
                    address.setPostBox(stringArray[0]);
                    continue block9;
                }
                case 1: {
                    address.setExtended(stringArray[1]);
                    continue block9;
                }
                case 2: {
                    address.setStreet(stringArray[2]);
                    continue block9;
                }
                case 3: {
                    address.setCity(stringArray[3]);
                    continue block9;
                }
                case 4: {
                    address.setRegion(stringArray[4]);
                    continue block9;
                }
                case 5: {
                    address.setPostalCode(stringArray[5]);
                    continue block9;
                }
                case 6: {
                    address.setCountry(stringArray[6]);
                }
            }
        }
        stringArray = versitItem2.getParameter("TYPE");
        if (stringArray == null) {
            stringArray = versitItem2.getParameter("DEFAULT");
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n].toUpperCase();
                if (string.equals("DOM")) {
                    address.setDomestic(true);
                    continue;
                }
                if (string.equals("INTL")) {
                    address.setInternational(true);
                    continue;
                }
                if (string.equals("POSTAL")) {
                    address.setPostal(true);
                    continue;
                }
                if (string.equals("PARCEL")) {
                    address.setParcel(true);
                    continue;
                }
                if (string.equals("HOME")) {
                    address.setHome(true);
                    continue;
                }
                if (string.equals("WORK")) {
                    address.setWork(true);
                    continue;
                }
                if (!string.equals("PREF")) continue;
                bl = true;
            }
        } else {
            address.setInternational(true);
            address.setPostal(true);
            address.setParcel(true);
            address.setWork(true);
        }
        contact.addAddress(address);
        if (bl) {
            contact.setPreferredAddress(address);
        }
    }

    public versitItem[] createItems(Contact contact) {
        versitItem[] versitItemArray = new versitItem[contact.getAddressCount()];
        int n = 0;
        Iterator iterator = contact.getAddresses();
        while (iterator.hasNext()) {
            Address address = (Address)iterator.next();
            if (address == null) {
                return null;
            }
            String string = address.getPostBox();
            String string2 = address.getExtended();
            String string3 = address.getStreet();
            String string4 = address.getRegion();
            String string5 = address.getCity();
            String string6 = address.getPostalCode();
            String string7 = address.getCountry();
            StringBuffer stringBuffer = new StringBuffer();
            versitItem versitItem2 = new versitItem("ADR");
            if (address.isDomestic()) {
                versitItem2.addParameter("TYPE", "DOM");
            }
            if (address.isInternational()) {
                versitItem2.addParameter("TYPE", "INTL");
            }
            if (address.isPostal()) {
                versitItem2.addParameter("TYPE", "POSTAL");
            }
            if (address.isParcel()) {
                versitItem2.addParameter("TYPE", "PARCEL");
            }
            if (address.isHome()) {
                versitItem2.addParameter("TYPE", "HOME");
            }
            if (address.isWork()) {
                versitItem2.addParameter("TYPE", "WORK");
            }
            if (contact.isPreferredAddress(address)) {
                versitItem2.addParameter("TYPE", "PREF");
            }
            if (StringUtil.isValidString(string)) {
                stringBuffer.append(string);
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string2)) {
                stringBuffer.append(EncodingUtility.encodeLineBreaks(string2));
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string3)) {
                stringBuffer.append(EncodingUtility.encodeLineBreaks(string3));
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string5)) {
                stringBuffer.append(string5);
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string4)) {
                stringBuffer.append(string4);
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string6)) {
                stringBuffer.append(string6);
            }
            stringBuffer.append(";");
            if (StringUtil.isValidString(string7)) {
                stringBuffer.append(string7);
            }
            versitItem2.setValue(stringBuffer.toString());
            versitItemArray[n] = versitItem2;
            ++n;
        }
        return versitItemArray;
    }
}

