/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.db.serializable;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.wimpi.pim.contact.db.AbstractContactFilter;
import net.wimpi.pim.contact.db.ContactCollection;
import net.wimpi.pim.contact.db.ContactFilter;
import net.wimpi.pim.contact.db.ContactGroup;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.AbstractIdentifiable;

public class ContactCollectionImpl
implements ContactCollection,
Serializable {
    static final long serialVersionUID = -7518133802753769769L;
    protected Map m_Contacts = new HashMap(50);
    protected Map m_NameIndex = new HashMap(50);
    protected transient int m_ModCount = 0;

    public boolean contains(String string) {
        return this.m_Contacts.keySet().contains(string);
    }

    public boolean contains(Contact contact) {
        return this.contains(contact.getUID());
    }

    public boolean containsByName(String string) {
        return this.m_NameIndex.keySet().contains(string);
    }

    public Contact get(String string) {
        return (Contact)this.m_Contacts.get(string);
    }

    public Contact getByName(String string) {
        return this.get((String)this.m_NameIndex.get(string));
    }

    public Contact[] toArray() {
        Contact[] contactArray = new Contact[this.m_Contacts.size()];
        Iterator iterator = this.iterator();
        for (int i = 0; i < this.m_Contacts.size(); ++i) {
            contactArray[i] = (Contact)iterator.next();
        }
        return contactArray;
    }

    public Contact[] toArray(ContactFilter contactFilter) {
        ContactIterator contactIterator = new ContactIterator(contactFilter);
        Contact[] contactArray = new Contact[contactIterator.size()];
        for (int i = 0; i < contactIterator.size(); ++i) {
            contactArray[i] = (Contact)contactIterator.next();
        }
        return contactArray;
    }

    public void add(Contact contact) {
        if (!this.m_Contacts.keySet().contains(contact.getUID())) {
            int n = this.size();
            this.m_Contacts.put(contact.getUID(), contact);
            this.addToNameIndex(contact);
            if (n != this.size()) {
                this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
            }
        }
    }

    public Contact remove(String string) {
        Contact contact = (Contact)this.m_Contacts.remove(string);
        if (contact != null) {
            this.removeFromNameIndex(contact);
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return contact;
    }

    public void remove(Contact contact) {
        this.remove(contact.getUID());
    }

    public Iterator iterator() {
        return new ContactIterator();
    }

    public Iterator iterator(ContactFilter contactFilter) {
        return new ContactIterator(contactFilter);
    }

    public int size() {
        return this.m_Contacts.size();
    }

    private void addToNameIndex(Contact contact) {
        String string;
        if (contact == null) {
            return;
        }
        if (contact.hasPersonalIdentity() && (string = contact.getPersonalIdentity().getFormattedName()) != null && string.length() > 0) {
            this.m_NameIndex.put(string, contact.getUID());
        }
    }

    private void removeFromNameIndex(Contact contact) {
        String string;
        if (contact == null) {
            return;
        }
        if (contact.hasPersonalIdentity() && (string = contact.getPersonalIdentity().getFormattedName()) != null && string.length() > 0) {
            this.m_NameIndex.remove(string);
        }
    }

    private boolean modified(int n) {
        return n != this.m_ModCount;
    }

    ContactGroup createContactGroup() {
        return new ContactGroupImpl();
    }

    protected class ContactGroupImpl
    extends AbstractIdentifiable
    implements ContactGroup,
    Serializable {
        static final long serialVersionUID = 1294968173858663287L;
        protected String m_Name;
        protected String m_Description;
        protected List m_ContactIDs = new ArrayList(10);

        public String getName() {
            return this.m_Name;
        }

        public void setName(String string) {
            this.m_Name = string;
        }

        public String getDescription() {
            return this.m_Description;
        }

        public void setDescription(String string) {
            this.m_Description = string;
        }

        public Contact[] listContacts() {
            ContactIterator contactIterator = (ContactIterator)this.getContacts();
            Contact[] contactArray = new Contact[contactIterator.size()];
            for (int i = 0; i < contactIterator.size(); ++i) {
                contactArray[i] = (Contact)contactIterator.next();
            }
            return contactArray;
        }

        public Iterator getContacts() {
            return new ContactIterator(new AbstractContactFilter(){

                public boolean passes(Contact contact) {
                    return ContactGroupImpl.this.contains(contact.getUID());
                }
            });
        }

        public void addContact(Contact contact) {
            if (!ContactCollectionImpl.this.contains(contact)) {
                throw new IllegalArgumentException();
            }
            this.m_ContactIDs.add(contact.getUID());
        }

        public void removeContact(Contact contact) {
            this.m_ContactIDs.remove(contact.getUID());
        }

        public boolean contains(String string) {
            return this.m_ContactIDs.contains(string);
        }

        public boolean contains(Contact contact) {
            return this.contains(contact.getUID());
        }

        public int size() {
            return this.m_ContactIDs.size();
        }

        public void cleanup() {
            Iterator iterator = this.m_ContactIDs.iterator();
            while (iterator.hasNext()) {
                if (ContactCollectionImpl.this.contains((String)iterator.next())) continue;
                iterator.remove();
            }
            System.out.println("cleanup():" + this.m_ContactIDs.toString());
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.cleanup();
            objectOutputStream.defaultWriteObject();
        }
    }

    class ContactIterator
    implements Iterator {
        private ArrayList m_Entries;
        private int m_Next;
        private int m_Last = -1;
        private int m_ExpectedModCount;

        public ContactIterator() {
            this.m_ExpectedModCount = ContactCollectionImpl.this.m_ModCount;
            this.prepare(null);
        }

        public ContactIterator(ContactFilter contactFilter) {
            this.m_ExpectedModCount = ContactCollectionImpl.this.m_ModCount;
            this.prepare(contactFilter);
        }

        private void prepare(ContactFilter contactFilter) {
            int n = ContactCollectionImpl.this.size();
            this.m_Entries = new ArrayList(n);
            Iterator iterator = ContactCollectionImpl.this.m_Contacts.values().iterator();
            for (int i = 0; i < n; ++i) {
                Contact contact = (Contact)iterator.next();
                if (contactFilter != null) {
                    if (!contactFilter.passes(contact)) continue;
                    this.m_Entries.add(contact);
                    continue;
                }
                this.m_Entries.add(contact);
            }
            this.m_Next = 0;
        }

        public boolean hasNext() {
            return this.m_Next < this.m_Entries.size();
        }

        public Object next() {
            if (this.m_Next >= this.m_Entries.size()) {
                throw new NoSuchElementException();
            }
            if (ContactCollectionImpl.this.modified(this.m_ExpectedModCount)) {
                throw new ConcurrentModificationException();
            }
            Object e = this.m_Entries.get(this.m_Next);
            this.m_Last = this.m_Next++;
            return e;
        }

        public void remove() {
            if (this.m_Last == -1) {
                throw new IllegalStateException();
            }
            ContactCollectionImpl.this.remove((Contact)this.m_Entries.get(this.m_Last));
            this.m_Entries.remove(this.m_Last);
            this.m_Last = -1;
            --this.m_Next;
            ++this.m_ExpectedModCount;
        }

        public int size() {
            return this.m_Entries.size();
        }

        public List getEntries() {
            return this.m_Entries;
        }
    }
}

