/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.basicimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.EmailAddress;
import net.wimpi.pim.contact.model.PhoneNumber;

public class CommunicationsImpl
implements Communications {
    static final long serialVersionUID = 323095380120358187L;
    protected List m_PhoneNumbers = Collections.synchronizedList(new ArrayList(5));
    protected List m_EmailAddresses = Collections.synchronizedList(new ArrayList(5));
    protected String m_Mailer;
    protected EmailAddress m_PreferredEmail;
    protected PhoneNumber m_PreferredNumber;

    public Iterator getPhoneNumbers() {
        return this.m_PhoneNumbers.listIterator();
    }

    public PhoneNumber[] listPhoneNumbers() {
        PhoneNumber[] phoneNumberArray = new PhoneNumber[this.m_PhoneNumbers.size()];
        return this.m_PhoneNumbers.toArray(phoneNumberArray);
    }

    public PhoneNumber getPhoneNumber(String string) {
        for (PhoneNumber phoneNumber : this.m_PhoneNumbers) {
            if (!phoneNumber.equals(string)) continue;
            return phoneNumber;
        }
        return null;
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.m_PhoneNumbers.add(phoneNumber);
    }

    public void removePhoneNumber(PhoneNumber phoneNumber) {
        if (this.isPreferredPhoneNumber(phoneNumber)) {
            this.m_PreferredNumber = null;
        }
        this.m_PhoneNumbers.remove(phoneNumber);
    }

    public PhoneNumber getPreferredPhoneNumber() {
        return this.m_PreferredNumber;
    }

    public void setPreferredPhoneNumber(PhoneNumber phoneNumber) {
        if (this.m_PhoneNumbers.contains(phoneNumber)) {
            this.m_PreferredNumber = phoneNumber;
        }
    }

    public boolean isPreferredPhoneNumber(PhoneNumber phoneNumber) {
        return phoneNumber.equals(this.m_PreferredNumber);
    }

    public PhoneNumber[] listPhoneNumbersByType(int n) {
        ArrayList<PhoneNumber> arrayList = new ArrayList<PhoneNumber>(this.m_PhoneNumbers.size());
        for (PhoneNumber phoneNumber : this.m_PhoneNumbers) {
            if (!phoneNumber.isType(n)) continue;
            arrayList.add(phoneNumber);
        }
        PhoneNumber[] phoneNumberArray = new PhoneNumber[arrayList.size()];
        return arrayList.toArray(phoneNumberArray);
    }

    public int getPhoneNumberCount() {
        return this.m_PhoneNumbers.size();
    }

    public Iterator getEmailAddresses() {
        return this.m_EmailAddresses.listIterator();
    }

    public EmailAddress[] listEmailAddresses() {
        EmailAddress[] emailAddressArray = new EmailAddress[this.m_EmailAddresses.size()];
        return this.m_EmailAddresses.toArray(emailAddressArray);
    }

    public EmailAddress getEmailAddress(String string) {
        for (EmailAddress emailAddress : this.m_EmailAddresses) {
            if (!emailAddress.equals(string)) continue;
            return emailAddress;
        }
        return null;
    }

    public void addEmailAddress(EmailAddress emailAddress) {
        this.m_EmailAddresses.add(emailAddress);
    }

    public void removeEmailAddress(EmailAddress emailAddress) {
        this.m_EmailAddresses.remove(emailAddress);
    }

    public EmailAddress getPreferredEmailAddress() {
        return this.m_PreferredEmail;
    }

    public void setPreferredEmailAddress(EmailAddress emailAddress) {
        if (this.m_EmailAddresses.contains(emailAddress)) {
            this.m_PreferredEmail = emailAddress;
        }
    }

    public boolean isPreferredEmailAddress(EmailAddress emailAddress) {
        return emailAddress.equals(this.m_PreferredEmail);
    }

    public int getEmailAddressCount() {
        return this.m_EmailAddresses.size();
    }

    public String getMailer() {
        return this.m_Mailer;
    }

    public void setMailer(String string) {
        this.m_Mailer = string;
    }
}

