/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.fax;

import gnu.hylafax.Job;
import gnu.inet.ftp.ServerResponseException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.fax.Document;
import net.sf.jhylafax.fax.FaxJob;
import net.sf.jhylafax.fax.Modem;
import net.sf.jhylafax.fax.Paper;
import net.sf.jhylafax.fax.ReceivedFax;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HylaFAXClientHelper
extends Thread {
    public static final String FILEFMT = "__FILEFMT |%d |%f |%g |%i |%l |%o |%p |%q |%r |%s |%m ";
    public static final String JOBFMT = "__JOBFMT |%a |%b |%c |%e |%f |%g |%h |%i |%j |%k |%l |%m |%n |%o |%p |%q |%r |%t |%u |%v |%w |%x |%y |%z |%A |%B |%C |%D |%E |%F |%G |%H |%I |%J |%K |%L |%M |%N |%O |%P |%Q |%R |%S |%U |%V |%W |%X |%Y |%Z |%s ";
    private static final Log logger = LogFactory.getLog(HylaFAXClientHelper.class);
    public static final String MODEMFMT = "__MODEMFMT |%h |%l |%m |%n |%r |%s |%t |%v |%z ";
    protected static final String QUEUE_SEPARATOR = "|";
    public static final String RCVFMT = "__RCVFMT |%Y |%a |%b |%d |%e |%f |%h |%i |%j |%l |%n |%o |%p |%r |%s |%w |%z ";
    private static DateFormat fileDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss yyyy", Locale.ENGLISH);

    public static void applyParameter(Job faxJob, FaxJob job) throws ServerResponseException, IOException {
        faxJob.setDialstring(job.getNumber());
        if (job.getSender() != null && job.getSender().trim().length() > 0) {
            faxJob.setFromUser(job.getSender());
        }
        faxJob.setKilltime("000259");
        faxJob.setMaximumDials(job.getMaxDials());
        faxJob.setMaximumTries(job.getMaxDials());
        if (job.getNotifyAdress() != null && job.getNotifyAdress().trim().length() > 0) {
            faxJob.setNotifyAddress(job.getNotifyAdress());
        }
        if (job.getNotify() != null) {
            faxJob.setNotifyType(job.getNotify());
        }
        faxJob.setPageChop("default");
        faxJob.setPageWidth(job.getPageWidth());
        faxJob.setPageLength(job.getPageLength());
        faxJob.setPriority(job.getPriority());
        faxJob.setProperty("SENDTIME", HylaFAXClientHelper.calculateTime(job.getSendTime(), (String)Settings.TIMEZONE.getValue()));
        faxJob.setVerticalResolution(job.getVerticalResolution());
    }

    public static String calculateTime(Date sendTime, String timeZoneID) {
        if (sendTime == null) {
            return "NOW";
        }
        long date = sendTime.getTime();
        TimeZone tz = TimeZone.getTimeZone(timeZoneID);
        date -= (long)tz.getRawOffset();
        if (tz.inDaylightTime(sendTime)) {
            date -= 3600000L;
        }
        return new SimpleDateFormat("yyyyMMddHHmm").format(new Date(date));
    }

    private static FaxJob.JobType getJobType(char c) {
        switch (c) {
            case 'P': {
                return FaxJob.JobType.PAGER;
            }
        }
        return FaxJob.JobType.FACSIMILE;
    }

    private static final String getNotify(char notify) {
        switch (notify) {
            case 'D': {
                return "DONE";
            }
            case 'Q': {
                return "REQUEUE";
            }
            case 'A': {
                return "DONE+REQUEUE";
            }
        }
        return "NONE";
    }

    private static FaxJob.PageChopping getPageChopping(char c) {
        switch (c) {
            case 'D': {
                return FaxJob.PageChopping.DISABLED;
            }
            case 'A': {
                return FaxJob.PageChopping.ALL;
            }
            case 'L': {
                return FaxJob.PageChopping.LAST;
            }
        }
        return FaxJob.PageChopping.DEFAULT;
    }

    public static final FaxJob.State getState(char state) {
        switch (state) {
            case 'T': {
                return FaxJob.State.SUSPENDED;
            }
            case 'P': {
                return FaxJob.State.PENDING;
            }
            case 'S': {
                return FaxJob.State.SLEEPING;
            }
            case 'B': {
                return FaxJob.State.BLOCKED;
            }
            case 'W': {
                return FaxJob.State.WAITING;
            }
            case 'D': {
                return FaxJob.State.DONE;
            }
            case 'R': {
                return FaxJob.State.RUNNING;
            }
            case 'F': {
                return FaxJob.State.FAILED;
            }
        }
        return FaxJob.State.UNDEFINED;
    }

    private static Modem.Volume getVolume(char c) {
        return Modem.Volume.OFF;
    }

    public static final void initializeFromSettings(FaxJob job) {
        job.setSender((String)Settings.FULLNAME.getValue());
        job.setNotifyAdress((String)Settings.EMAIL.getValue());
        job.setMaxDials((Integer)Settings.MAXDIALS.getValue());
        job.setMaxTries((Integer)Settings.MAXTRIES.getValue());
        job.setNotify(((Settings.Notification)((Object)Settings.NOTIFICATION.getValue())).getCommand());
        job.setPageLength(((Paper)((Object)Settings.PAPER.getValue())).getHeight());
        job.setPageWidth(((Paper)((Object)Settings.PAPER.getValue())).getWidth());
        job.setPriority((Integer)Settings.PRIORITY.getValue());
        job.setResolution(((Settings.Resolution)((Object)Settings.RESOLUTION.getValue())).getLinesPerInch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPostscript(String filename) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        try {
            boolean bl = in.readLine().startsWith("%!");
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static int parseDuration(String s) {
        StringTokenizer t = new StringTokenizer(s, ":");
        int duration = 0;
        while (t.hasMoreTokens()) {
            int n = Integer.parseInt(t.nextToken());
            duration = duration * 60 + n;
        }
        return duration;
    }

    public static final Document parseFileFmt(String response) {
        StringTokenizer st = new StringTokenizer(response, QUEUE_SEPARATOR);
        StringTokenizer jf = new StringTokenizer(FILEFMT, QUEUE_SEPARATOR);
        Document file = new Document();
        while (st.hasMoreElements() && jf.hasMoreElements()) {
            char c = jf.nextToken().charAt(1);
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            try {
                switch (c) {
                    case 'a': {
                        file.setLastAccessTime(fileDateFormat.parse(s));
                        break;
                    }
                    case 'c': {
                        file.setCreationTime(fileDateFormat.parse(s));
                        break;
                    }
                    case 'd': {
                        file.setDeviceNumber(Integer.parseInt(s, 8));
                        break;
                    }
                    case 'f': {
                        file.setFilename(s);
                        break;
                    }
                    case 'g': {
                        file.setGroupID(Integer.parseInt(s));
                        break;
                    }
                    case 'i': {
                        file.setInodeNumber(Long.parseLong(s));
                        break;
                    }
                    case 'l': {
                        file.setLinkCount(Integer.parseInt(s));
                        break;
                    }
                    case 'm': {
                        file.setLastModificationTime(fileDateFormat.parse(s));
                        break;
                    }
                    case 'o': {
                        file.setOwner(s);
                        break;
                    }
                    case 'p': {
                        break;
                    }
                    case 'q': {
                        file.setPermissions(s);
                        break;
                    }
                    case 'r': {
                        file.setRootDeviceNumber(Integer.parseInt(s));
                        break;
                    }
                    case 's': {
                        file.setFilesize(Long.parseLong(s));
                        break;
                    }
                    case 'u': {
                        file.setOwnerID(Integer.parseInt(s));
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.info("Error parsing respone", e);
            }
            catch (ParseException e) {
                logger.info("Error parsing response", e);
            }
        }
        return file;
    }

    public static final Object parseFmt(String response) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received: " + response);
        }
        if (response.trim().length() == 0) {
            return null;
        }
        if (response.startsWith("__JOBFMT")) {
            return HylaFAXClientHelper.parseJobFmt(response);
        }
        if (response.startsWith("__RCVFMT")) {
            return HylaFAXClientHelper.parseRcvFmt(response);
        }
        if (response.startsWith("__FILEFMT")) {
            return HylaFAXClientHelper.parseFileFmt(response);
        }
        if (response.startsWith("__MODEMFMT")) {
            return HylaFAXClientHelper.parseModemFmt(response);
        }
        logger.error("Invalid response: " + response);
        return null;
    }

    public static final FaxJob parseJobFmt(String response) {
        StringTokenizer st = new StringTokenizer(response, QUEUE_SEPARATOR);
        StringTokenizer jf = new StringTokenizer(JOBFMT, QUEUE_SEPARATOR);
        FaxJob job = new FaxJob();
        while (st.hasMoreElements() && jf.hasMoreElements()) {
            char c = jf.nextToken().charAt(1);
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            try {
                switch (c) {
                    case 'a': {
                        job.setState(HylaFAXClientHelper.getState(s.charAt(0)));
                        break;
                    }
                    case 'b': {
                        job.setConsecutiveFailedTries(Integer.parseInt(s));
                        break;
                    }
                    case 'c': {
                        job.setClientMachineName(s);
                        break;
                    }
                    case 'd': {
                        job.setDialsAttempted(Integer.parseInt(s));
                        break;
                    }
                    case 'e': {
                        job.setNumber(s);
                        break;
                    }
                    case 'f': {
                        job.setConsecutiveFailedDials(Integer.parseInt(s));
                        break;
                    }
                    case 'g': {
                        job.setGroupID(Integer.parseInt(s));
                        break;
                    }
                    case 'h': {
                        job.setPageChopping(HylaFAXClientHelper.getPageChopping(s.charAt(0)));
                        break;
                    }
                    case 'i': {
                        job.setPriority(new Integer(s));
                        break;
                    }
                    case 'j': {
                        job.setID(new Integer(s));
                        break;
                    }
                    case 'k': {
                        job.setKillTime(s);
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'm': {
                        job.setAssignedModem(s);
                        break;
                    }
                    case 'n': {
                        job.setNotify(HylaFAXClientHelper.getNotify(s.charAt(0)));
                        break;
                    }
                    case 'o': {
                        job.setOwner(s);
                        break;
                    }
                    case 'p': {
                        job.setPagesTransmitted(Integer.parseInt(s));
                        break;
                    }
                    case 'q': {
                        job.setRetryTime(HylaFAXClientHelper.parseDuration(s));
                        break;
                    }
                    case 'r': {
                        job.setResolution(new Integer(s));
                        break;
                    }
                    case 's': {
                        job.setLastError(s);
                        break;
                    }
                    case 't': {
                        job.setTriesAttempted(new Integer(s));
                        break;
                    }
                    case 'u': {
                        job.setMaxTries(new Integer(s));
                        break;
                    }
                    case 'v': {
                        job.setClientDialString(s);
                        break;
                    }
                    case 'w': {
                        job.setPageWidth(Integer.parseInt(s));
                        break;
                    }
                    case 'x': {
                        break;
                    }
                    case 'z': {
                        break;
                    }
                    case 'A': {
                        job.setDestinationSubAddress(s);
                        break;
                    }
                    case 'B': {
                        job.setDestinationPassword(s);
                        break;
                    }
                    case 'C': {
                        job.setDestinationCompanyName(s);
                        break;
                    }
                    case 'D': {
                        StringTokenizer t = new StringTokenizer(s, ":");
                        job.setDialsAttempted(Integer.parseInt(t.nextToken()));
                        job.setMaxDials(Integer.parseInt(t.nextToken()));
                        break;
                    }
                    case 'E': {
                        job.setDesiredSignallingRate(s);
                        break;
                    }
                    case 'F': {
                        job.setClientDialString(s);
                        break;
                    }
                    case 'G': {
                        job.setDesiredMinScanline(s);
                        break;
                    }
                    case 'H': {
                        job.setDesiredDataFormat(s);
                        break;
                    }
                    case 'I': {
                        job.setClientSchedulingPriority(s);
                        break;
                    }
                    case 'J': {
                        job.setClientJobTag(s);
                        break;
                    }
                    case 'K': {
                        job.setDesiredECM(s);
                        break;
                    }
                    case 'L': {
                        job.setDestinationLocation(s);
                        break;
                    }
                    case 'M': {
                        job.setNotifyAdress(s);
                        break;
                    }
                    case 'N': {
                        job.setUsePrivateTagLine("P".equals(s));
                        break;
                    }
                    case 'P': {
                        StringTokenizer t = new StringTokenizer(s, ":");
                        job.setPagesTransmitted(Integer.parseInt(t.nextToken()));
                        job.setPageCount(Integer.parseInt(t.nextToken()));
                        break;
                    }
                    case 'R': {
                        job.setReceiver(s);
                        break;
                    }
                    case 'S': {
                        job.setSender(s);
                        break;
                    }
                    case 'T': {
                        break;
                    }
                    case 'U': {
                        job.setChoppingThreshold(Double.parseDouble(s));
                        break;
                    }
                    case 'V': {
                        job.setJobDoneOperation(s);
                        break;
                    }
                    case 'W': {
                        job.setCommunicationIdentifier(s);
                        break;
                    }
                    case 'X': {
                        job.setJobType(HylaFAXClientHelper.getJobType(s.charAt(0)));
                        break;
                    }
                    case 'Y': {
                        Date date = new SimpleDateFormat("yyyy/MM/dd HH.mm.ss").parse(s);
                        job.setSendTime(date);
                        break;
                    }
                    case 'Z': {
                        Date date = new Date(Long.parseLong(s));
                        break;
                    }
                }
            }
            catch (ParseException e) {
                logger.info("Error parsing response", e);
            }
            catch (NumberFormatException e) {
                logger.info("Error parsing response", e);
            }
            catch (NoSuchElementException e) {
                logger.info("Error parsing response", e);
            }
        }
        return job;
    }

    public static final Modem parseModemFmt(String response) {
        StringTokenizer st = new StringTokenizer(response, QUEUE_SEPARATOR);
        StringTokenizer jf = new StringTokenizer(MODEMFMT, QUEUE_SEPARATOR);
        Modem modem = new Modem();
        while (st.hasMoreElements() && jf.hasMoreElements()) {
            char c = jf.nextToken().charAt(1);
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            try {
                switch (c) {
                    case 'h': {
                        modem.setHostname(s);
                        break;
                    }
                    case 'l': {
                        modem.setLocalIdentifier(s);
                        break;
                    }
                    case 'm': {
                        modem.setCanonicalName(s);
                        break;
                    }
                    case 'n': {
                        modem.setFaxNumber(s);
                        break;
                    }
                    case 'r': {
                        modem.setMaxPagesPerCall(Integer.parseInt(s));
                        break;
                    }
                    case 's': {
                        modem.setStatus(s);
                        break;
                    }
                    case 't': {
                        StringTokenizer t = new StringTokenizer(s, ":");
                        modem.setServerTracing(Integer.parseInt(t.nextToken()));
                        modem.setSessionTracing(Integer.parseInt(t.nextToken()));
                        break;
                    }
                    case 'v': {
                        modem.setSpeakerVolume(HylaFAXClientHelper.getVolume(s.charAt(0)));
                        break;
                    }
                    case 'z': {
                        modem.setRunning("*".equals(s));
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.info("Error parsing respone", e);
            }
            catch (NoSuchElementException e) {
                logger.info("Error parsing response", e);
            }
        }
        return modem;
    }

    public static final ReceivedFax parseRcvFmt(String response) {
        StringTokenizer st = new StringTokenizer(response, QUEUE_SEPARATOR);
        StringTokenizer jf = new StringTokenizer(RCVFMT, QUEUE_SEPARATOR);
        ReceivedFax fax = new ReceivedFax();
        while (st.hasMoreElements() && jf.hasMoreElements()) {
            char c = jf.nextToken().charAt(1);
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            try {
                switch (c) {
                    case 'Y': {
                        Date date = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").parse(s);
                        fax.setReceivedTime(date);
                        break;
                    }
                    case 'a': {
                        fax.setSubAddress(s);
                        break;
                    }
                    case 'b': {
                        fax.setSignallingRate(Integer.parseInt(s));
                        break;
                    }
                    case 'd': {
                        fax.setDataFormat(s);
                        break;
                    }
                    case 'e': {
                        fax.setLastError(s);
                        break;
                    }
                    case 'f': {
                        fax.setFilename(s);
                        break;
                    }
                    case 'h': {
                        fax.setTimeSpent(HylaFAXClientHelper.parseDuration(s));
                        break;
                    }
                    case 'i': {
                        fax.setCallerIDName(s);
                        break;
                    }
                    case 'j': {
                        fax.setCallerIDNumber(s);
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'm': {
                        break;
                    }
                    case 'n': {
                        fax.setFilesize(Long.parseLong(s));
                        break;
                    }
                    case 'o': {
                        fax.setOwner(s);
                        break;
                    }
                    case 'p': {
                        fax.setPageCount(Integer.parseInt(s));
                        break;
                    }
                    case 'q': {
                        fax.setProtectionMode(Integer.parseInt(s));
                        break;
                    }
                    case 'r': {
                        fax.setResolution(Integer.parseInt(s));
                        break;
                    }
                    case 's': {
                        fax.setSender(s);
                        break;
                    }
                    case 't': {
                        break;
                    }
                    case 'w': {
                        fax.setPageWidth(Integer.parseInt(s));
                        break;
                    }
                    case 'z': {
                        fax.setReceiving(s.equals("*"));
                    }
                }
            }
            catch (ParseException e) {
                logger.info("Error parsing response", e);
            }
            catch (NumberFormatException e) {
                logger.info("Error parsing response", e);
            }
        }
        return fax;
    }

    public static void setJobProperties(Job faxJob, FaxJob job) throws ServerResponseException, IOException {
    }
}

