/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.fax;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jhylafax.fax.Paper;
import org.xnap.commons.io.ProgressMonitor;

public class FaxCover {
    public static final String CHARSET = "ISO-8859-1";
    public String to = "";
    public String to_adress = "";
    public String to_company = "";
    public String to_location = "";
    public String to_voice_number = "";
    public String to_fax_number = "";
    public float pagewidth;
    public float pagelength;
    public String from = "";
    public String from_fax_number = "";
    public String from_voice_number = "";
    public String from_company = "";
    public String from_location = "";
    public String todays_date = "";
    public String regarding = "";
    public String comments = "";
    private boolean debug;
    private int page_count;
    private int npages;
    private int urx;
    private int ury;
    private List<String> docs = new ArrayList<String>();

    public FaxCover(Paper paper) {
        float width = 9920.0f;
        float height = 14030.0f;
        switch (paper) {
            case A4: {
                width = 9920.0f;
                height = 14030.0f;
                break;
            }
            case A3: {
                width = 14030.0f;
                height = 19840.0f;
                break;
            }
            case LETTER: {
                width = 10200.0f;
                height = 13200.0f;
            }
        }
        this.urx = (int)((double)width / 1200.0 * 72.0);
        this.ury = (int)((double)height / 1200.0 * 72.0);
    }

    public void addDocument(String filename) {
        this.docs.add(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer generate(InputStream in, ProgressMonitor monitor) throws IOException {
        String line;
        StringBuffer coverBuffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET));
        try {
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("%%Page: ")) {
                    ++this.page_count;
                }
                coverBuffer.append(line);
                coverBuffer.append("\n");
            }
        }
        finally {
            reader.close();
        }
        for (String filename : this.docs) {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            try {
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("%%Page: ")) continue;
                    ++this.page_count;
                    ++this.npages;
                }
            }
            finally {
                reader.close();
            }
        }
        StringBuffer sb = this.createHeader();
        sb.append(coverBuffer);
        return sb;
    }

    private StringBuffer createHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("%!PS-Adobe-2.0 EPSF-2.0\n%%Creator: JHylaFAX Version 1.3.9\n%%Title: HylaFAX Cover Sheet\n%%CreationDate: " + this.todays_date + "\n" + "%%Origin: 0 0\n" + "%%BoundingBox: " + 0 + " " + 0 + " " + this.urx + " " + this.ury + "\n" + "%%Pages: " + this.page_count + "\n" + "%%EndComments\n" + "%%BeginProlog\n" + "100 dict begin\n" + "/wordbreak ( ) def\n" + "/linebreak (\\n) def\n" + "/doLine {\n" + "% <line> <width> <height> <x> <y> doLine <width> <height> <x> <y>\n" + "2 copy moveto 5 -1 roll\n" + "wordbreak\n" + "{\n" + "  search {\n" + "      dup stringwidth pop currentpoint pop add 7 index 6 index add gt {\n" + "          6 3 roll 2 index sub 2 copy moveto 6 3 roll\n" + "      } if\n" + "      show wordbreak show\n" + "  }{\n" + "      dup stringwidth pop currentpoint pop add 5 index 4 index add gt {\n" + "          3 1 roll 3 index sub 2 copy moveto 3 -1 roll\n" + "      } if\n" + "      show exit\n" + "  } ifelse\n" + "} loop\n" + "2 index sub 2 copy moveto\n" + "} def\n" + "/BreakIntoLines{\n" + "% <width> <height> <x> <y> <text> BreakIntoLines\n" + "linebreak\n" + "{\n" + "   search {\n" + "       7 3 roll doLine 6 -2 roll\n" + "   }{\n" + "       5 1 roll doLine exit\n" + "      } ifelse\n" + "  } loop\n" + "pop pop pop pop\n" + "} def\n" + "/to (" + this.to + ") def\n" + "/to-company (" + this.to_company + ") def\n" + "/to-adress (" + this.to_adress + ") def\n" + "/to-Location (" + this.to_location + ") def\n" + "/to-voice-number (" + this.to_voice_number + ") def\n" + "/to-fax-number (" + this.to_fax_number + ") def\n" + "/pageWidth " + this.pagewidth + " def\n" + "/pageLength " + this.pagelength + " def\n" + "/from (" + this.from + ") def\n" + "/from-fax-number (" + this.from_fax_number + ") def\n" + "/from-voice-number (" + this.from_voice_number + ") def\n" + "/from-company (" + this.from_company + ") def\n" + "/from-Location (" + this.from_location + ") def\n" + "/page-count (" + this.npages + ") def\n" + "/todays-date (" + this.todays_date + ") def\n" + "/regarding (" + this.regarding + ") def\n" + "/comments (" + this.emitCommentDefs(this.comments) + ") def\n");
        sb.append("%%EndProlog\n");
        return sb;
    }

    private String emitCommentDefs(String comments) {
        int len = comments.length();
        StringBuffer buffer = new StringBuffer();
        buffer.setLength(2 * len);
        int n = 0;
        for (int i = 0; i < len; ++i) {
            char cur = comments.charAt(i);
            if (cur == '\n') {
                buffer.setCharAt(n++, '\\');
                buffer.insert(n++, "\\n");
            } else {
                if (cur == '(' || cur == ')' || cur == '\\') {
                    buffer.insert(n++, '\\');
                }
                buffer.setCharAt(n, cur);
            }
            ++n;
        }
        buffer.setLength(n);
        return buffer.toString();
    }
}

