/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.addressbook;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.addressbook.AddressBook;
import net.wimpi.pim.contact.facades.SimpleContact;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.FileChooserPanel;
import org.xnap.commons.gui.util.EnableListener;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.gui.wizard.WizardDialog;
import org.xnap.commons.gui.wizard.WizardDialogListener;
import org.xnap.commons.gui.wizard.WizardPage;
import org.xnap.commons.io.FileExtensionFilter;

public class ImportWizard
extends WizardDialog
implements LocaleChangeListener {
    private FilePage filePage;
    private FormatPage formatPage;
    private boolean firstTime = true;
    private AddressBook addressbook;

    public ImportWizard(AddressBook addressbook) {
        super(addressbook);
        this.addressbook = addressbook;
        this.filePage = new FilePage();
        this.addPage(this.filePage, "file");
        this.formatPage = new FormatPage();
        this.addPage(this.formatPage, "format");
        this.addWizardDialogListener(new WizardDialogListener(){

            public void pageChanged(WizardPage oldPage, WizardPage newPage) {
                if (ImportWizard.this.firstTime && oldPage == ImportWizard.this.filePage && newPage == ImportWizard.this.formatPage) {
                    ImportWizard.this.formatPage.guessFormat(((ImportWizard)ImportWizard.this).filePage.fileChooserPanel.getFilename());
                    ImportWizard.this.firstTime = false;
                }
            }
        });
        this.updateLabels();
        this.revert();
        this.pack();
    }

    private DefaultFormBuilder createForm() {
        FormLayout layout = new FormLayout("left:max(20dlu;pref), 3dlu, pref, 3dlu, left:max(20dlu;pref), pref, pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        return builder;
    }

    public void finish() {
        File file = this.filePage.fileChooserPanel.getFile();
        if (file == null) {
            Dialogs.showError((Component)this, JHylaFAX.i18n.tr("No file selected"), JHylaFAX.i18n.tr("Import Error"));
            return;
        }
        try {
            SimpleContact[] contacts;
            if (this.formatPage.vCardFormatRadioButton.isSelected()) {
                contacts = this.addressbook.importVCardContacts(file);
            } else if (this.formatPage.suseFaxFormatRadioButton.isSelected()) {
                contacts = this.addressbook.importCSVContacts(file, "|");
            } else {
                String separator = this.formatPage.separatorTextField.getText();
                if (file == null) {
                    Dialogs.showError((Component)this, JHylaFAX.i18n.tr("No valid separator specified"), JHylaFAX.i18n.tr("Import Error"));
                    return;
                }
                contacts = this.addressbook.importCSVContacts(file, separator);
            }
            Dialogs.showInfo(this, JHylaFAX.i18n.tr("Imported {0} contacts", contacts.length), JHylaFAX.i18n.tr("JHylaFAX Address Book"));
        }
        catch (Exception e) {
            ErrorDialog.showError(this, JHylaFAX.i18n.tr("Could not import from file \"{0}\"", file.getAbsolutePath()), JHylaFAX.i18n.tr("JHylaFAX Addressbook Error"), e);
            return;
        }
        super.finish();
    }

    public void revert() {
        this.formatPage.revert();
        this.filePage.revert();
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("JHylaFAX Address Book Import Wizard"));
        this.formatPage.updateLabels();
        this.filePage.updateLabels();
    }

    private class FormatPage
    implements WizardPage {
        private DefaultFormBuilder builder;
        JRadioButton csvFormatRadioButton;
        JRadioButton vCardFormatRadioButton;
        JRadioButton suseFaxFormatRadioButton;
        private JTextField separatorTextField;
        private JLabel separatorLabel;
        private JLabel separatorDescriptionLabel;

        public FormatPage() {
            this.builder = ImportWizard.this.createForm();
            this.vCardFormatRadioButton = new JRadioButton();
            this.builder.append(this.vCardFormatRadioButton);
            this.builder.nextLine();
            this.csvFormatRadioButton = new JRadioButton();
            this.builder.append(this.csvFormatRadioButton);
            this.separatorTextField = new JTextField(1);
            this.separatorLabel = this.builder.append("", (Component)this.separatorTextField);
            this.builder.nextLine();
            this.separatorDescriptionLabel = new JLabel();
            this.builder.append((Component)this.separatorDescriptionLabel, 7);
            this.builder.nextLine();
            this.csvFormatRadioButton.addItemListener(new EnableListener(this.separatorLabel, this.separatorTextField, this.separatorDescriptionLabel));
            this.suseFaxFormatRadioButton = new JRadioButton();
            this.builder.append(this.suseFaxFormatRadioButton);
            this.builder.nextLine();
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.vCardFormatRadioButton);
            bg.add(this.csvFormatRadioButton);
            bg.add(this.suseFaxFormatRadioButton);
        }

        public boolean apply() {
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("Select import format.");
        }

        public Icon getIcon() {
            return null;
        }

        public void guessFormat(String filename) {
            if (filename.endsWith("vcf")) {
                this.vCardFormatRadioButton.setSelected(true);
            } else if (filename.endsWith("susephone")) {
                this.suseFaxFormatRadioButton.setSelected(true);
            } else {
                this.csvFormatRadioButton.setSelected(true);
            }
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("Import Format");
        }

        public void revert() {
            this.csvFormatRadioButton.setSelected(true);
            this.separatorTextField.setText(",");
        }

        public void updateLabels() {
            this.vCardFormatRadioButton.setText(JHylaFAX.i18n.tr("vCard"));
            this.csvFormatRadioButton.setText(JHylaFAX.i18n.tr("CSV"));
            this.separatorLabel.setText(JHylaFAX.i18n.tr("Separator:"));
            this.separatorDescriptionLabel.setText(JHylaFAX.i18n.tr("Expected Format: First Name, Last Name, Fax, Company"));
            this.suseFaxFormatRadioButton.setText(JHylaFAX.i18n.tr("SuSEFax"));
        }
    }

    private class FilePage
    implements WizardPage {
        private DefaultFormBuilder builder;
        FileChooserPanel fileChooserPanel;
        private JLabel fileChooserPanelLabel;

        public FilePage() {
            this.builder = ImportWizard.this.createForm();
            this.fileChooserPanel = new FileChooserPanel(20);
            this.fileChooserPanel.getFileChooser().addChoosableFileFilter(new FileExtensionFilter(JHylaFAX.i18n.tr("vCards (*.vcf)"), ".vcf"));
            this.fileChooserPanel.getFileChooser().addChoosableFileFilter(new FileExtensionFilter(JHylaFAX.i18n.tr("CSV (*.csv)"), ".csv"));
            this.fileChooserPanel.getFileChooser().addChoosableFileFilter(new FileExtensionFilter(JHylaFAX.i18n.tr("SuSEFax (.susephone)"), ".susephone"));
            this.fileChooserPanel.getFileChooser().setFileHidingEnabled(false);
            this.fileChooserPanelLabel = this.builder.append("", (Component)this.fileChooserPanel, 5);
        }

        public boolean apply() {
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("Select file to import.");
        }

        public Icon getIcon() {
            return IconHelper.getTitleIcon("file.png");
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("Import File");
        }

        public void revert() {
        }

        public void updateLabels() {
            this.fileChooserPanelLabel.setText(JHylaFAX.i18n.tr("File:"));
        }
    }
}

