/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.addressbook;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.jhylafax.JHylaFAX;
import net.wimpi.pim.contact.facades.SimpleContact;
import org.xnap.commons.gui.DefaultDialog;

public class EditContactDialog
extends DefaultDialog {
    private SimpleContact contact;
    private JTextField firstNameTextField;
    private JLabel firstNameLabel;
    private JLabel lastNameLabel;
    private JTextField lastNameTextField;
    private JTextField companyTextField;
    private JLabel companyLabel;
    private JTextField faxNumberTextField;
    private JLabel faxNumberLabel;

    public EditContactDialog(JFrame owner, SimpleContact contact) {
        super(owner);
        this.setApplyOnEnter(true);
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.setMainComponent(builder.getPanel());
        this.firstNameTextField = new JTextField(20);
        this.firstNameLabel = builder.append("", (Component)this.firstNameTextField);
        builder.nextLine();
        this.lastNameTextField = new JTextField(20);
        this.lastNameLabel = builder.append("", (Component)this.lastNameTextField);
        builder.nextLine();
        this.companyTextField = new JTextField(20);
        this.companyLabel = builder.append("", (Component)this.companyTextField);
        builder.nextLine();
        this.faxNumberTextField = new JTextField(20);
        this.faxNumberLabel = builder.append("", (Component)this.faxNumberTextField);
        builder.nextLine();
        this.setContact(contact);
        this.revert();
        this.updateLabels();
        this.pack();
    }

    public SimpleContact getContact() {
        return this.contact;
    }

    public void setContact(SimpleContact contact) {
        this.contact = contact;
    }

    public void revert() {
        this.firstNameTextField.setText(this.contact.getFirstname());
        this.lastNameTextField.setText(this.contact.getLastname());
        this.companyTextField.setText(this.contact.getCompany());
        this.faxNumberTextField.setText(this.contact.getFaxNumber());
    }

    public boolean apply() {
        this.contact.setFirstname(this.firstNameTextField.getText());
        this.contact.setLastname(this.lastNameTextField.getText());
        this.contact.setCompany(this.companyTextField.getText());
        this.contact.setFaxNumber(this.faxNumberTextField.getText());
        return true;
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("Edit Contact"));
        this.firstNameLabel.setText(JHylaFAX.i18n.tr("First Name"));
        this.lastNameLabel.setText(JHylaFAX.i18n.tr("Last Name"));
        this.companyLabel.setText(JHylaFAX.i18n.tr("Company"));
        this.faxNumberLabel.setText(JHylaFAX.i18n.tr("Fax"));
    }
}

