/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.addressbook;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.addressbook.AbstractContactTransferHandler;
import net.sf.jhylafax.addressbook.ContactTransferable;
import net.sf.jhylafax.addressbook.EditContactDialog;
import net.sf.jhylafax.addressbook.ImportWizard;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.db.ContactDatabase;
import net.wimpi.pim.contact.db.ContactGroup;
import net.wimpi.pim.contact.facades.SimpleContact;
import net.wimpi.pim.contact.io.ContactMarshaller;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.factory.ContactIOFactory;
import net.wimpi.pim.factory.ContactModelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.ColoredTable;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.EraseTextFieldAction;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.ToolBarButton;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.table.StringCellRenderer;
import org.xnap.commons.gui.table.TableLayoutManager;
import org.xnap.commons.gui.table.TableSorter;
import org.xnap.commons.gui.util.DoubleClickListener;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.gui.util.PopupListener;
import org.xnap.commons.io.FileExtensionFilter;
import org.xnap.commons.settings.SettingStore;

public class AddressBook
extends JFrame
implements ListSelectionListener,
LocaleChangeListener {
    private static final Log logger = LogFactory.getLog(AddressBook.class);
    private static final String[] DEFAULT_CONTACT_TABLE_COLUMNS = new String[]{"displayName", "company", "faxNumber"};
    private JMenu addressBookMenu;
    private JTree addressBookTree;
    private DefaultTreeModel addressBookTreeModel;
    private CloseAction closeAction;
    private JTable contactTable;
    private AddressTableModel contactTableModel;
    private DeleteAction deleteAction;
    private Action doubleClickAction;
    private EditAction editAction;
    private ExportAction exportAction;
    private FilterAction filterAction;
    private ImportAction importAction;
    private ContactCollection localAddressBook;
    private JToolBar mainToolBar;
    private NewAction newAction;
    private DefaultMutableTreeNode rootNode;
    private JTextField searchTextField;
    private JSplitPane horizontalSplitPane;
    private JLabel filterLabel;
    private TableLayoutManager contactTableLayoutManager;

    public static void main(String[] args) {
        final AddressBook app = new AddressBook();
        app.setDefaultCloseOperation(2);
        app.restoreLayout(new SettingStore(Settings.backstore));
        try {
            File file = JHylaFAX.getAddressBookFile();
            if (file.exists()) {
                app.load(file);
            }
        }
        catch (Exception e) {
            ErrorDialog.showError(null, JHylaFAX.i18n.tr("Could not load address book"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
        }
        app.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                try {
                    File file = JHylaFAX.getAddressBookFile();
                    app.store(file);
                }
                catch (Exception e) {
                    ErrorDialog.showError(null, JHylaFAX.i18n.tr("Could not store address book"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
                }
            }
        });
        app.setVisible(true);
    }

    public AddressBook() {
        ContactModelFactory cmf = Pim.getContactModelFactory();
        JHylaFAX.initializeToolkit();
        this.initialize();
        ContactDatabase contactDatabase = Pim.getContactDBFactory().createContactDatabase();
        DefaultMutableTreeNode localAddressBookTreeNode = new DefaultMutableTreeNode();
        this.localAddressBook = new ContactCollection(contactDatabase, JHylaFAX.i18n.tr("Local Address Book"));
        localAddressBookTreeNode.setUserObject(this.localAddressBook);
        this.rootNode.add(localAddressBookTreeNode);
        this.addressBookTree.expandPath(new TreePath(this.rootNode));
        this.addressBookTree.setSelectionRow(0);
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportContacts(File file, SimpleContact[] contacts) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ContactIOFactory factory = Pim.getContactIOFactory();
            ContactMarshaller marshaller = factory.createContactMarshaller();
            marshaller.setEncoding("UTF-8");
            for (SimpleContact contact : contacts) {
                marshaller.marshallContact(out, contact.getContact());
            }
        }
        finally {
            out.close();
        }
    }

    public SimpleContact[] getAlllContacts() {
        TableSorter sorter = (TableSorter)this.contactTable.getModel();
        SimpleContact[] result = new SimpleContact[sorter.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            int row = sorter.mapToIndex(i);
            result[i] = this.contactTableModel.getContact(row);
        }
        return result;
    }

    public ContactCollection getSelectedContactCollection() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.addressBookTree.getSelectionPath().getLastPathComponent();
        return (ContactCollection)node.getUserObject();
    }

    public SimpleContact[] getSelectedContacts() {
        int[] rows = this.contactTable.getSelectedRows();
        if (rows.length == 0) {
            return new SimpleContact[0];
        }
        SimpleContact[] result = new SimpleContact[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = ((TableSorter)this.contactTable.getModel()).mapToIndex(rows[i]);
            result[i] = this.contactTableModel.getContact(row);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleContact[] importVCardContacts(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            ContactIOFactory factory = Pim.getContactIOFactory();
            ContactUnmarshaller unmarshaller = factory.createContactUnmarshaller();
            unmarshaller.setEncoding("UTF-8");
            Contact[] contacts = unmarshaller.unmarshallContacts(in);
            if (contacts != null) {
                SimpleContact[] result = new SimpleContact[contacts.length];
                for (int i = 0; i < contacts.length; ++i) {
                    SimpleContact contact = new SimpleContact(contacts[i]);
                    this.getSelectedContactCollection().add(contact);
                    result[i] = contact;
                }
                SimpleContact[] simpleContactArray = result;
                return simpleContactArray;
            }
            SimpleContact[] simpleContactArray = new SimpleContact[]{};
            return simpleContactArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleContact[] importCSVContacts(File file, String separator) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            ArrayList<SimpleContact> contacts = new ArrayList<SimpleContact>();
            while ((line = in.readLine()) != null) {
                SimpleContact contact = new SimpleContact();
                StringTokenizer t = new StringTokenizer(line, separator);
                if (t.hasMoreTokens()) {
                    contact.setFirstname(t.nextToken());
                }
                if (t.hasMoreTokens()) {
                    contact.setLastname(t.nextToken());
                }
                if (t.hasMoreTokens()) {
                    contact.setFaxNumber(t.nextToken());
                }
                if (t.hasMoreTokens()) {
                    contact.setCompany(t.nextToken());
                }
                this.getSelectedContactCollection().add(contact);
                contacts.add(contact);
            }
            SimpleContact[] simpleContactArray = contacts.toArray(new SimpleContact[0]);
            return simpleContactArray;
        }
        finally {
            in.close();
        }
    }

    private void initialize() {
        this.initializeActions();
        this.initializeShortCuts();
        this.initializeMenuBar();
        this.initializeContent();
        this.initializeToolBar();
        this.updateLabels();
    }

    private void initializeActions() {
        this.newAction = new NewAction();
        this.editAction = new EditAction();
        this.deleteAction = new DeleteAction();
        this.importAction = new ImportAction();
        this.exportAction = new ExportAction();
        this.closeAction = new CloseAction();
        this.filterAction = new FilterAction();
    }

    private void initializeContent() {
        this.horizontalSplitPane = new JSplitPane(1);
        this.horizontalSplitPane.setBorder(GUIHelper.createEmptyBorder(5));
        this.rootNode = new DefaultMutableTreeNode();
        this.addressBookTreeModel = new DefaultTreeModel(this.rootNode);
        this.addressBookTree = new JTree(this.addressBookTreeModel);
        this.addressBookTree.setRootVisible(false);
        this.addressBookTree.setCellRenderer(new ContactCollectionCellRenderer());
        this.horizontalSplitPane.add(new JScrollPane(this.addressBookTree));
        JPanel contactPanel = new JPanel();
        contactPanel.setLayout(new BorderLayout(0, 10));
        this.horizontalSplitPane.add(contactPanel);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("min, 3dlu, min, 3dlu, pref:grow, 3dlu, min", ""));
        contactPanel.add((Component)builder.getPanel(), "North");
        this.searchTextField = new JTextField(10);
        EraseTextFieldAction eraseAction = new EraseTextFieldAction(this.searchTextField){

            public void actionPerformed(ActionEvent event) {
                super.actionPerformed(event);
                AddressBook.this.filterAction.actionPerformed(event);
            }
        };
        builder.append(new TabTitleButton(eraseAction));
        this.filterLabel = new JLabel();
        builder.append(this.filterLabel);
        builder.append(this.searchTextField);
        GUIHelper.bindEnterKey(this.searchTextField, this.filterAction);
        builder.append(Builder.createButton(this.filterAction));
        JPopupMenu tablePopupMenu = new JPopupMenu();
        tablePopupMenu.add(Builder.createMenuItem(this.newAction));
        tablePopupMenu.addSeparator();
        tablePopupMenu.add(Builder.createMenuItem(this.editAction));
        tablePopupMenu.addSeparator();
        tablePopupMenu.add(Builder.createMenuItem(this.deleteAction));
        this.contactTableModel = new AddressTableModel();
        TableSorter sorter = new TableSorter(this.contactTableModel);
        this.contactTable = new ColoredTable(sorter);
        this.contactTableLayoutManager = new TableLayoutManager(this.contactTable);
        this.contactTableLayoutManager.addColumnProperties("displayName", "", 180, true);
        this.contactTableLayoutManager.addColumnProperties("company", "", 80, true);
        this.contactTableLayoutManager.addColumnProperties("faxNumber", "", 60, true);
        this.contactTableLayoutManager.initializeTableLayout();
        contactPanel.add((Component)new JScrollPane(this.contactTable), "Center");
        this.contactTable.setShowVerticalLines(true);
        this.contactTable.setShowHorizontalLines(false);
        this.contactTable.setAutoCreateColumnsFromModel(true);
        this.contactTable.setIntercellSpacing(new Dimension(2, 1));
        this.contactTable.setBounds(0, 0, 50, 50);
        this.contactTable.setSelectionMode(2);
        this.contactTable.getSelectionModel().addListSelectionListener(this);
        this.contactTable.addMouseListener(new PopupListener(tablePopupMenu));
        this.contactTable.addMouseListener(new DoubleClickListener(new TableDoubleClickAction()));
        this.contactTable.setTransferHandler(new ContactTransferHandler());
        this.contactTable.setDragEnabled(true);
        this.contactTable.setDefaultRenderer(String.class, new StringCellRenderer());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.horizontalSplitPane, "Center");
    }

    private void initializeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.addressBookMenu = new JMenu();
        menuBar.add(this.addressBookMenu);
        this.addressBookMenu.add(Builder.createMenuItem(this.newAction));
        this.addressBookMenu.addSeparator();
        this.addressBookMenu.add(Builder.createMenuItem(this.editAction));
        this.addressBookMenu.addSeparator();
        this.addressBookMenu.add(Builder.createMenuItem(this.deleteAction));
        this.addressBookMenu.addSeparator();
        this.addressBookMenu.add(Builder.createMenuItem(this.importAction));
        this.addressBookMenu.add(Builder.createMenuItem(this.exportAction));
        this.addressBookMenu.addSeparator();
        this.addressBookMenu.add(Builder.createMenuItem(this.closeAction));
    }

    private void initializeShortCuts() {
    }

    private void initializeToolBar() {
        this.mainToolBar = new JToolBar();
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.mainToolBar.add(Builder.createToolBarButton(this.newAction));
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(Builder.createToolBarButton(this.editAction));
        this.mainToolBar.add(Builder.createToolBarButton(this.deleteAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        try {
            ContactDatabase contactDatabase = (ContactDatabase)in.readObject();
            this.localAddressBook.setDatabase(contactDatabase);
        }
        finally {
            in.close();
        }
    }

    public void saveLayout(SettingStore store) {
        this.contactTableLayoutManager.saveLayout(store, "addressbook.contact");
        store.saveWindow("addressbook.window", this);
        store.saveSplitPane("addressbook.horizontalSplit", this.horizontalSplitPane);
    }

    public void restoreLayout(SettingStore store) {
        this.contactTableLayoutManager.restoreLayout(store, "addressbook.contact");
        store.restoreWindow("addressbook.window", 40, 40, 550, 300, this);
        store.restoreSplitPane("addressbook.horizontalSplit", 150, this.horizontalSplitPane);
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        if (!this.localAddressBook.isChanged()) {
            logger.info("Address book unchanged");
            return;
        }
        ObjectOutputStream in = new ObjectOutputStream(new FileOutputStream(file));
        try {
            in.writeObject(this.localAddressBook.getDatabase());
            logger.info("Stored address book in " + file.getAbsolutePath());
        }
        finally {
            in.close();
        }
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("JHylaFAX Address Book"));
        this.addressBookMenu.setText(JHylaFAX.i18n.tr("Address Book"));
        this.newAction.putValue("Name", JHylaFAX.i18n.tr("New Contact..."));
        this.editAction.putValue("Name", JHylaFAX.i18n.tr("Edit Contact..."));
        this.deleteAction.putValue("Name", JHylaFAX.i18n.tr("Delete Contact"));
        this.importAction.putValue("Name", JHylaFAX.i18n.tr("Import..."));
        this.exportAction.putValue("Name", JHylaFAX.i18n.tr("Export..."));
        this.closeAction.putValue("Name", JHylaFAX.i18n.tr("Close"));
        this.filterLabel.setText(JHylaFAX.i18n.tr("Search for"));
        this.filterAction.putValue("Name", JHylaFAX.i18n.tr("Go"));
        this.contactTableLayoutManager.getTableLayout().setColumnNames(new String[]{JHylaFAX.i18n.tr("Name"), JHylaFAX.i18n.tr("Company"), JHylaFAX.i18n.tr("Fax")});
        GUIHelper.setMnemonics(this.getJMenuBar());
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    public void updateActions() {
        boolean selected = this.contactTable.getSelectedRow() != -1;
        this.editAction.setEnabled(selected);
        this.deleteAction.setEnabled(selected);
    }

    private class ContactTransferHandler
    extends AbstractContactTransferHandler {
        private ContactTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            SimpleContact[] contacts = AddressBook.this.getSelectedContacts();
            if (contacts.length == 0) {
                return super.createTransferable(c);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ContactIOFactory factory = Pim.getContactIOFactory();
            ContactMarshaller marshaller = factory.createContactMarshaller();
            marshaller.setEncoding("UTF-8");
            for (SimpleContact contact : contacts) {
                marshaller.marshallContact(out, contact.getContact());
            }
            return new ContactTransferable(new ByteArrayInputStream(out.toByteArray()));
        }

        public void importData(Contact[] contacts) {
            for (int i = 0; i < contacts.length; ++i) {
                SimpleContact contact = new SimpleContact(contacts[i]);
                AddressBook.this.getSelectedContactCollection().add(contact);
            }
        }
    }

    private class TabTitleButton
    extends ToolBarButton {
        public TabTitleButton(Action action) {
            super(action);
            String iconName = (String)action.getValue("XNapIcon");
            this.setIcon(IconHelper.getTabTitleIcon(iconName));
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    private class TableDoubleClickAction
    extends AbstractXNapAction {
        public void actionPerformed(ActionEvent event) {
            if (AddressBook.this.doubleClickAction == null) {
                if (AddressBook.this.editAction.isEnabled()) {
                    AddressBook.this.editAction.actionPerformed(event);
                }
            } else if (AddressBook.this.doubleClickAction.isEnabled()) {
                AddressBook.this.doubleClickAction.actionPerformed(event);
            }
        }
    }

    private class NewAction
    extends AbstractXNapAction {
        public NewAction() {
            this.putValue("XNapIcon", "filenew.png");
        }

        public void actionPerformed(ActionEvent e) {
            SimpleContact contact = new SimpleContact();
            EditContactDialog dialog = new EditContactDialog(AddressBook.this, contact);
            dialog.setModal(true);
            dialog.setLocationRelativeTo(AddressBook.this);
            dialog.setVisible(true);
            if (dialog.isOkay()) {
                AddressBook.this.getSelectedContactCollection().add(contact);
            }
        }
    }

    private class ImportAction
    extends AbstractXNapAction {
        public ImportAction() {
            this.putValue("XNapIcon", "fileimport.png");
        }

        public void actionPerformed(ActionEvent e) {
            ImportWizard wizard = new ImportWizard(AddressBook.this);
            wizard.setLocationRelativeTo(AddressBook.this);
            wizard.setVisible(true);
        }
    }

    private class FilterAction
    extends AbstractXNapAction {
        public FilterAction() {
            this.putValue("XNapIcon", "filter.png");
        }

        public void actionPerformed(ActionEvent e) {
            AddressBook.this.getSelectedContactCollection().setFilterText(AddressBook.this.searchTextField.getText());
        }
    }

    private class ExportAction
    extends AbstractXNapAction {
        public ExportAction() {
            this.putValue("XNapIcon", "fileexport.png");
        }

        public void actionPerformed(ActionEvent event) {
            if (AddressBook.this.contactTableModel.getRowCount() == 0) {
                Dialogs.showInfo(AddressBook.this, JHylaFAX.i18n.tr("No data to export"), JHylaFAX.i18n.tr("JHylaFAX Addressbook Error"));
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new FileExtensionFilter(JHylaFAX.i18n.tr("vCards (*.vcf)"), ".vcf"));
            if (fileChooser.showSaveDialog(AddressBook.this) == 0) {
                try {
                    SimpleContact[] contacts = AddressBook.this.getSelectedContacts();
                    if (contacts.length == 0) {
                        contacts = AddressBook.this.getAlllContacts();
                    }
                    AddressBook.this.exportContacts(fileChooser.getSelectedFile(), contacts);
                    Dialogs.showInfo(AddressBook.this, JHylaFAX.i18n.tr("Exported {0} contacts", contacts.length), JHylaFAX.i18n.tr("JHylaFAX Address Book"));
                }
                catch (Exception e) {
                    ErrorDialog.showError(AddressBook.this, JHylaFAX.i18n.tr("Could not export to file \"{0}\""), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
                }
            }
        }
    }

    private class EditAction
    extends AbstractXNapAction {
        public EditAction() {
            this.putValue("XNapIcon", "edit.png");
        }

        public void actionPerformed(ActionEvent e) {
            SimpleContact[] contact = AddressBook.this.getSelectedContacts();
            EditContactDialog dialog = new EditContactDialog(AddressBook.this, contact[0]);
            dialog.setModal(true);
            dialog.setLocationRelativeTo(AddressBook.this);
            dialog.setVisible(true);
            if (dialog.isOkay()) {
                AddressBook.this.getSelectedContactCollection().changed(contact[0]);
            }
        }
    }

    private class DeleteAction
    extends AbstractXNapAction {
        public DeleteAction() {
            this.putValue("XNapIcon", "editdelete.png");
        }

        public void actionPerformed(ActionEvent e) {
            SimpleContact[] contacts = AddressBook.this.getSelectedContacts();
            if (Dialogs.showConfirmDialog(AddressBook.this, JHylaFAX.i18n.tr("Do you really want to delete the selected contacts?"), JHylaFAX.i18n.tr("Delete Contacts"), 0, Settings.CONFIRM_DELETE) == 0) {
                for (int i = 0; i < contacts.length; ++i) {
                    AddressBook.this.getSelectedContactCollection().remove(contacts[i]);
                }
            }
        }
    }

    private static class ContactCollectionCellRenderer
    extends DefaultTreeCellRenderer {
        Icon bookIcon = IconHelper.getTreeIcon("contents.png");
        Icon groupIcon = IconHelper.getTreeIcon("kdmconfig.png");

        private ContactCollectionCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof ContactCollection) {
                ContactCollection collection = (ContactCollection)node.getUserObject();
                this.setIcon(collection.getGroup() != null ? this.groupIcon : this.bookIcon);
            }
            return this;
        }
    }

    private class ContactCollection {
        private ContactDatabase database;
        private String filterText;
        private ContactGroup group;
        private String name;
        private ContactCollection parent;
        private boolean changed;

        public ContactCollection(ContactCollection parent, ContactGroup group) {
            this.parent = parent;
            this.group = group;
        }

        public ContactCollection(ContactDatabase database, String name) {
            this.database = database;
            this.name = name;
        }

        public void add(SimpleContact contact) {
            this.getDatabase().getContactCollection().add(contact.getContact());
            if (this.group != null) {
                this.group.addContact(contact.getContact());
            }
            if (this.matches(contact)) {
                AddressBook.this.contactTableModel.add(contact);
            }
            this.changed = true;
        }

        public void changed(SimpleContact contact) {
            if (!this.matches(contact)) {
                AddressBook.this.contactTableModel.remove(contact);
            } else {
                AddressBook.this.contactTableModel.update(contact);
            }
            this.changed = true;
        }

        public ContactDatabase getDatabase() {
            return this.parent != null ? this.parent.getDatabase() : this.database;
        }

        public ContactGroup getGroup() {
            return this.group;
        }

        public boolean isChanged() {
            return this.changed;
        }

        private boolean matches(SimpleContact contact) {
            if (this.filterText == null || this.filterText.length() == 0) {
                return true;
            }
            return contact.getFirstname().toLowerCase().contains(this.filterText) || contact.getLastname().toLowerCase().contains(this.filterText) || contact.getCompany().toLowerCase().contains(this.filterText) || contact.getFaxNumber().toLowerCase().contains(this.filterText);
        }

        public void remove(SimpleContact contact) {
            this.getDatabase().getContactCollection().remove(contact.getContact());
            if (this.group != null) {
                this.group.removeContact(contact.getContact());
            }
            if (this.matches(contact)) {
                AddressBook.this.contactTableModel.remove(contact);
            }
            this.changed = true;
        }

        public void resync() {
            Contact[] contacts = this.group != null ? this.group.listContacts() : this.database.getContactCollection().toArray();
            ArrayList<SimpleContact> data = new ArrayList<SimpleContact>(contacts.length);
            for (int i = 0; i < contacts.length; ++i) {
                SimpleContact contact = new SimpleContact(contacts[i]);
                if (!this.matches(contact)) continue;
                data.add(contact);
            }
            AddressBook.this.contactTableModel.setData(data);
            AddressBook.this.valueChanged(null);
        }

        public void setDatabase(ContactDatabase database) {
            this.database = database;
            this.changed = false;
            this.resync();
        }

        public void setFilterText(String filterText) {
            this.filterText = filterText.toLowerCase();
            this.resync();
        }

        public String toString() {
            return this.group != null ? this.group.getName() : this.name;
        }
    }

    private class CloseAction
    extends AbstractXNapAction {
        public void actionPerformed(ActionEvent event) {
            AddressBook.this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddressTableModel
    extends AbstractTableModel {
        private static final Class[] columnClasses = new Class[]{String.class, String.class, String.class};
        private List<SimpleContact> data = new ArrayList<SimpleContact>();

        public void add(SimpleContact contact) {
            this.data.add(contact);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return columnClasses.length;
        }

        public SimpleContact getContact(int row) {
            return this.data.get(row);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            SimpleContact contact = this.data.get(row);
            switch (column) {
                case 0: {
                    return contact.getFirstname() + " " + contact.getLastname();
                }
                case 1: {
                    return contact.getCompany();
                }
                case 2: {
                    return contact.getFaxNumber();
                }
            }
            return null;
        }

        public int indexOf(SimpleContact contact) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.data.get(i).getContact().equals(contact.getContact())) continue;
                return i;
            }
            return -1;
        }

        public void remove(SimpleContact contact) {
            int i = this.indexOf(contact);
            if (i != -1) {
                this.data.remove(i);
                this.fireTableRowsDeleted(i, i);
            }
        }

        public void setData(List<SimpleContact> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        public void update(SimpleContact contact) {
            int i = this.indexOf(contact);
            if (i != -1) {
                this.fireTableRowsUpdated(i, i);
            }
        }
    }
}

