/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax.addressbook;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.sf.jhylafax.addressbook.ContactTransferable;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.ContactUnmarshaller;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.factory.ContactIOFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractContactTransferHandler
extends TransferHandler {
    private static final Log logger = LogFactory.getLog(AbstractContactTransferHandler.class);

    public abstract void importData(Contact[] var1);

    public boolean importData(JComponent component, Transferable transferable) {
        if (this.canImport(component, transferable.getTransferDataFlavors())) {
            try {
                ContactIOFactory factory = Pim.getContactIOFactory();
                ContactUnmarshaller unmarshaller = factory.createContactUnmarshaller();
                InputStream in = (InputStream)transferable.getTransferData(ContactTransferable.VCARD_FLAVOR);
                unmarshaller.setEncoding("UTF-8");
                Contact[] contacts = unmarshaller.unmarshallContacts(in);
                if (contacts != null && contacts.length > 0) {
                    this.importData(contacts);
                }
                return true;
            }
            catch (Exception e) {
                logger.debug("Error during import", e);
            }
        }
        return false;
    }

    public boolean canImport(JComponent component, DataFlavor[] transferFlavors) {
        if (transferFlavors == null) {
            return false;
        }
        for (int i = 0; i < transferFlavors.length; ++i) {
            if (!ContactTransferable.VCARD_FLAVOR.equals(transferFlavors[i])) continue;
            return true;
        }
        return false;
    }
}

