/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.table.DefaultTableCellRenderer;

class TimeCellRenderer
extends DefaultTableCellRenderer {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private DateFormat tooltipFormat = DateFormat.getDateTimeInstance(1, 1);

    public TimeCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    protected void setValue(Object value) {
        if (value == null) {
            super.setValue(null);
        } else {
            Date date = (Date)value;
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Date today = cal.getTime();
            cal.setTimeInMillis(cal.getTimeInMillis() + 86400000L);
            Date tomorrow = cal.getTime();
            if (date.after(today) && date.before(tomorrow)) {
                super.setValue(this.timeFormat.format(date));
            } else {
                super.setValue(this.dateFormat.format(date));
            }
            this.setToolTipText(this.tooltipFormat.format(date));
        }
    }
}

