/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.jhylafax.ExecutableChooserPanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.gui.wizard.WizardDialog;
import org.xnap.commons.gui.wizard.WizardPage;
import org.xnap.commons.util.SystemHelper;

public class SettingsWizard
extends WizardDialog
implements LocaleChangeListener {
    private static final int WIDTH = 500;
    private GeneralPage generalPage;
    private NotifyPage notifyPage;
    private ProgramsPage programsPage;
    private IntroductionPage introPage = new IntroductionPage();

    public SettingsWizard(JFrame owner) {
        super(owner);
        this.addPage(this.introPage, "intro");
        this.generalPage = new GeneralPage();
        this.addPage(this.generalPage, "general");
        this.notifyPage = new NotifyPage();
        this.addPage(this.notifyPage, "notify");
        this.programsPage = new ProgramsPage();
        this.addPage(this.programsPage, "programs");
        this.updateLabels();
        this.revert();
        this.pack();
    }

    private DefaultFormBuilder createForm() {
        FormLayout layout = new FormLayout("left:max(20dlu;pref), 3dlu, pref, pref:grow(0.5), pref:grow(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        return builder;
    }

    public void revert() {
        this.generalPage.revert();
        this.notifyPage.revert();
        this.programsPage.revert();
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("JHylaFAX Setup Wizard"));
        this.introPage.updateLabels();
        this.generalPage.updateLabels();
        this.notifyPage.updateLabels();
        this.programsPage.updateLabels();
    }

    private class ProgramsPage
    implements WizardPage {
        private DefaultFormBuilder builder;
        private ExecutableChooserPanel viewerPathFileChooserPanel;
        private JLabel viewerPathLabel;
        private ExecutableChooserPanel docViewerPathFileChooserPanel;
        private JLabel docViewerPathLabel;
        private String docViewer;
        private String viewer;
        private SearchProgramsAction searchProgramsAction;
        private JLabel viewerDescriptionLabel;
        private JLabel searchDescriptionLabel;
        private JLabel docViewerDescriptionLabel;
        private JLabel descriptionLabel;

        public ProgramsPage() {
            this.builder = SettingsWizard.this.createForm();
            this.descriptionLabel = new JLabel();
            this.builder.append((Component)this.descriptionLabel, 5);
            this.builder.nextLine();
            this.viewerDescriptionLabel = new JLabel();
            this.builder.append((Component)this.viewerDescriptionLabel, 5);
            this.builder.nextLine();
            this.viewerPathFileChooserPanel = new ExecutableChooserPanel(20);
            this.viewerPathFileChooserPanel.setDialogParent(SettingsWizard.this);
            this.viewerPathLabel = this.builder.append("", (Component)this.viewerPathFileChooserPanel, 3);
            this.builder.nextLine();
            this.docViewerDescriptionLabel = new JLabel();
            this.builder.append((Component)this.docViewerDescriptionLabel, 5);
            this.builder.nextLine();
            this.docViewerPathFileChooserPanel = new ExecutableChooserPanel(20);
            this.docViewerPathFileChooserPanel.setDialogParent(SettingsWizard.this);
            this.docViewerPathLabel = this.builder.append("", (Component)this.docViewerPathFileChooserPanel, 3);
            this.builder.nextLine();
            this.searchDescriptionLabel = new JLabel();
            this.builder.append((Component)this.searchDescriptionLabel, 5);
            this.builder.nextLine();
            this.builder.append("");
            this.builder.nextLine();
            this.searchProgramsAction = new SearchProgramsAction();
            this.builder.append(Builder.createButton(this.searchProgramsAction));
            this.builder.nextLine();
        }

        public void revert() {
            this.searchForPrograms();
            if (!"".equals(Settings.VIEWER_PATH.getValue())) {
                this.viewerPathFileChooserPanel.getTextField().setText((String)Settings.VIEWER_PATH.getValue());
            } else {
                this.viewerPathFileChooserPanel.getTextField().setText(this.viewer);
            }
            if (!"".equals(Settings.DOC_VIEWER_PATH.getValue())) {
                this.docViewerPathFileChooserPanel.getTextField().setText((String)Settings.DOC_VIEWER_PATH.getValue());
            } else {
                this.docViewerPathFileChooserPanel.getTextField().setText(this.docViewer);
            }
        }

        private void searchForPrograms() {
            if (SystemHelper.IS_WINDOWS) {
                if (SystemHelper.IS_WINDOWS_XP) {
                    this.viewer = "rundll32.exe shimgvw.dll,ImageView_Fullscreen $f";
                } else {
                    String path = System.getenv("ProgramFiles");
                    this.viewer = this.searchExecutable(new String[][]{{path + "\\Windows NT\\Accessories\\ImageVue", "kodakimg.exe", "$f"}});
                }
                this.docViewer = this.searchExecutable(new String[][]{{null, "gsview32.exe", "$f"}});
            } else {
                this.viewer = this.searchExecutable(new String[][]{{"/usr/bin", "kfax", "$f"}});
                this.docViewer = this.searchExecutable(new String[][]{{"/usr/bin", "gv", "$f"}, {"/usr/bin", "kghostview", "$f"}});
            }
        }

        private String searchExecutable(String[][] programs) {
            return programs[0][1] + " " + programs[0][2];
        }

        public void updateLabels() {
            this.descriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("JHylaFAX depends on external programs to display received and sent faxes. You can either enter the path of a program or use Search to let JHylaFAX suggest a program.You may use $f as a placeholder for the filename that is passed as a parameter."), 500));
            this.viewerDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter the path of a programm that can handle TIFF G3 files:"), 500));
            this.viewerPathLabel.setText(JHylaFAX.i18n.tr("Fax Viewer"));
            this.docViewerDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter the path of a programm that can handle PostScript files:"), 500));
            this.docViewerPathLabel.setText(JHylaFAX.i18n.tr("Document Viewer"));
            this.searchProgramsAction.putValue("Name", JHylaFAX.i18n.tr("Search"));
        }

        public boolean apply() {
            Settings.VIEWER_PATH.setValue(this.viewerPathFileChooserPanel.getTextField().getText());
            Settings.DOC_VIEWER_PATH.setValue(this.docViewerPathFileChooserPanel.getTextField().getText());
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("Viewer programs are configured here.");
        }

        public Icon getIcon() {
            return IconHelper.getTitleIcon("misc.png");
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("External Programs");
        }

        private class SearchProgramsAction
        extends AbstractXNapAction {
            public SearchProgramsAction() {
                this.putValue("XNapIcon", "find.png");
            }

            public void actionPerformed(ActionEvent e) {
                ProgramsPage.this.searchForPrograms();
                ProgramsPage.this.viewerPathFileChooserPanel.getTextField().setText(ProgramsPage.this.viewer);
                ProgramsPage.this.docViewerPathFileChooserPanel.getTextField().setText(ProgramsPage.this.docViewer);
            }
        }
    }

    private class NotifyPage
    implements WizardPage {
        private JTextField fullnameTextField;
        private DefaultFormBuilder builder;
        private JTextField emailTextField;
        private JLabel emailLabel;
        private JLabel fullnameLabel;
        private JLabel fullnameDescriptionLabel;
        private JLabel emailDescriptionLabel;

        public NotifyPage() {
            this.builder = SettingsWizard.this.createForm();
            this.fullnameDescriptionLabel = new JLabel();
            this.builder.append((Component)this.fullnameDescriptionLabel, 5);
            this.builder.nextLine();
            this.fullnameTextField = new JTextField(20);
            this.fullnameLabel = this.builder.append("", (Component)this.fullnameTextField, 3);
            this.builder.nextLine();
            this.emailDescriptionLabel = new JLabel();
            this.builder.append((Component)this.emailDescriptionLabel, 5);
            this.builder.nextLine();
            this.emailTextField = new JTextField(20);
            this.emailLabel = this.builder.append("", (Component)this.emailTextField, 3);
            this.builder.nextLine();
        }

        public void updateLabels() {
            this.fullnameDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter a name that is used to identify the sender:"), 500));
            this.fullnameLabel.setText(JHylaFAX.i18n.tr("Name"));
            this.emailDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter an email address to receive notification when a fax has been sent or cancelled:"), 500));
            this.emailLabel.setText(JHylaFAX.i18n.tr("Email"));
        }

        public boolean apply() {
            Settings.FULLNAME.setValue(this.fullnameTextField.getText());
            Settings.EMAIL.setValue(this.emailTextField.getText());
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("The sender's name and an email address for notifications are configured here.");
        }

        public Icon getIcon() {
            return IconHelper.getTitleIcon("kontact_mail.png");
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("Sender and Notification");
        }

        public void revert() {
            this.fullnameTextField.setText((String)Settings.FULLNAME.getValue());
            this.emailTextField.setText((String)Settings.EMAIL.getValue());
        }
    }

    private class GeneralPage
    implements WizardPage {
        private DefaultFormBuilder builder;
        private JLabel hostnameLabel;
        private JTextField hostnameTextField;
        private JLabel passwordLabel;
        private JPasswordField passwordTextField;
        private JLabel portLabel;
        private JSpinner portSpinner;
        private SpinnerNumberModel portSpinnerModel;
        private JLabel usernameLabel;
        private JTextField usernameTextField;
        private JLabel hostnameDescriptionLabel;
        private JLabel usernameDescriptionLabel;

        public GeneralPage() {
            this.builder = SettingsWizard.this.createForm();
            this.hostnameDescriptionLabel = new JLabel();
            this.builder.append((Component)this.hostnameDescriptionLabel, 5);
            this.builder.nextLine();
            this.hostnameTextField = new JTextField(20);
            this.hostnameLabel = this.builder.append("", (Component)this.hostnameTextField, 3);
            this.builder.nextLine();
            this.portSpinnerModel = new SpinnerNumberModel();
            this.portSpinnerModel.setMinimum(Integer.valueOf(1));
            this.portSpinnerModel.setMaximum(Integer.valueOf(65535));
            this.portSpinner = new JSpinner(this.portSpinnerModel);
            this.portSpinner.setEditor(new JSpinner.NumberEditor(this.portSpinner, "#"));
            this.portLabel = this.builder.append("", (Component)this.portSpinner);
            this.builder.nextLine();
            this.usernameDescriptionLabel = new JLabel();
            this.builder.append((Component)this.usernameDescriptionLabel, 5);
            this.builder.nextLine();
            this.usernameTextField = new JTextField(20);
            this.usernameLabel = this.builder.append("", (Component)this.usernameTextField, 3);
            this.builder.nextLine();
        }

        public boolean apply() {
            Settings.HOSTNAME.setValue(this.hostnameTextField.getText());
            Settings.PORT.setValue(this.portSpinnerModel.getNumber().intValue());
            Settings.USERNAME.setValue(this.usernameTextField.getText());
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("The connection to the fax server is configured here.");
        }

        public Icon getIcon() {
            return IconHelper.getTitleIcon("connect_established.png");
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("HylaFAX Server Connection");
        }

        public void revert() {
            this.hostnameTextField.setText((String)Settings.HOSTNAME.getValue());
            this.portSpinnerModel.setValue(Settings.PORT.getValue());
            this.usernameTextField.setText((String)Settings.USERNAME.getValue());
        }

        public void updateLabels() {
            this.hostnameDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter the host and port of your HylaFAX server:"), 500));
            this.hostnameLabel.setText(JHylaFAX.i18n.tr("Host"));
            this.portLabel.setText(JHylaFAX.i18n.tr("Port"));
            this.usernameDescriptionLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("Enter a username that is used to login to the server:"), 500));
            this.usernameLabel.setText(JHylaFAX.i18n.tr("Username"));
        }
    }

    private class IntroductionPage
    implements WizardPage {
        private DefaultFormBuilder builder;
        private JLabel introLabel;

        public IntroductionPage() {
            this.builder = SettingsWizard.this.createForm();
            this.introLabel = this.builder.append("");
            this.builder.nextLine();
        }

        public boolean apply() {
            if (!((Boolean)Settings.HAS_SEEN_WIZARD.getValue()).booleanValue()) {
                JHylaFAX.getInstance().resetAllTables();
                Settings.HAS_SEEN_WIZARD.setValue(true);
            }
            return true;
        }

        public String getDescription() {
            return JHylaFAX.i18n.tr("Easily setup JHylaFAX in 3 steps.");
        }

        public Icon getIcon() {
            return null;
        }

        public JComponent getPanel() {
            return this.builder.getPanel();
        }

        public String getTitle() {
            return JHylaFAX.i18n.tr("JHylaFAX Setup Wizard");
        }

        public void updateLabels() {
            this.introLabel.setText(GUIHelper.tt(JHylaFAX.i18n.tr("JHylaFAX is a Java client for the HylaFAX fax server. It is licensed under the <b>General Public License (GPL)</b>, see about for details.<p><p>Setup requires three simple steps:<ol><li>Server connection and authentication<li>Sender and notifcation<li>External viewer programs</ol><p>Thank you for using JHylaFAX. "), 500));
        }
    }
}

