/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.jhylafax.ExecutableChooserPanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobPanel;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.FileChooserPanel;
import org.xnap.commons.gui.completion.CompletionModeFactory;
import org.xnap.commons.gui.settings.SettingComponentMediator;
import org.xnap.commons.gui.util.EnableListener;
import org.xnap.commons.gui.util.WhatsThis;

public class SettingsDialog
extends DefaultDialog
implements LocaleChangeListener {
    private JPanel connectionPanel;
    private JLabel hostnameLabel;
    private JTextField hostnameTextField;
    private JPanel jobPanel;
    private JobPanel jobParameterPanel;
    private JTabbedPane mainTabbedPane;
    private JLabel passwordLabel;
    private JTextField passwordTextField;
    private JLabel portLabel;
    private JSpinner portSpinner;
    private JLabel usernameLabel;
    private JTextField usernameTextField;
    private JLabel languageLabel;
    private DefaultComboBoxModel languageModel;
    private JCheckBox confirmNonPSCheckBox;
    private JCheckBox confirmDeleteCheckBox;
    private JRadioButton internalCoverRadionButton;
    private JLabel viewerPathLabel;
    private JLabel docViewerPathLabel;
    private JPanel pathsPanel;
    private JPanel monitorPanel;
    private JRadioButton externalCoverRadionButton;
    private FileChooserPanel externalCoverPathFileChooserPanel;
    private ExecutableChooserPanel viewerPathFileChooserPanel;
    private ExecutableChooserPanel docViewerPathFileChooserPanel;
    private JLabel passwordInfoLabel;
    private JCheckBox usePassiveCheckBox;
    private JPanel generalPanel;
    private SpinnerNumberModel portSpinnerModel;
    private DefaultComboBoxModel completionModeModel;
    private JLabel completionModeLabel;
    private JCheckBox sendCoverAsDocumentCheckBox;
    private JCheckBox updateOnStartupCheckBox;
    private JCheckBox showPollqCheckBox;
    private SettingComponentMediator settingMediator = new SettingComponentMediator();
    private JCheckBox adminModeCheckBox;
    private JPasswordField adminPasswordTextField;
    private JCheckBox autoUpdateCheckBox;
    private SpinnerNumberModel autoUpdateIntervalModel;
    private JSpinner autoUpdateIntervalSpinner;
    private JLabel autoUpdateIntervalLabel;
    private JCheckBox monitorPathCheckBox;
    private SpinnerNumberModel monitorPathIntervalModel;
    private JSpinner monitorPathIntervalSpinner;
    private JLabel monitorPathIntervalLabel;
    private ExecutableChooserPanel monitorPathFileChooserPanel;
    private JLabel monitorPathLabel;
    private FileChooserPanel addressBookPathFileChooserPanel;
    private JCheckBox customizeAddressBookCheckBox;

    public SettingsDialog(JFrame owner) {
        super((Frame)owner, BUTTON_OKAY | BUTTON_APPLY | BUTTON_CANCEL | BUTTON_CONTEXT_HELP);
        this.mainTabbedPane = new JTabbedPane();
        this.setMainComponent(this.mainTabbedPane);
        this.initializeConnectionForm();
        this.initializeGeneralForm();
        this.initializeJobForm();
        this.initializePathForm();
        this.initializeMonitorForm();
        this.updateLabels();
        this.revert();
        this.pack();
    }

    public boolean apply() {
        this.settingMediator.apply();
        Settings.LOCALE.setValue((Locale)this.languageModel.getSelectedItem());
        Settings.DEFAULT_COMPLETION_MODE.setValue(((CompletionModeFactory.CompletionModeInfo)this.completionModeModel.getSelectedItem()).getClassName());
        this.jobParameterPanel.applyToSettings();
        Settings.VIEWER_PATH.setValue(this.viewerPathFileChooserPanel.getTextField().getText());
        Settings.DOC_VIEWER_PATH.setValue(this.docViewerPathFileChooserPanel.getTextField().getText());
        Settings.USE_INTERNAL_COVER.setValue(this.internalCoverRadionButton.isSelected());
        Settings.COVER_PATH.setValue(this.externalCoverPathFileChooserPanel.getTextField().getText());
        Settings.MONITOR_PATH_INTERVAL.setValue(this.monitorPathIntervalModel.getNumber().intValue());
        JHylaFAX.getInstance().settingsUpdated();
        return true;
    }

    private DefaultFormBuilder createForm() {
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref, pref:grow(0.5), pref:grow(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        return builder;
    }

    public void initializeConnectionForm() {
        DefaultFormBuilder builder = this.createForm();
        this.connectionPanel = builder.getPanel();
        this.mainTabbedPane.add(this.connectionPanel);
        builder.appendSeparator(JHylaFAX.i18n.tr("HylaFAX Server"));
        this.hostnameTextField = new JTextField(20);
        this.settingMediator.add(Settings.HOSTNAME, this.hostnameTextField);
        this.hostnameLabel = builder.append("", (Component)this.hostnameTextField, 3);
        builder.nextLine();
        this.portSpinnerModel = new SpinnerNumberModel();
        this.portSpinnerModel.setMinimum(Integer.valueOf(1));
        this.portSpinnerModel.setMaximum(Integer.valueOf(65535));
        this.settingMediator.add(Settings.PORT, this.portSpinnerModel);
        this.portSpinner = new JSpinner(this.portSpinnerModel);
        this.portSpinner.setEditor(new JSpinner.NumberEditor(this.portSpinner, "#"));
        this.portLabel = builder.append("", (Component)this.portSpinner);
        builder.nextLine();
        this.usePassiveCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.USE_PASSIVE, this.usePassiveCheckBox);
        builder.append("", (Component)this.usePassiveCheckBox, 3);
        builder.nextLine();
        builder.appendSeparator(JHylaFAX.i18n.tr("Authentication"));
        this.usernameTextField = new JTextField(20);
        this.settingMediator.add(Settings.USERNAME, this.usernameTextField);
        this.usernameLabel = builder.append("", (Component)this.usernameTextField, 3);
        builder.nextLine();
        this.passwordInfoLabel = new JLabel();
        this.passwordInfoLabel.setForeground(Color.RED);
        builder.append((Component)this.passwordInfoLabel, 5);
        builder.nextLine();
        this.passwordTextField = new JPasswordField(20);
        this.settingMediator.add(Settings.PASSWORD, this.passwordTextField);
        this.passwordLabel = builder.append("", (Component)this.passwordTextField, 3);
        builder.nextLine();
        this.adminModeCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.ADMIN_MODE, this.adminModeCheckBox);
        this.adminPasswordTextField = new JPasswordField(20);
        this.settingMediator.add(Settings.ADMIN_PASSWORD, this.adminPasswordTextField);
        builder.append(this.adminModeCheckBox);
        builder.append((Component)this.adminPasswordTextField, 3);
        builder.nextLine();
        this.adminModeCheckBox.addItemListener(new EnableListener(this.adminPasswordTextField));
        builder.appendSeparator(JHylaFAX.i18n.tr("Status Update"));
        this.updateOnStartupCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.UPDATE_ON_STARTUP, this.updateOnStartupCheckBox);
        builder.append((Component)this.updateOnStartupCheckBox, 4);
        builder.nextLine();
        this.autoUpdateCheckBox = new JCheckBox();
        this.autoUpdateCheckBox.setEnabled(false);
        this.settingMediator.add(Settings.DO_AUTO_UPDATE, this.autoUpdateCheckBox);
        builder.nextLine();
        this.autoUpdateIntervalModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 30);
        this.settingMediator.add(Settings.AUTO_UPDATE_INTERVAL, this.autoUpdateIntervalModel);
        this.autoUpdateIntervalSpinner = new JSpinner(this.autoUpdateIntervalModel);
        this.autoUpdateIntervalSpinner.setEditor(new JSpinner.NumberEditor(this.autoUpdateIntervalSpinner, "# s"));
        this.autoUpdateIntervalLabel = new JLabel();
        builder.nextLine();
        this.autoUpdateCheckBox.addItemListener(new EnableListener(this.autoUpdateIntervalSpinner));
    }

    public void initializeGeneralForm() {
        DefaultFormBuilder builder = this.createForm();
        this.generalPanel = builder.getPanel();
        this.mainTabbedPane.add(this.generalPanel);
        builder.appendSeparator(JHylaFAX.i18n.tr("Appearance"));
        this.showPollqCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.SHOW_POLLQ, this.showPollqCheckBox);
        builder.append((Component)this.showPollqCheckBox, 5);
        builder.nextLine();
        this.languageModel = new DefaultComboBoxModel();
        JComboBox<Object> lanuageComboBox = new JComboBox<Object>(this.languageModel);
        lanuageComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Locale)value).getDisplayName());
                }
                return this;
            }
        });
        this.languageLabel = builder.append("", lanuageComboBox, 2);
        builder.nextLine();
        builder.appendSeparator(JHylaFAX.i18n.tr("Behavior"));
        this.completionModeModel = new DefaultComboBoxModel();
        JComboBox<Object> completionModeComboBox = new JComboBox<Object>(this.completionModeModel);
        completionModeComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((CompletionModeFactory.CompletionModeInfo)value).getName());
                }
                return this;
            }
        });
        this.completionModeLabel = builder.append("", completionModeComboBox, 2);
        builder.nextLine();
        builder.appendSeparator(JHylaFAX.i18n.tr("Confirmations"));
        this.confirmNonPSCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.CONFIRM_NONPS, this.confirmNonPSCheckBox);
        builder.append((Component)this.confirmNonPSCheckBox, 5);
        builder.nextLine();
        this.confirmDeleteCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.CONFIRM_DELETE, this.confirmDeleteCheckBox);
        builder.append((Component)this.confirmDeleteCheckBox, 5);
        builder.nextLine();
    }

    private void initializeJobForm() {
        DefaultFormBuilder builder = this.createForm();
        this.jobPanel = builder.getPanel();
        this.mainTabbedPane.add(this.jobPanel);
        this.jobParameterPanel = new JobPanel(false);
        builder.append((Component)this.jobParameterPanel, 5);
    }

    public void initializePathForm() {
        DefaultFormBuilder builder = this.createForm();
        this.pathsPanel = builder.getPanel();
        this.mainTabbedPane.add(this.pathsPanel);
        builder.appendSeparator(JHylaFAX.i18n.tr("Programs"));
        this.viewerPathFileChooserPanel = new ExecutableChooserPanel(20);
        this.viewerPathFileChooserPanel.setDialogParent(this);
        this.viewerPathLabel = builder.append("", (Component)this.viewerPathFileChooserPanel, 3);
        builder.nextLine();
        this.docViewerPathFileChooserPanel = new ExecutableChooserPanel(20);
        this.docViewerPathFileChooserPanel.setDialogParent(this);
        this.docViewerPathLabel = builder.append("", (Component)this.docViewerPathFileChooserPanel, 3);
        builder.nextLine();
        builder.appendSeparator(JHylaFAX.i18n.tr("Address Book"));
        this.customizeAddressBookCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.CUSTOMIZE_ADDRESS_BOOK_FILENAME, this.customizeAddressBookCheckBox);
        builder.append((Component)this.customizeAddressBookCheckBox, 5);
        builder.nextLine();
        this.addressBookPathFileChooserPanel = new FileChooserPanel(20);
        this.settingMediator.add(Settings.ADDRESS_BOOK_FILENAME, this.addressBookPathFileChooserPanel.getTextField());
        this.addressBookPathFileChooserPanel.setDialogParent(this);
        builder.append((Component)this.addressBookPathFileChooserPanel, 5);
        builder.nextLine();
        this.customizeAddressBookCheckBox.addItemListener(new EnableListener(this.addressBookPathFileChooserPanel));
        builder.appendSeparator(JHylaFAX.i18n.tr("Cover"));
        this.internalCoverRadionButton = new JRadioButton();
        this.internalCoverRadionButton.setSelected(true);
        builder.append((Component)this.internalCoverRadionButton, 5);
        builder.nextLine();
        this.externalCoverRadionButton = new JRadioButton();
        this.externalCoverPathFileChooserPanel = new FileChooserPanel(20);
        this.externalCoverPathFileChooserPanel.setEnabled(false);
        this.externalCoverPathFileChooserPanel.setDialogParent(this);
        builder.append((Component)this.externalCoverRadionButton, 5);
        builder.nextLine();
        this.externalCoverRadionButton.addItemListener(new EnableListener(this.externalCoverPathFileChooserPanel));
        builder.append((Component)this.externalCoverPathFileChooserPanel, 5);
        builder.nextLine();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.internalCoverRadionButton);
        buttonGroup.add(this.externalCoverRadionButton);
        this.sendCoverAsDocumentCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.SEND_COVER_AS_DOCUMENT, this.sendCoverAsDocumentCheckBox);
        builder.append((Component)this.sendCoverAsDocumentCheckBox, 5);
        builder.nextLine();
    }

    public void initializeMonitorForm() {
        DefaultFormBuilder builder = this.createForm();
        this.monitorPanel = builder.getPanel();
        this.mainTabbedPane.add(this.monitorPanel);
        this.monitorPathCheckBox = new JCheckBox();
        this.settingMediator.add(Settings.DO_MONITOR_PATH, this.monitorPathCheckBox);
        builder.append((Component)this.monitorPathCheckBox, 4);
        builder.nextLine();
        this.monitorPathFileChooserPanel = new ExecutableChooserPanel(20);
        this.monitorPathFileChooserPanel.setDialogParent(this);
        this.settingMediator.add(Settings.MONITOR_PATH, this.monitorPathFileChooserPanel.getTextField());
        this.monitorPathLabel = builder.append("", (Component)this.monitorPathFileChooserPanel, 3);
        builder.nextLine();
        this.monitorPathIntervalModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 30);
        this.monitorPathIntervalSpinner = new JSpinner(this.monitorPathIntervalModel);
        this.monitorPathIntervalSpinner.setEditor(new JSpinner.NumberEditor(this.monitorPathIntervalSpinner, "# s"));
        this.monitorPathIntervalLabel = builder.append("", (Component)this.monitorPathIntervalSpinner);
        builder.nextLine();
        this.monitorPathCheckBox.addItemListener(new EnableListener(this.monitorPathFileChooserPanel, this.monitorPathIntervalSpinner));
    }

    public void defaults() {
        this.settingMediator.revertToDefaults();
        this.languageModel.setSelectedItem(Settings.LOCALE.getDefaultValue());
        this.completionModeModel.setSelectedItem(CompletionModeFactory.getCompletionModeInfoByClassName((String)Settings.DEFAULT_COMPLETION_MODE.getDefaultValue()));
        this.jobParameterPanel.revertFromDefaultSettings();
        this.viewerPathFileChooserPanel.getTextField().setText((String)Settings.VIEWER_PATH.getDefaultValue());
        this.docViewerPathFileChooserPanel.getTextField().setText((String)Settings.DOC_VIEWER_PATH.getDefaultValue());
        this.internalCoverRadionButton.setSelected((Boolean)Settings.USE_INTERNAL_COVER.getDefaultValue());
        this.externalCoverPathFileChooserPanel.getTextField().setText((String)Settings.COVER_PATH.getDefaultValue());
        this.monitorPathIntervalModel.setValue(Settings.MONITOR_PATH_INTERVAL.getDefaultValue());
    }

    public void revert() {
        this.settingMediator.revert();
        this.languageModel.setSelectedItem(Settings.LOCALE.getValue());
        this.completionModeModel.setSelectedItem(CompletionModeFactory.getCompletionModeInfoByClassName((String)Settings.DEFAULT_COMPLETION_MODE.getValue()));
        this.jobParameterPanel.revertFromSettings();
        this.viewerPathFileChooserPanel.getTextField().setText((String)Settings.VIEWER_PATH.getValue());
        this.docViewerPathFileChooserPanel.getTextField().setText((String)Settings.DOC_VIEWER_PATH.getValue());
        this.internalCoverRadionButton.setSelected((Boolean)Settings.USE_INTERNAL_COVER.getValue());
        this.externalCoverPathFileChooserPanel.getTextField().setText((String)Settings.COVER_PATH.getValue());
        this.monitorPathIntervalModel.setValue(Settings.MONITOR_PATH_INTERVAL.getValue());
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("Settings"));
        this.mainTabbedPane.setTitleAt(this.mainTabbedPane.indexOfComponent(this.connectionPanel), JHylaFAX.i18n.tr("Connection"));
        this.hostnameLabel.setText(JHylaFAX.i18n.tr("Host"));
        this.usePassiveCheckBox.setText(JHylaFAX.i18n.tr("Passive Transfers (Select If Transfers Timeout)"));
        this.portLabel.setText(JHylaFAX.i18n.tr("Port"));
        this.usernameLabel.setText(JHylaFAX.i18n.tr("Username"));
        WhatsThis.setText(this.usernameTextField, JHylaFAX.i18n.tr("The username that is sent to the server."));
        this.passwordLabel.setText(JHylaFAX.i18n.tr("Password"));
        this.passwordInfoLabel.setText("Warning: Passwords are saved in plain text! If not entered a prompt will be displayed.");
        this.adminModeCheckBox.setText(JHylaFAX.i18n.tr("Admin Privileges"));
        this.updateOnStartupCheckBox.setText(JHylaFAX.i18n.tr("Update Status on Startup"));
        this.autoUpdateCheckBox.setText(JHylaFAX.i18n.tr("Automatically Update Status"));
        this.autoUpdateIntervalLabel.setText(JHylaFAX.i18n.tr("Update Interval"));
        this.mainTabbedPane.setTitleAt(this.mainTabbedPane.indexOfComponent(this.generalPanel), JHylaFAX.i18n.tr("General"));
        Object selectedItem = this.languageModel.getSelectedItem();
        this.languageModel.removeAllElements();
        for (Locale locale : JHylaFAX.SUPPORTED_LOCALES) {
            this.languageModel.addElement(locale);
        }
        this.languageModel.setSelectedItem(selectedItem);
        this.showPollqCheckBox.setText(JHylaFAX.i18n.tr("Show Pollable Faxes (Takes Effect after Restart)"));
        selectedItem = this.completionModeModel.getSelectedItem();
        this.completionModeModel.removeAllElements();
        for (CompletionModeFactory.CompletionModeInfo mode : CompletionModeFactory.getInstalledCompletionModes()) {
            this.completionModeModel.addElement(mode);
        }
        this.completionModeModel.setSelectedItem(selectedItem);
        this.languageLabel.setText(JHylaFAX.i18n.tr("Lanuage"));
        this.completionModeLabel.setText(JHylaFAX.i18n.tr("Default Text Completion"));
        this.confirmNonPSCheckBox.setText(JHylaFAX.i18n.tr("Confirm Sending Non-Postscript Documents"));
        this.confirmDeleteCheckBox.setText(JHylaFAX.i18n.tr("Confirm Delete"));
        this.mainTabbedPane.setTitleAt(this.mainTabbedPane.indexOfComponent(this.jobPanel), JHylaFAX.i18n.tr("Fax"));
        this.jobParameterPanel.updateLabels();
        this.mainTabbedPane.setTitleAt(this.mainTabbedPane.indexOfComponent(this.pathsPanel), JHylaFAX.i18n.tr("Paths"));
        this.viewerPathLabel.setText(JHylaFAX.i18n.tr("Fax Viewer"));
        this.docViewerPathLabel.setText(JHylaFAX.i18n.tr("Document Viewer"));
        this.customizeAddressBookCheckBox.setText(JHylaFAX.i18n.tr("Use Custom Address Book (Takes Effect after Restart)"));
        this.internalCoverRadionButton.setText(JHylaFAX.i18n.tr("Use Internal Cover"));
        this.externalCoverRadionButton.setText(JHylaFAX.i18n.tr("Use Custom PostScript File"));
        this.sendCoverAsDocumentCheckBox.setText(JHylaFAX.i18n.tr("Save Cover in Document Queue After Sending"));
        this.mainTabbedPane.setTitleAt(this.mainTabbedPane.indexOfComponent(this.monitorPanel), JHylaFAX.i18n.tr("Monitor"));
        this.monitorPathCheckBox.setText(JHylaFAX.i18n.tr("Monitor File"));
        this.monitorPathLabel.setText(JHylaFAX.i18n.tr("File"));
        this.monitorPathIntervalLabel.setText(JHylaFAX.i18n.tr("Monitor Interval"));
    }
}

