/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.fax.Paper;
import org.xnap.commons.gui.completion.AutomaticDropDownCompletionMode;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.settings.DefaultCompletionModeSetting;
import org.xnap.commons.settings.EnumSetting;
import org.xnap.commons.settings.IntSetting;
import org.xnap.commons.settings.PropertyResource;
import org.xnap.commons.settings.SerializableSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.StringSetting;

public class Settings {
    public static final PropertyResource backstore = new PropertyResource();
    public static final StringSetting HOSTNAME = new StringSetting(backstore, "hostname", "localhost");
    public static final IntSetting PORT = new IntSetting(backstore, "port", 4559, 1, 65535);
    public static final BooleanSetting USE_PASSIVE = new BooleanSetting(backstore, "usePassive", false);
    public static final BooleanSetting UPDATE_ON_STARTUP = new BooleanSetting(backstore, "updateOnStartup", false);
    public static final StringSetting USERNAME = new StringSetting(backstore, "username", System.getProperty("user.name", "").replaceAll(" ", ""));
    public static final StringSetting PASSWORD = new StringSetting(backstore, "password", "");
    public static final StringSetting FULLNAME = new StringSetting(backstore, "fullname", "");
    public static final StringSetting EMAIL = new StringSetting(backstore, "email", "");
    public static final BooleanSetting ADMIN_MODE = new BooleanSetting(backstore, "adminMode", false);
    public static final StringSetting ADMIN_PASSWORD = new StringSetting(backstore, "adminPassword", "");
    public static final EnumSetting<Paper> PAPER = new EnumSetting<Paper>((SettingResource)backstore, "paper", Paper.A4);
    public static final EnumSetting<Resolution> RESOLUTION = new EnumSetting<Resolution>((SettingResource)backstore, "resolution", Resolution.LOW);
    public static final EnumSetting<Notification> NOTIFICATION = new EnumSetting<Notification>((SettingResource)backstore, "notification", Notification.NEVER);
    public static final IntSetting PRIORITY = new IntSetting(backstore, "priority", 127, 0, 255);
    public static final IntSetting MAXDIALS = new IntSetting((SettingResource)backstore, "maxDials", (Integer)12, 1);
    public static final IntSetting MAXTRIES = new IntSetting((SettingResource)backstore, "maxTries", (Integer)3, 1);
    public static final BooleanSetting USE_INTERNAL_COVER = new BooleanSetting(backstore, "useInternalCover", true);
    public static final BooleanSetting SEND_COVER_AS_DOCUMENT = new BooleanSetting(backstore, "sendCoverAsDocument", false);
    public static final StringSetting COVER_PATH = new StringSetting(backstore, "coverPath", "");
    public static final StringSetting VIEWER_PATH = new StringSetting(backstore, "viewerPath", "");
    public static final StringSetting DOC_VIEWER_PATH = new StringSetting(backstore, "documentViewerPath", "");
    public static final BooleanSetting DO_MONITOR_PATH = new BooleanSetting(backstore, "doMonitorPath", false);
    public static final StringSetting MONITOR_PATH = new StringSetting(backstore, "monitorPath", "");
    public static final IntSetting MONITOR_PATH_INTERVAL = new IntSetting((SettingResource)backstore, "monitorPathInterval", (Integer)90, 1);
    public static final BooleanSetting DO_AUTO_UPDATE = new BooleanSetting(backstore, "doAutoUpdate", false);
    public static final IntSetting AUTO_UPDATE_INTERVAL = new IntSetting((SettingResource)backstore, "autoUpdateInterval", (Integer)180, 1);
    public static final BooleanSetting CONFIRM_NONPS = new BooleanSetting(backstore, "confirmNonPostScript", true);
    public static final BooleanSetting CONFIRM_DELETE = new BooleanSetting(backstore, "confirmDelete", true);
    public static final BooleanSetting SHOW_POLLQ = new BooleanSetting(backstore, "showPollq", false);
    public static final SerializableSetting<Locale> LOCALE = new SerializableSetting<Locale>(backstore, "locale", Locale.getDefault());
    public static final StringSetting TIMEZONE = new StringSetting(backstore, "timezone", TimeZone.getDefault().getID());
    public static final DefaultCompletionModeSetting DEFAULT_COMPLETION_MODE = new DefaultCompletionModeSetting(backstore, "defaultCompletionMode", AutomaticDropDownCompletionMode.class.getName());
    public static final BooleanSetting HAS_SEEN_WIZARD = new BooleanSetting(backstore, "hasSeenWizard", false);
    public static final BooleanSetting CUSTOMIZE_ADDRESS_BOOK_FILENAME = new BooleanSetting(backstore, "customizeAddressBookFilename", false);
    public static final StringSetting ADDRESS_BOOK_FILENAME = new StringSetting(backstore, "addressBookFilename", "addressbook.bin");

    public static void load(File file) throws IOException {
        backstore.load(file);
    }

    public static void store(File file) throws IOException {
        backstore.store(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Notification {
        NEVER("NONE"){

            public String toString() {
                return JHylaFAX.i18n.tr("Errors only");
            }
        }
        ,
        SEND("DONE"){

            public String toString() {
                return JHylaFAX.i18n.tr("After sending");
            }
        }
        ,
        REQUEUE("REQUEUE"){

            public String toString() {
                return JHylaFAX.i18n.tr("After requeuing");
            }
        }
        ,
        ALWAYS("DONE+REQUEUE"){

            public String toString() {
                return JHylaFAX.i18n.tr("Always");
            }
        };

        private String command;

        private Notification(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Notification getEnum(String command) {
            for (Notification value : Notification.values()) {
                if (!value.getCommand().equals(command)) continue;
                return value;
            }
            throw new IllegalArgumentException("Invalid value: " + command);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resolution {
        LOW(98){

            public String toString() {
                return JHylaFAX.i18n.tr("Normal");
            }
        }
        ,
        MEDIUM(196){

            public String toString() {
                return JHylaFAX.i18n.tr("Fine");
            }
        }
        ,
        HIGH(392){

            public String toString() {
                return JHylaFAX.i18n.tr("Superfine");
            }
        };

        private int linesPerInch;

        private Resolution(int linesPerInch) {
            this.linesPerInch = linesPerInch;
        }

        public int getLinesPerInch() {
            return this.linesPerInch;
        }

        public static Resolution getEnum(int linesPerInch) {
            for (Resolution value : Resolution.values()) {
                if (linesPerInch != value.getLinesPerInch()) continue;
                return value;
            }
            throw new IllegalArgumentException("Invalid value: " + linesPerInch);
        }
    }
}

