/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.hylafax.HylaFAXClient;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sf.jhylafax.AbstractFaxDialog;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JHylaFAXHelper;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.TransferMonitor;
import net.sf.jhylafax.fax.FaxCover;
import net.sf.jhylafax.fax.FaxJob;
import net.sf.jhylafax.fax.HylaFAXClientHelper;
import net.sf.jhylafax.fax.Paper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.FileChooserPanel;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.io.Job;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.io.SubTaskProgressMonitor;
import org.xnap.commons.io.UserAbortException;

public class SendDialog
extends AbstractFaxDialog {
    private static final Log logger = LogFactory.getLog(AbstractQueuePanel.class);
    private JLabel documentLabel;
    private JPanel coverPanel;
    private JTextField coverSenderTextField;
    private JLabel coverSenderLabel;
    private JTextField coverRecepientTextField;
    private JLabel coverRecepientLabel;
    private JTextField coverSubjectTextField;
    private JLabel coverSubjectLabel;
    private JTextArea coverCommentTextArea;
    private JLabel coverCommentLabel;
    private JPanel documentPanel;
    private DefaultFormBuilder documentPanelBuilder;
    private List<FileChooserPanel> documentFileChooserPanels;
    private JCheckBox includeCoverCheckBox;
    private JLabel includeCoverLabel;
    private JScrollPane coverCommentScrollPane;
    private PreviewCoverAction previewCoverAction;
    private MoreDocumentsAction moreDocumentsAction = new MoreDocumentsAction();
    private boolean quitAfterSending;

    public SendDialog(JFrame owner) {
        super(owner);
        this.previewCoverAction = new PreviewCoverAction();
        this.addNumberTextField();
        this.addDocumentsPanel();
        this.builder.append("", (Component)Builder.createButton(this.moreDocumentsAction));
        this.builder.nextLine();
        this.addDateControls();
        this.includeCoverCheckBox = new JCheckBox();
        this.includeCoverLabel = this.builder.append("", (Component)this.includeCoverCheckBox);
        this.builder.nextLine();
        this.initializeCoverPanel();
        this.coverPanel.setVisible(false);
        this.previewCoverAction.setEnabled(false);
        this.includeCoverCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SendDialog.this.coverPanel.setVisible(SendDialog.this.includeCoverCheckBox.isSelected());
                SendDialog.this.previewCoverAction.setEnabled(SendDialog.this.includeCoverCheckBox.isSelected());
                SendDialog.this.pack();
            }
        });
        this.getButtonPanel().add((Component)Builder.createButton(this.previewCoverAction), 0);
        FaxJob job = new FaxJob();
        HylaFAXClientHelper.initializeFromSettings(job);
        this.setJob(job);
        this.updateLabels();
        this.pack();
    }

    private void addDocumentsPanel() {
        this.documentFileChooserPanels = new ArrayList<FileChooserPanel>();
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref:grow", "");
        this.documentPanelBuilder = new DefaultFormBuilder(layout);
        MyFileChooserPanel documentFileChooserPanel = new MyFileChooserPanel(20);
        documentFileChooserPanel.getFileChooser().setMultiSelectionEnabled(true);
        this.documentFileChooserPanels.add(documentFileChooserPanel);
        this.documentLabel = this.documentPanelBuilder.append("", (Component)documentFileChooserPanel);
        this.builder.appendRow(this.builder.getLineGapSpec());
        this.builder.nextLine();
        this.builder.appendRow("fill:pref:grow");
        this.builder.append((Component)this.documentPanelBuilder.getPanel(), 6);
        this.builder.nextLine();
    }

    private void initializeCoverPanel() {
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.coverPanel = builder.getPanel();
        this.builder.appendRow(builder.getLineGapSpec());
        this.builder.nextLine();
        this.builder.appendRow("fill:pref:grow");
        this.builder.append((Component)this.coverPanel, 6);
        this.coverSenderTextField = new JTextField(20);
        this.coverSenderTextField.setText((String)Settings.FULLNAME.getValue());
        this.coverSenderLabel = builder.append("", (Component)this.coverSenderTextField);
        builder.nextLine();
        this.coverRecepientTextField = new JTextField(20);
        this.coverRecepientLabel = builder.append("", (Component)this.coverRecepientTextField);
        builder.nextLine();
        this.coverSubjectTextField = new JTextField(20);
        this.coverSubjectLabel = builder.append("", (Component)this.coverSubjectTextField);
        builder.nextLine();
        this.coverCommentTextArea = new JTextArea(3, 20);
        this.coverCommentLabel = builder.append("");
        builder.appendRow("fill:pref:grow");
        CellConstraints cc = new CellConstraints();
        this.coverCommentScrollPane = new JScrollPane(this.coverCommentTextArea);
        builder.add((Component)this.coverCommentScrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 2));
        builder.nextLine(2);
    }

    public boolean apply() {
        Fax fax;
        if (!super.apply()) {
            return false;
        }
        if (!this.includeCoverCheckBox.isSelected()) {
            boolean filenameProvided = false;
            for (FileChooserPanel documentFileChooserPanel : this.documentFileChooserPanels) {
                if (documentFileChooserPanel.getTextField().getText().trim().length() == 0) continue;
                filenameProvided = true;
                if (!((Boolean)Settings.CONFIRM_NONPS.getValue()).booleanValue() || this.checkPostScript(documentFileChooserPanel.getTextField().getText())) continue;
                documentFileChooserPanel.getTextField().requestFocus();
                return false;
            }
            if (!filenameProvided) {
                Dialogs.showError((Component)this, JHylaFAX.i18n.tr("You must at least send a document or a cover"), JHylaFAX.i18n.tr("JHylaFAX Error"));
                this.documentFileChooserPanels.get(0).getTextField().requestFocus();
                return false;
            }
        }
        if ((fax = this.createFax()) != null && this.send(fax)) {
            if (this.quitAfterSending) {
                JHylaFAX.getInstance().exit();
            }
            return true;
        }
        return false;
    }

    private boolean checkPostScript(String filename) {
        try {
            if (!HylaFAXClientHelper.isPostscript(filename) && Dialogs.showConfirmDialog(this, JHylaFAX.i18n.tr("Do you really want to send the non PostScript file \"{0}\"?", filename), JHylaFAX.i18n.tr("JHylaFAX - Send non PostScript file"), 0, Settings.CONFIRM_NONPS) == 1) {
                return false;
            }
        }
        catch (IOException e) {
            logger.debug("Error checking for PostScript", e);
            ErrorDialog.showError(this, JHylaFAX.i18n.tr("Could not check for PostScript"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
            return false;
        }
        return true;
    }

    private Fax createFax() {
        Fax fax = new Fax();
        for (FileChooserPanel documentFileChooserPanel : this.documentFileChooserPanels) {
            String filename = documentFileChooserPanel.getTextField().getText();
            if (filename.trim().length() <= 0) continue;
            File file = new File(filename);
            fax.documents.add(file);
        }
        if (this.includeCoverCheckBox.isSelected() && !this.createFaxCover(fax)) {
            return null;
        }
        return fax;
    }

    private boolean createFaxCover(Fax fax) {
        String filename;
        if (fax == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        if (((Boolean)Settings.USE_INTERNAL_COVER.getValue()).booleanValue()) {
            filename = "faxcover.ps";
            fax.coverIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        } else {
            filename = (String)Settings.COVER_PATH.getValue();
            try {
                fax.coverIn = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                fax.coverIn = null;
            }
        }
        if (fax.coverIn == null) {
            Dialogs.showError((Component)this, JHylaFAX.i18n.tr("Could not read cover file: {0}", filename), JHylaFAX.i18n.tr("JHylaFAX Error"));
            return false;
        }
        fax.cover = new FaxCover((Paper)((Object)Settings.PAPER.getValue()));
        fax.cover.from = this.coverSenderTextField.getText();
        fax.cover.to = this.coverRecepientTextField.getText();
        fax.cover.regarding = this.coverSubjectTextField.getText();
        fax.cover.comments = this.coverCommentTextArea.getText();
        fax.cover.todays_date = SimpleDateFormat.getDateTimeInstance().format(new Date());
        Iterator<File> it = fax.documents.iterator();
        while (it.hasNext()) {
            fax.cover.addDocument(it.next().getAbsolutePath());
        }
        return true;
    }

    private boolean send(final Fax fax) {
        Job ioJob = new Job(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(ProgressMonitor monitor) throws Exception {
                InputStream in;
                TransferMonitor transferMonitor;
                monitor.setTotalSteps(13 + fax.documents.size() * 10);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                client.mode('S');
                client.type('I');
                String serverCoverFilename = null;
                if (fax.cover != null && fax.coverIn != null) {
                    monitor.setText(JHylaFAX.i18n.tr("Generating cover"));
                    SubTaskProgressMonitor coverMonitor = new SubTaskProgressMonitor(monitor, 5, 0L);
                    StringBuffer data = fax.cover.generate(fax.coverIn, coverMonitor);
                    coverMonitor.done();
                    byte[] buffer = data.toString().getBytes("ISO-8859-1");
                    transferMonitor = new TransferMonitor(monitor, 5, buffer.length);
                    client.addTransferListener(transferMonitor);
                    in = new ByteArrayInputStream(buffer);
                    try {
                        serverCoverFilename = client.putTemporary(in);
                    }
                    finally {
                        transferMonitor.transferCompleted();
                        client.removeTransferListener(transferMonitor);
                        in.close();
                    }
                    monitor.work(0L);
                } else {
                    monitor.work(10L);
                }
                monitor.setText(JHylaFAX.i18n.tr("Uploading documents"));
                ArrayList<String> serverFilenames = new ArrayList<String>();
                for (File file : fax.documents) {
                    transferMonitor = new TransferMonitor(monitor, 10, file.length());
                    client.addTransferListener(transferMonitor);
                    in = new BufferedInputStream(new FileInputStream(file));
                    try {
                        serverFilenames.add(client.putTemporary(in));
                    }
                    finally {
                        transferMonitor.transferCompleted();
                        client.removeTransferListener(transferMonitor);
                        in.close();
                    }
                    monitor.work(0L);
                }
                gnu.hylafax.Job sendJob = client.createJob();
                HylaFAXClientHelper.applyParameter(sendJob, SendDialog.this.getJob());
                if (serverCoverFilename != null) {
                    if (((Boolean)Settings.SEND_COVER_AS_DOCUMENT.getValue()).booleanValue()) {
                        sendJob.addDocument(serverCoverFilename);
                    } else {
                        sendJob.setProperty("COVER ", serverCoverFilename);
                    }
                }
                for (String filename : serverFilenames) {
                    sendJob.addDocument(filename);
                }
                monitor.work(1L);
                client.submit(sendJob);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(this, ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
            return false;
        }
        catch (Exception e) {
            logger.debug("Error sending fax", e);
            ErrorDialog.showError(this, JHylaFAX.i18n.tr("Could not send fax"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
            return false;
        }
        return true;
    }

    private File saveCover(final Fax fax) {
        if (fax.cover == null || fax.coverIn == null) {
            throw new IllegalArgumentException("fax.cover and fax.coverIn must not be null");
        }
        Job<File> ioJob = new Job<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(10L);
                monitor.setText(JHylaFAX.i18n.tr("Generating cover"));
                SubTaskProgressMonitor coverMonitor = new SubTaskProgressMonitor(monitor, 5, 0L);
                StringBuffer data = fax.cover.generate(fax.coverIn, coverMonitor);
                coverMonitor.done();
                File outputFile = File.createTempFile("jhylafax", ".ps");
                outputFile.deleteOnExit();
                FileOutputStream out = new FileOutputStream(outputFile);
                monitor.setText(JHylaFAX.i18n.tr("Saving cover"));
                try {
                    ((OutputStream)out).write(data.toString().getBytes("ISO-8859-1"));
                }
                finally {
                    ((OutputStream)out).close();
                }
                monitor.work(5L);
                return outputFile;
            }
        };
        try {
            return JHylaFAX.getInstance().runJob(this, ioJob);
        }
        catch (UserAbortException e) {
            return null;
        }
        catch (Exception e) {
            logger.debug("Error previewing cover", e);
            ErrorDialog.showError(this, JHylaFAX.i18n.tr("Could not preview cover"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
            return null;
        }
    }

    public void updateLabels() {
        super.updateLabels();
        this.setTitle(JHylaFAX.i18n.tr("Send Fax"));
        this.documentLabel.setText(JHylaFAX.i18n.tr("Document"));
        this.includeCoverLabel.setText(JHylaFAX.i18n.tr("Include Cover"));
        this.coverSenderLabel.setText(JHylaFAX.i18n.tr("Sender"));
        this.coverRecepientLabel.setText(JHylaFAX.i18n.tr("Recepient"));
        this.coverSubjectLabel.setText(JHylaFAX.i18n.tr("Subject"));
        this.coverCommentLabel.setText(JHylaFAX.i18n.tr("Comment"));
        this.previewCoverAction.updateLabels();
        this.moreDocumentsAction.updateLabels();
    }

    public void setDocument(String document) {
        this.documentFileChooserPanels.get(0).getTextField().setText(document);
    }

    protected FileChooserPanel addDocumentFileChooser() {
        MyFileChooserPanel documentFileChooserPanel = new MyFileChooserPanel(20);
        documentFileChooserPanel.setFileChooser(this.documentFileChooserPanels.get(0).getFileChooser());
        this.documentFileChooserPanels.add(documentFileChooserPanel);
        this.documentPanelBuilder.append("", (Component)documentFileChooserPanel);
        this.documentPanelBuilder.nextLine();
        this.pack();
        return documentFileChooserPanel;
    }

    public void addDocument(String filename) {
        FileChooserPanel panel = this.addDocumentFileChooser();
        panel.getTextField().setText(filename);
    }

    public void setQuitAfterSending(boolean quitAfterSending) {
        this.quitAfterSending = quitAfterSending;
    }

    private class MyFileChooserPanel
    extends FileChooserPanel {
        public MyFileChooserPanel(int columns) {
            super(columns);
        }

        protected void fileSelected(File file) {
            File[] files = this.getFileChooser().getSelectedFiles();
            if (files != null && files.length > 1) {
                for (int i = 1; i < files.length; ++i) {
                    FileChooserPanel chooser = SendDialog.this.addDocumentFileChooser();
                    chooser.setFile(files[i]);
                }
            }
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private class MoreDocumentsAction
    extends AbstractXNapAction
    implements LocaleChangeListener {
        public void actionPerformed(ActionEvent event) {
            FileChooserPanel documentFileChooserPanel = SendDialog.this.addDocumentFileChooser();
            documentFileChooserPanel.getTextField().requestFocus();
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("More"));
            this.putValue("ShortDescription", JHylaFAX.i18n.tr("Displays an additional field to enter a document filename"));
        }
    }

    private class PreviewCoverAction
    extends AbstractXNapAction
    implements LocaleChangeListener {
        public void actionPerformed(ActionEvent event) {
            if (!SendDialog.this.includeCoverCheckBox.isSelected()) {
                throw new IllegalStateException("Cover page is not enabled");
            }
            String viewerPath = JHylaFAXHelper.getViewerPath("docq");
            if (viewerPath == null) {
                return;
            }
            Fax fax = SendDialog.this.createFax();
            if (fax == null) {
                return;
            }
            File tempFile = SendDialog.this.saveCover(fax);
            if (tempFile != null) {
                JHylaFAXHelper.view(viewerPath, new File[]{tempFile});
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Preview Cover"));
            this.putValue("ShortDescription", JHylaFAX.i18n.tr("Opens an external programm to preview the cover page"));
        }
    }

    private class Fax {
        FaxCover cover;
        InputStream coverIn;
        List<File> documents = new ArrayList<File>();

        private Fax() {
        }
    }
}

