/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.fax.ReceivedFax;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.util.DoubleClickListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveQueuePanel
extends AbstractQueuePanel {
    private AbstractQueuePanel.ViewAction viewAction = new AbstractQueuePanel.ViewAction();
    private AbstractQueuePanel.SaveAction saveAction = new AbstractQueuePanel.SaveAction();
    private AbstractQueuePanel.DeleteAction deleteAction = new AbstractQueuePanel.DeleteAction();
    private FaxTableModel faxTableModel;

    public ReceiveQueuePanel(String queueName) {
        super(queueName);
        this.getButtonPanel().add(Builder.createButton(this.viewAction));
        this.getButtonPanel().add(Builder.createButton(this.saveAction));
        this.getButtonPanel().add(Builder.createButton(this.deleteAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.viewAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.saveAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.deleteAction));
        this.getTable().addMouseListener(new DoubleClickListener(this.viewAction));
        this.updateLabels();
        this.updateActions();
    }

    @Override
    public JobHelper.FileStat getSelectedFile() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        ReceivedFax doc = this.faxTableModel.getDocument(row);
        return new JobHelper.FileStat(doc.getFilename(), doc.getFilesize());
    }

    @Override
    protected TableModel getTableModel() {
        if (this.faxTableModel == null) {
            this.faxTableModel = new FaxTableModel();
        }
        return this.faxTableModel;
    }

    @Override
    protected void initializeTableLayout() {
        this.getTableLayout().setColumnProperties(0, "sender", 150);
        this.getTableLayout().setColumnProperties(1, "pages", 40);
        this.getTableLayout().setColumnProperties(2, "time", 40);
        this.getTableLayout().setColumnProperties(3, "filename", 100);
        this.getTableLayout().setColumnProperties(4, "filesize", 40);
        this.getTableLayout().setColumnProperties(5, "owner", 40);
        this.getTableLayout().setColumnProperties(6, "resolution", 40);
        this.getTableLayout().setColumnProperties(7, "singallingRate", 40);
        this.getTableLayout().setColumnProperties(8, "receiving", 40);
        this.getTableLayout().setColumnProperties(9, "error", 100);
    }

    public void setData(List<ReceivedFax> data) {
        this.faxTableModel.setData(data);
    }

    @Override
    public void updateActions() {
        JobHelper.FileStat file = this.getSelectedFile();
        this.viewAction.setEnabled(file != null);
        this.saveAction.setEnabled(file != null);
        this.deleteAction.setEnabled(file != null);
    }

    @Override
    public void updateLabels() {
        super.updateLabels();
        this.viewAction.updateLabels();
        this.saveAction.updateLabels();
        this.deleteAction.updateLabels();
        this.getTableLayout().setColumnNames(new String[]{JHylaFAX.i18n.tr("Sender"), JHylaFAX.i18n.tr("Pages"), JHylaFAX.i18n.tr("Time"), JHylaFAX.i18n.tr("Filename"), JHylaFAX.i18n.tr("Filesize"), JHylaFAX.i18n.tr("Owner"), JHylaFAX.i18n.tr("Resolution"), JHylaFAX.i18n.tr("Signalling Rate"), JHylaFAX.i18n.tr("Receiving"), JHylaFAX.i18n.tr("Error")});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FaxTableModel
    extends AbstractTableModel {
        private static final Class[] columnClasses = new Class[]{String.class, Integer.class, Date.class, String.class, Long.class, String.class, Integer.class, Integer.class, Boolean.class, String.class};
        private List<ReceivedFax> data = new ArrayList<ReceivedFax>(0);

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return columnClasses.length;
        }

        public ReceivedFax getDocument(int row) {
            return this.data.get(row);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ReceivedFax fax = this.data.get(row);
            switch (column) {
                case 0: {
                    return fax.getSender();
                }
                case 1: {
                    return fax.getPageCount();
                }
                case 2: {
                    return fax.getReceivedTime();
                }
                case 3: {
                    return fax.getFilename();
                }
                case 4: {
                    return fax.getFilesize();
                }
                case 5: {
                    return fax.getOwner();
                }
                case 6: {
                    return fax.getResolution();
                }
                case 7: {
                    return fax.getSignallingRate();
                }
                case 8: {
                    return fax.isReceiving();
                }
                case 9: {
                    return fax.getLastError();
                }
            }
            return null;
        }

        public void setData(List<ReceivedFax> data) {
            this.data = data;
            this.fireTableDataChanged();
        }
    }
}

