/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import javax.swing.JFrame;
import net.sf.jhylafax.AbstractFaxDialog;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.fax.FaxJob;
import net.sf.jhylafax.fax.HylaFAXClientHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.io.UserAbortException;

public class PollDialog
extends AbstractFaxDialog {
    private static final Log logger = LogFactory.getLog(PollDialog.class);

    public PollDialog(JFrame owner) {
        super(owner);
        this.addNumberTextField();
        this.addDateControls();
        FaxJob job = new FaxJob();
        HylaFAXClientHelper.initializeFromSettings(job);
        this.setJob(job);
        this.updateLabels();
        this.pack();
    }

    public boolean apply() {
        if (!super.apply()) {
            return false;
        }
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(4L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                Job pollJob = client.createJob();
                HylaFAXClientHelper.applyParameter(pollJob, PollDialog.this.getJob());
                pollJob.setProperty("POLL", "\"\" \"\"");
                monitor.work(1L);
                client.submit(pollJob);
                monitor.work(2L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(this, ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
            return false;
        }
        catch (Exception e) {
            logger.debug("Error polling fax", e);
            ErrorDialog.showError(this, JHylaFAX.i18n.tr("Could not poll fax"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
            return false;
        }
        return true;
    }

    public void updateLabels() {
        super.updateLabels();
        this.setTitle(JHylaFAX.i18n.tr("Poll Fax"));
    }
}

