/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.Notification;
import net.sf.jhylafax.SendDialog;
import net.sf.jhylafax.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.io.NullProgressMonitor;

public class NotificationTimer {
    private static final Log logger = LogFactory.getLog(NotificationTimer.class);
    private Timer timer = new Timer();
    private TimerTask monitorPathTask;
    private StatusUpdateTask statusUpdateTask;

    public void cancel() {
        this.timer.cancel();
    }

    public void settingsUpdated() {
        if (this.monitorPathTask != null) {
            this.monitorPathTask.cancel();
            this.monitorPathTask = null;
        }
        if (((Boolean)Settings.DO_MONITOR_PATH.getValue()).booleanValue()) {
            this.monitorPathTask = new MonitorPathTask((String)Settings.MONITOR_PATH.getValue());
            this.timer.schedule(this.monitorPathTask, 0L, (long)((Integer)Settings.MONITOR_PATH_INTERVAL.getValue() * 1000));
        }
        if (this.statusUpdateTask != null) {
            this.statusUpdateTask.cancel();
            this.statusUpdateTask = null;
        }
        if (((Boolean)Settings.DO_AUTO_UPDATE.getValue()).booleanValue()) {
            this.statusUpdateTask = new StatusUpdateTask();
            this.timer.schedule((TimerTask)this.statusUpdateTask, 0L, (long)((Integer)Settings.AUTO_UPDATE_INTERVAL.getValue() * 1000));
        }
    }

    private class StatusUpdateTask
    extends TimerTask {
        private StatusUpdateTask() {
        }

        public void run() {
            JobHelper.StatusUpdateJob ioJob = new JobHelper.StatusUpdateJob();
            try {
                JobHelper.StatusResponse response = (JobHelper.StatusResponse)ioJob.run(new NullProgressMonitor());
                JHylaFAX.getInstance().updateTables(response);
            }
            catch (Exception e) {
                logger.warn("Error during auto status update", e);
            }
        }
    }

    private class MonitorPathTask
    extends TimerTask {
        private File file;
        private long lastUpdate;

        public MonitorPathTask(String path) {
            this.file = new File(path);
            this.lastUpdate = this.file.lastModified();
        }

        public void run() {
            long check = this.file.lastModified();
            if (check != this.lastUpdate) {
                JHylaFAX.getInstance().runNotification(new Notification(){

                    public void run() {
                        SendDialog dialog = new SendDialog(JHylaFAX.getInstance());
                        dialog.setDocument(MonitorPathTask.this.file.getAbsolutePath());
                        dialog.setLocationRelativeTo(JHylaFAX.getInstance());
                        dialog.setVisible(true);
                    }
                });
                this.lastUpdate = check;
            }
        }
    }
}

