/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.DetailsDialog;
import net.sf.jhylafax.EditDialog;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JHylaFAXHelper;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.fax.FaxJob;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.util.DoubleClickListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueuePanel
extends AbstractQueuePanel {
    private DetailsAction detailsAction;
    private EditJobAction editAction;
    private JobTableModel jobTableModel;
    private RemoveJobAction removeAction = new RemoveJobAction();
    private ResumeJobAction resumeAction;
    private RetryJobAction retryAction;
    private SuspendJobAction suspendAction = new SuspendJobAction();
    private ViewJobAction viewAction;

    public JobQueuePanel(String queueName) {
        super(queueName);
        this.resumeAction = new ResumeJobAction();
        this.retryAction = new RetryJobAction();
        this.detailsAction = new DetailsAction();
        this.editAction = new EditJobAction();
        this.viewAction = new ViewJobAction();
        if (queueName.equals("doneq")) {
            this.getButtonPanel().add(Builder.createButton(this.viewAction));
            this.getButtonPanel().add(Builder.createButton(this.removeAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.viewAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.detailsAction));
            this.getTable().addMouseListener(new DoubleClickListener(this.viewAction));
        } else {
            this.getButtonPanel().add(Builder.createButton(this.editAction));
            this.getButtonPanel().add(Builder.createButton(this.removeAction));
            this.getButtonPanel().add(Builder.createButton(this.suspendAction));
            this.getButtonPanel().add(Builder.createButton(this.resumeAction));
            this.getButtonPanel().add(Builder.createButton(this.viewAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.editAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.removeAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.detailsAction));
            this.getTablePopupMenu().addSeparator();
            this.getTablePopupMenu().add(Builder.createMenuItem(this.retryAction));
            this.getTablePopupMenu().addSeparator();
            this.getTablePopupMenu().add(Builder.createMenuItem(this.suspendAction));
            this.getTablePopupMenu().add(Builder.createMenuItem(this.resumeAction));
            this.getTablePopupMenu().addSeparator();
            this.getTablePopupMenu().add(Builder.createMenuItem(this.viewAction));
            this.getTable().addMouseListener(new DoubleClickListener(this.editAction));
        }
        this.updateLabels();
        this.updateActions();
    }

    @Override
    public JobHelper.FileStat getSelectedFile() {
        return null;
    }

    public FaxJob getSelectedJob() {
        int row = this.getSelectedRow();
        return row == -1 ? null : this.jobTableModel.getJob(row);
    }

    @Override
    protected TableModel getTableModel() {
        if (this.jobTableModel == null) {
            this.jobTableModel = new JobTableModel();
        }
        return this.jobTableModel;
    }

    @Override
    protected void initializeTableLayout() {
        this.getTableLayout().setColumnProperties(0, "id", 20);
        this.getTableLayout().setColumnProperties(1, "priority", 20);
        this.getTableLayout().setColumnProperties(2, "result", 20);
        this.getTableLayout().setColumnProperties(3, "permissions", 40);
        this.getTableLayout().setColumnProperties(4, "owner", 40);
        this.getTableLayout().setColumnProperties(5, "sender", 80);
        this.getTableLayout().setColumnProperties(6, "clientMachine", 80);
        this.getTableLayout().setColumnProperties(7, "resolution", 40);
        this.getTableLayout().setColumnProperties(8, "number", 80);
        this.getTableLayout().setColumnProperties(9, "time", 60);
        this.getTableLayout().setColumnProperties(10, "pages", 20);
        this.getTableLayout().setColumnProperties(11, "dials", 20);
        this.getTableLayout().setColumnProperties(12, "error", 100);
        this.getTableLayout().setColumnProperties(13, "state", 18);
        this.getTableLayout().setColumnProperties(14, "cid", 40);
        this.getTableLayout().setColumnProperties(15, "tag", 40);
    }

    public void setData(List<FaxJob> data) {
        this.jobTableModel.setData(data);
    }

    @Override
    public void updateActions() {
        FaxJob job = this.getSelectedJob();
        this.viewAction.setEnabled(job != null);
        boolean isEditable = job != null && job.getID() != -1;
        this.editAction.setEnabled(isEditable);
        this.removeAction.setEnabled(isEditable);
        this.suspendAction.setEnabled(job != null && job.getState() != FaxJob.State.SUSPENDED);
        this.resumeAction.setEnabled(job != null && job.getState() == FaxJob.State.SUSPENDED);
        this.retryAction.setEnabled(job != null);
    }

    @Override
    public void updateLabels() {
        super.updateLabels();
        this.removeAction.updateLabels();
        this.suspendAction.updateLabels();
        this.resumeAction.updateLabels();
        this.retryAction.updateLabels();
        this.detailsAction.updateLabels();
        this.editAction.updateLabels();
        this.viewAction.updateLabels();
        this.getTableLayout().setColumnNames(new String[]{JHylaFAX.i18n.tr("ID"), JHylaFAX.i18n.tr("Priority"), JHylaFAX.i18n.tr("Result"), JHylaFAX.i18n.tr("Permission"), JHylaFAX.i18n.tr("Owner"), JHylaFAX.i18n.tr("Sender"), JHylaFAX.i18n.tr("Client Machine"), JHylaFAX.i18n.tr("Resolution"), JHylaFAX.i18n.tr("Number"), JHylaFAX.i18n.tr("Time"), JHylaFAX.i18n.tr("Pages"), JHylaFAX.i18n.tr("Dials"), JHylaFAX.i18n.tr("Last Error"), JHylaFAX.i18n.tr("State"), JHylaFAX.i18n.tr("CID"), JHylaFAX.i18n.tr("Tag")});
    }

    private class ViewJobAction
    extends AbstractXNapAction {
        public ViewJobAction() {
            this.putValue("XNapIcon", "viewmag.png");
        }

        public void actionPerformed(ActionEvent event) {
            JobHelper.FileStat[] files;
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            if (job == null) {
                return;
            }
            String viewerPath = JHylaFAXHelper.getViewerPath(JobQueuePanel.this.getQueueName());
            if (viewerPath != null && (files = JobHelper.retrieveJobFilenames(job.getID())) != null) {
                if (files.length == 0) {
                    Dialogs.showInfo(JHylaFAX.getInstance(), JHylaFAX.i18n.tr("The job does not contain documents"), JHylaFAX.i18n.tr("JHylaFAX Information"));
                } else {
                    File[] tempFiles = new File[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        tempFiles[i] = JobQueuePanel.this.createTempFile(files[i].filename);
                        if (tempFiles[i] == null) {
                            return;
                        }
                        if (JobHelper.save(tempFiles[i], files[i].filename, files[i].filesize)) continue;
                        return;
                    }
                    JHylaFAXHelper.view(viewerPath, tempFiles);
                }
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("View"));
        }
    }

    private class SuspendJobAction
    extends AbstractXNapAction {
        public SuspendJobAction() {
            this.putValue("XNapIcon", "player_pause.png");
        }

        public void actionPerformed(ActionEvent event) {
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            JobHelper.suspendJob(job.getID());
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Suspend"));
        }
    }

    private class RetryJobAction
    extends AbstractXNapAction {
        public RetryJobAction() {
            this.putValue("XNapIcon", "redo.png");
        }

        public void actionPerformed(ActionEvent e) {
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            JobHelper.retryJob(job.getID());
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Send Now"));
        }
    }

    private class ResumeJobAction
    extends AbstractXNapAction {
        public ResumeJobAction() {
            this.putValue("XNapIcon", "player_play.png");
        }

        public void actionPerformed(ActionEvent event) {
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            JobHelper.resumeJob(job.getID());
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Resume"));
        }
    }

    private class RemoveJobAction
    extends AbstractXNapAction {
        public RemoveJobAction() {
            this.putValue("XNapIcon", "editdelete.png");
        }

        public void actionPerformed(ActionEvent event) {
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            if (Dialogs.showConfirmDialog(JHylaFAX.getInstance(), JHylaFAX.i18n.tr("Do you really want to delete the job with id {0}?", job.getID()), JHylaFAX.i18n.tr("Remove Job"), 0, Settings.CONFIRM_DELETE) == 0) {
                JobHelper.removeJob(job.getID());
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Remove"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JobTableModel
    extends AbstractTableModel {
        private static final Class[] columnClasses = new Class[]{Integer.class, Integer.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, Date.class, Integer.class, String.class, String.class, FaxJob.State.class, String.class, String.class};
        private List<FaxJob> data = new ArrayList<FaxJob>();

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return columnClasses.length;
        }

        public FaxJob getJob(int row) {
            return this.data.get(row);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            FaxJob job = this.data.get(row);
            switch (column) {
                case 0: {
                    return job.getID();
                }
                case 1: {
                    return job.getPriority();
                }
                case 2: {
                    return job.getResult();
                }
                case 3: {
                    return job.getPermissions();
                }
                case 4: {
                    return job.getOwner();
                }
                case 5: {
                    return job.getSender();
                }
                case 6: {
                    return job.getClientMachineName();
                }
                case 7: {
                    return job.getVerticalResolution();
                }
                case 8: {
                    return job.getNumber();
                }
                case 9: {
                    return job.getSendTime();
                }
                case 10: {
                    return job.getPageCount();
                }
                case 11: {
                    return job.getDialsAttempted() + "/" + job.getMaxDials();
                }
                case 12: {
                    return job.getLastError();
                }
                case 13: {
                    return job.getState();
                }
                case 14: {
                    return job.getCommunicationIdentifier();
                }
                case 15: {
                    return job.getTaglineFormat();
                }
            }
            return null;
        }

        public void setData(List<FaxJob> data) {
            this.data = data;
            this.fireTableDataChanged();
        }
    }

    private class DetailsAction
    extends AbstractXNapAction {
        public void actionPerformed(ActionEvent e) {
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            ArrayList<DetailsDialog.Property> data = new ArrayList<DetailsDialog.Property>();
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Assigned modem"), job.getAssignedModem()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Client-specefied dial string"), job.getClientDialString()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Client machine name"), job.getClientMachineName()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Scheduling priority"), job.getClientSchedulingPriority()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Communication identifier"), job.getCommunicationIdentifier()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Page chopping threshold"), job.getChoppingThreshold()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Client-specified minimum signalling rate"), job.getClientMinimumSignallingRate()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Client-specified tag"), job.getTag()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Client-specified tagline format"), job.getTaglineFormat()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("# of consecutive failed dials"), job.getConsecutiveFailedDials()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("# of consecutive failed tries"), job.getConsecutiveFailedTries()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Desired data format"), job.getDesiredDataFormat()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Desired use of ECM"), job.getDesiredECM()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Desired minimum scanline time"), job.getDesiredMinScanline()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Desired signalling rate"), job.getDesiredSignallingRate()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Destination company name"), job.getDestinationCompanyName()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Destination geographic location"), job.getDestinationLocation()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Destination password"), job.getDestinationPassword()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Destination sub-address"), job.getDestinationSubAddress()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("# of attempted dials"), job.getDialsAttempted()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Group identifier"), job.getGroupID()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Horizontal resolution"), job.getHorizontalResolution()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("ID"), job.getID()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Job done operation"), job.getJobDoneOperation()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Job type"), (Object)job.getJobType()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Kill time"), job.getKillTime()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Last error"), job.getLastError()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Total # of dials"), job.getMaxDials()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Total # of tries"), job.getMaxTries()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Notify"), job.getNotify()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Notify address"), job.getNotifyAdress()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Number"), job.getNumber()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Owner"), job.getOwner()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Page chopping"), (Object)job.getPageChopping()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Permissions"), job.getPermissions()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Total # of pages"), job.getPageCount()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Page length"), job.getPageLength()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("# of transmitted pages"), job.getPagesTransmitted()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Page width"), job.getPageWidth()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Priority"), job.getPriority()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Receiver"), job.getReceiver()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Result"), job.getResult()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Retry time"), job.getRetryTime()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Sender"), job.getSender()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Send time"), job.getSendTime()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("State"), (Object)job.getState()));
            data.add(new DetailsDialog.Property(JHylaFAX.i18n.tr("Vertical resolution"), job.getVerticalResolution()));
            DetailsDialog dialog = new DetailsDialog(JHylaFAX.getInstance(), data);
            dialog.setLocationRelativeTo(JHylaFAX.getInstance());
            dialog.setVisible(true);
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Details"));
        }
    }

    private class EditJobAction
    extends AbstractXNapAction {
        public EditJobAction() {
            this.putValue("XNapIcon", "edit.png");
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FaxJob job = JobQueuePanel.this.getSelectedJob();
            EditDialog dialog = new EditDialog(JHylaFAX.getInstance(), job);
            dialog.setLocationRelativeTo(JHylaFAX.getInstance());
            dialog.setVisible(true);
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Edit..."));
        }
    }
}

