/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.Notification;
import org.xnap.commons.gui.ProgressDialog;
import org.xnap.commons.io.Job;
import org.xnap.commons.io.UserAbortProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueue {
    private boolean jobRunning = false;
    private long lastUpdate;
    private LinkedList<Notification> notificationQueue = new LinkedList();

    public <T> T runJob(JDialog owner, final Job<T> job) throws Exception {
        if (this.jobRunning) {
            throw new RuntimeException("Concurrent job invocation");
        }
        final Object[] retSuccess = new Object[1];
        final Throwable[] ret = new Exception[1];
        final ProgressDialog dialog = owner != null ? new ProgressDialog(owner) : new ProgressDialog(JHylaFAX.getInstance());
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    retSuccess[0] = job.run(new UserAbortProgressMonitor(dialog));
                }
                catch (Throwable e) {
                    ret[0] = e;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dialog.done();
                    }
                });
            }
        };
        this.jobRunning = true;
        Thread t = new Thread(runner, "Job");
        t.start();
        if (owner != null) {
            dialog.setLocationRelativeTo(owner);
        } else {
            dialog.setLocationRelativeTo(JHylaFAX.getInstance());
        }
        dialog.setTitle(JHylaFAX.i18n.tr("HylaFAX Server"));
        dialog.setModal(true);
        dialog.showDialog();
        this.jobRunning = false;
        this.processNotifications();
        if (ret[0] != null) {
            if (ret[0] instanceof Exception) {
                throw (Exception)ret[0];
            }
            throw new InvocationTargetException(ret[0]);
        }
        return (T)retSuccess[0];
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isJobRunning() {
        return this.jobRunning;
    }

    public void addNotification(final Notification notification) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JobQueue.this.isJobRunning()) {
                    JobQueue.this.addNotificationInternal(notification);
                } else {
                    JobQueue.this.runNotification(notification);
                }
            }
        });
    }

    protected void runNotification(Notification notification) {
        notification.run();
    }

    private void addNotificationInternal(Notification notification) {
        this.notificationQueue.add(notification);
    }

    private void processNotifications() {
        if (this.isJobRunning()) {
            throw new IllegalStateException();
        }
        while (!this.notificationQueue.isEmpty()) {
            Notification notification = this.notificationQueue.removeFirst();
            this.runNotification(notification);
        }
    }
}

