/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.fax.FaxJob;
import net.sf.jhylafax.fax.Paper;
import org.xnap.commons.gui.Dialogs;

public class JobPanel
extends JPanel
implements LocaleChangeListener {
    private static final int DEFAULT_COLUMNS = 20;
    private JLabel notificationLabel;
    private JLabel resolutionLabel;
    private JSpinner prioritySpinner;
    private JLabel priorityLabel;
    private JSpinner maxTriesSpinner;
    private JLabel maxTriesLabel;
    private JSpinner maxDialsSpinner;
    private JLabel maxDialsLabel;
    private JLabel paperLabel;
    private DefaultComboBoxModel notificationModel;
    private DefaultComboBoxModel resolutionModel;
    private DefaultComboBoxModel paperModel;
    private JTextField fullnameTextField;
    private JTextField emailTextField;
    private JLabel fullnameLabel;
    private JLabel emailLabel;
    private SpinnerNumberModel priorityModel;

    public JobPanel(boolean border) {
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref, pref:grow, min:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this);
        if (border) {
            builder.setDefaultDialogBorder();
        }
        builder.appendSeparator(JHylaFAX.i18n.tr("Sender"));
        this.fullnameTextField = new JTextField(20);
        this.fullnameLabel = builder.append("", (Component)this.fullnameTextField, 3);
        builder.nextLine();
        this.emailTextField = new JTextField(20);
        this.emailLabel = builder.append("", (Component)this.emailTextField, 3);
        builder.nextLine();
        builder.appendSeparator(JHylaFAX.i18n.tr("Parameter"));
        this.notificationModel = new DefaultComboBoxModel();
        JComboBox notificationComboBox = new JComboBox(this.notificationModel);
        this.notificationLabel = builder.append("", notificationComboBox, 2);
        builder.nextLine();
        this.resolutionModel = new DefaultComboBoxModel();
        JComboBox resolutionComboBox = new JComboBox(this.resolutionModel);
        this.resolutionLabel = builder.append("", resolutionComboBox, 2);
        builder.nextLine();
        this.priorityModel = new SpinnerNumberModel(0, 0, 255, 1);
        this.prioritySpinner = new JSpinner(this.priorityModel);
        this.priorityLabel = builder.append("", (Component)this.prioritySpinner);
        builder.nextLine();
        this.maxTriesSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 255, 1));
        this.maxTriesLabel = builder.append("", (Component)this.maxTriesSpinner);
        builder.nextLine();
        this.maxDialsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 255, 1));
        this.maxDialsLabel = builder.append("", (Component)this.maxDialsSpinner);
        builder.nextLine();
        this.paperModel = new DefaultComboBoxModel();
        JComboBox paperComboBox = new JComboBox(this.paperModel);
        this.paperLabel = builder.append("", paperComboBox, 2);
    }

    public void setSenderEditable(boolean editSender) {
        this.fullnameTextField.setEditable(editSender);
        this.emailTextField.setEditable(editSender);
    }

    public void updateLabels() {
        this.fullnameLabel.setText(JHylaFAX.i18n.tr("Name"));
        this.emailLabel.setText(JHylaFAX.i18n.tr("Email"));
        this.notificationLabel.setText(JHylaFAX.i18n.tr("Notify"));
        this.resolutionLabel.setText(JHylaFAX.i18n.tr("Resolution"));
        this.priorityLabel.setText(JHylaFAX.i18n.tr("Priority"));
        this.maxTriesLabel.setText(JHylaFAX.i18n.tr("Maximum Tries"));
        this.maxDialsLabel.setText(JHylaFAX.i18n.tr("Maximum Dials"));
        this.paperLabel.setText(JHylaFAX.i18n.tr("Paper Format"));
        Object selectedItem = this.notificationModel.getSelectedItem();
        this.notificationModel.removeAllElements();
        for (Settings.Notification notification : Settings.Notification.values()) {
            this.notificationModel.addElement(notification);
        }
        this.notificationModel.setSelectedItem(selectedItem);
        selectedItem = this.resolutionModel.getSelectedItem();
        this.resolutionModel.removeAllElements();
        for (Enum enum_ : Settings.Resolution.values()) {
            this.resolutionModel.addElement(enum_);
        }
        this.resolutionModel.setSelectedItem(selectedItem);
        selectedItem = this.paperModel.getSelectedItem();
        this.paperModel.removeAllElements();
        for (Enum enum_ : Paper.values()) {
            this.paperModel.addElement(enum_);
        }
        this.paperModel.setSelectedItem(selectedItem);
    }

    public void applyTo(FaxJob job) {
        job.setSender(this.fullnameTextField.getText());
        job.setNotifyAdress(this.emailTextField.getText());
        job.setNotify(((Settings.Notification)((Object)this.notificationModel.getSelectedItem())).getCommand());
        job.setResolution(((Settings.Resolution)((Object)this.resolutionModel.getSelectedItem())).getLinesPerInch());
        job.setPriority(this.priorityModel.getNumber().intValue());
        job.setMaxTries((Integer)this.maxTriesSpinner.getValue());
        job.setMaxDials((Integer)this.maxDialsSpinner.getValue());
        Paper paper = (Paper)((Object)this.paperModel.getSelectedItem());
        job.setPageWidth(paper.getWidth());
        job.setPageLength(paper.getHeight());
    }

    public void revertFrom(FaxJob job) {
        this.fullnameTextField.setText(job.getSender());
        this.emailTextField.setText(job.getNotifyAdress());
        if (job.getNotify() == null) {
            this.notificationModel.setSelectedItem((Object)Settings.Notification.NEVER);
        } else {
            try {
                this.notificationModel.setSelectedItem((Object)Settings.Notification.getEnum(job.getNotify()));
            }
            catch (IllegalArgumentException e) {
                Dialogs.showError(this, JHylaFAX.i18n.tr("Unknown notification type. Using default."));
                this.notificationModel.setSelectedItem(Settings.NOTIFICATION.getValue());
            }
        }
        try {
            this.resolutionModel.setSelectedItem((Object)Settings.Resolution.getEnum(job.getVerticalResolution()));
        }
        catch (IllegalArgumentException e) {
            Dialogs.showError(this, JHylaFAX.i18n.tr("Invalid resolution. Using default."));
            this.resolutionModel.setSelectedItem(Settings.RESOLUTION.getValue());
        }
        this.prioritySpinner.setValue(job.getPriority());
        this.maxTriesSpinner.setValue(job.getMaxTries());
        this.maxDialsSpinner.setValue(job.getMaxDials());
        try {
            this.paperModel.setSelectedItem((Object)Paper.getEnum(job.getPageWidth(), job.getPageLength()));
        }
        catch (IllegalArgumentException e) {
            Dialogs.showError(this, JHylaFAX.i18n.tr("Unknown paper type. Using default."));
            this.paperModel.setSelectedItem(Settings.PAPER.getValue());
        }
    }

    public void revertFromSettings() {
        this.fullnameTextField.setText((String)Settings.FULLNAME.getValue());
        this.emailTextField.setText((String)Settings.EMAIL.getValue());
        this.notificationModel.setSelectedItem(Settings.NOTIFICATION.getValue());
        this.resolutionModel.setSelectedItem(Settings.RESOLUTION.getValue());
        this.prioritySpinner.setValue(Settings.PRIORITY.getValue());
        this.maxTriesSpinner.setValue(Settings.MAXTRIES.getValue());
        this.maxDialsSpinner.setValue(Settings.MAXDIALS.getValue());
        this.paperModel.setSelectedItem(Settings.PAPER.getValue());
    }

    public void applyToSettings() {
        Settings.FULLNAME.setValue(this.fullnameTextField.getText());
        Settings.EMAIL.setValue(this.emailTextField.getText());
        Settings.NOTIFICATION.setValue((Settings.Notification)((Object)this.notificationModel.getSelectedItem()));
        Settings.RESOLUTION.setValue((Settings.Resolution)((Object)this.resolutionModel.getSelectedItem()));
        Settings.PRIORITY.setValue(this.priorityModel.getNumber().intValue());
        Settings.MAXTRIES.setValue((Integer)this.maxTriesSpinner.getValue());
        Settings.MAXDIALS.setValue((Integer)this.maxDialsSpinner.getValue());
        Settings.PAPER.setValue((Paper)((Object)this.paperModel.getSelectedItem()));
    }

    public void revertFromDefaultSettings() {
        this.fullnameTextField.setText((String)Settings.FULLNAME.getDefaultValue());
        this.emailTextField.setText((String)Settings.EMAIL.getDefaultValue());
        this.notificationModel.setSelectedItem(Settings.NOTIFICATION.getDefaultValue());
        this.resolutionModel.setSelectedItem(Settings.RESOLUTION.getDefaultValue());
        this.prioritySpinner.setValue(Settings.PRIORITY.getDefaultValue());
        this.maxTriesSpinner.setValue(Settings.MAXTRIES.getDefaultValue());
        this.maxDialsSpinner.setValue(Settings.MAXDIALS.getDefaultValue());
        this.paperModel.setSelectedItem(Settings.PAPER.getDefaultValue());
    }
}

