/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.inet.ftp.ServerResponseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.TransferMonitor;
import net.sf.jhylafax.fax.Document;
import net.sf.jhylafax.fax.FaxJob;
import net.sf.jhylafax.fax.HylaFAXClientHelper;
import net.sf.jhylafax.fax.ReceivedFax;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.io.UserAbortException;

public class JobHelper {
    private static final Log logger = LogFactory.getLog(JobHelper.class);

    static void retryJob(final int jobID) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(3L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Retrying job"));
                Job editJob = client.getJob(jobID);
                client.suspend(editJob);
                editJob.setProperty("SENDTIME", "NOW");
                monitor.work(1L);
                client.submit(editJob);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error retrying job", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not retry job"), e);
        }
    }

    static void resumeJob(final int jobID) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(2L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Resuming job"));
                Job editJob = client.getJob(jobID);
                client.submit(editJob);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error resuming job", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not resume job"), e);
        }
    }

    static FileStat[] retrieveJobFilenames(final int jobID) {
        org.xnap.commons.io.Job<FileStat[]> ioJob = new org.xnap.commons.io.Job<FileStat[]>(){

            @Override
            public FileStat[] run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(2L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Getting document filenames"));
                Job editJob = client.getJob(jobID);
                String[] filenames = editJob.getDocumentName().split("\n");
                ArrayList<FileStat> results = new ArrayList<FileStat>(filenames.length);
                for (int i = 0; i < filenames.length; ++i) {
                    StringTokenizer t = new StringTokenizer(filenames[i]);
                    String filetype = t.nextToken();
                    if (!t.hasMoreTokens() || !"PS".equalsIgnoreCase(filetype) && !"PDF".equalsIgnoreCase(filetype)) continue;
                    String filename = t.nextToken();
                    try {
                        long filesize = client.size(filename);
                        results.add(new FileStat(filename, filesize));
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                monitor.work(1L);
                return results.toArray(new FileStat[0]);
            }
        };
        try {
            return JHylaFAX.getInstance().runJob(ioJob);
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error getting job documents", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not get filenames"), e);
        }
        return null;
    }

    static boolean delete(final String filename) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(2L);
                monitor.setText(JHylaFAX.i18n.tr("Deleting file"));
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                client.dele(filename);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
            return false;
        }
        catch (Exception e) {
            logger.debug("Error deleting file " + filename, e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not delete file"), e);
            return false;
        }
        return true;
    }

    static boolean save(final File file, final String filename, final long size) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(12L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Setting mode"));
                client.mode('S');
                client.type('I');
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Downloading file"));
                TransferMonitor transferMonitor = new TransferMonitor(monitor, 10, size);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    client.addTransferListener(transferMonitor);
                    client.get(filename, out);
                }
                finally {
                    transferMonitor.transferCompleted();
                    client.removeTransferListener(transferMonitor);
                    ((OutputStream)out).close();
                }
                monitor.work(0L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
        }
        catch (UserAbortException e) {
            return false;
        }
        catch (Exception e) {
            logger.debug("Error getting file " + filename, e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not download file"), e);
            return false;
        }
        return true;
    }

    static void removeJob(final int jobID) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(2L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Removing job"));
                Job editJob = client.getJob(jobID);
                client.kill(editJob);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error killing job", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not remove job"), e);
        }
    }

    static void suspendJob(final int jobID) {
        org.xnap.commons.io.Job ioJob = new org.xnap.commons.io.Job(){

            public Object run(ProgressMonitor monitor) throws Exception {
                monitor.setTotalSteps(2L);
                HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
                monitor.work(1L);
                monitor.setText(JHylaFAX.i18n.tr("Suspending job"));
                Job editJob = client.getJob(jobID);
                client.suspend(editJob);
                monitor.work(1L);
                return null;
            }
        };
        try {
            JHylaFAX.getInstance().runJob(ioJob);
            JHylaFAX.getInstance().updateTables();
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error suspending job", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not suspend job"), e);
        }
    }

    public static StatusResponse updateStatus() {
        StatusUpdateJob ioJob = new StatusUpdateJob();
        try {
            return JHylaFAX.getInstance().runJob(ioJob);
        }
        catch (UserAbortException e) {
        }
        catch (Exception e) {
            logger.debug("Error updating status", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Could not get status"), e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatusUpdateJob
    implements org.xnap.commons.io.Job<StatusResponse> {
        @Override
        public StatusResponse run(ProgressMonitor monitor) throws Exception {
            monitor.setTotalSteps(7L);
            HylaFAXClient client = JHylaFAX.getInstance().getConnection(monitor);
            monitor.work(1L);
            StatusResponse response = new StatusResponse();
            monitor.setText(JHylaFAX.i18n.tr("Getting Status"));
            Vector lines = client.getList("status");
            StringBuffer sb = new StringBuffer();
            for (String line : lines) {
                if (response.status == null) {
                    response.status = line;
                }
                sb.append(line + "\n");
            }
            response.verboseStatus = sb.toString();
            monitor.work(1L);
            client.jobfmt("__JOBFMT |%a |%b |%c |%e |%f |%g |%h |%i |%j |%k |%l |%m |%n |%o |%p |%q |%r |%t |%u |%v |%w |%x |%y |%z |%A |%B |%C |%D |%E |%F |%G |%H |%I |%J |%K |%L |%M |%N |%O |%P |%Q |%R |%S |%U |%V |%W |%X |%Y |%Z |%s ");
            client.rcvfmt("__RCVFMT |%Y |%a |%b |%d |%e |%f |%h |%i |%j |%l |%n |%o |%p |%r |%s |%w |%z ");
            client.filefmt("__FILEFMT |%d |%f |%g |%i |%l |%o |%p |%q |%r |%s |%m ");
            response.recvq = this.getQueue(monitor, client, "recvq", ReceivedFax.class);
            response.sendq = this.getQueue(monitor, client, "sendq", FaxJob.class);
            response.pollq = this.getQueue(monitor, client, "pollq", FaxJob.class);
            response.doneq = this.getQueue(monitor, client, "doneq", FaxJob.class);
            response.docq = this.getQueue(monitor, client, "docq", Document.class);
            return response;
        }

        private <T> List<T> getQueue(ProgressMonitor monitor, HylaFAXClient client, String name, Class<T> clazz) throws IOException, ServerResponseException {
            monitor.setText(JHylaFAX.i18n.tr("Getting {0}", name));
            ArrayList<Object> result = new ArrayList<Object>();
            Vector lines = client.getList(name);
            for (String line : lines) {
                Object o = HylaFAXClientHelper.parseFmt(line);
                if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
                result.add(o);
            }
            monitor.work(1L);
            return result;
        }
    }

    public static class StatusResponse {
        String status;
        String verboseStatus;
        List<ReceivedFax> recvq;
        List<FaxJob> sendq;
        List<FaxJob> pollq;
        List<FaxJob> doneq;
        List<Document> docq;
    }

    public static class FileStat {
        public String filename;
        public long filesize;

        public FileStat(String filename, long filesize) {
            this.filename = filename;
            this.filesize = filesize;
        }
    }
}

