/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.util.QuotedStringTokenizer;
import org.xnap.commons.util.StringHelper;

public class JHylaFAXHelper {
    private static final Log logger = LogFactory.getLog(JobHelper.class);

    public static void view(String viewerPath, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            ArrayList<String> args = new ArrayList<String>();
            QuotedStringTokenizer t = new QuotedStringTokenizer(viewerPath);
            boolean filenameAdded = false;
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if ("%s".equals(token) || "%f".equals(token) || "$f".equals(token)) {
                    args.add(files[i].getAbsolutePath());
                    filenameAdded = true;
                    continue;
                }
                args.add(token);
            }
            if (!filenameAdded) {
                args.add(files[i].getAbsolutePath());
            }
            if (JHylaFAXHelper.execute(args.toArray(new String[0]))) continue;
            return;
        }
    }

    public static boolean execute(String[] args) {
        try {
            Runtime.getRuntime().exec(args);
            return true;
        }
        catch (IOException e) {
            logger.debug("Error executing viewer: '" + StringHelper.toString(args, " ") + "'", e);
            ErrorDialog.showError(JHylaFAX.getInstance(), JHylaFAX.i18n.tr("Could not execute viewer"), JHylaFAX.i18n.tr("JHylaFAX Error"), e);
            return false;
        }
    }

    public static String getViewerPath(String filename) {
        String viewerPath = filename.startsWith("recvq") ? ((String)Settings.VIEWER_PATH.getValue()).trim() : ((String)Settings.DOC_VIEWER_PATH.getValue()).trim();
        if (viewerPath.length() == 0) {
            JHylaFAX.getInstance().showError(GUIHelper.tt(JHylaFAX.i18n.tr("Could not open file: Please enter the path of an external viewer in the settings.")));
            return null;
        }
        return viewerPath;
    }
}

