/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.ConnectionListener;
import gnu.inet.ftp.ServerResponseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.ArgsHandler;
import net.sf.jhylafax.DocumentQueuePanel;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.JobQueue;
import net.sf.jhylafax.JobQueuePanel;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Notification;
import net.sf.jhylafax.NotificationTimer;
import net.sf.jhylafax.PollDialog;
import net.sf.jhylafax.ReceiveQueuePanel;
import net.sf.jhylafax.SendDialog;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.SettingsDialog;
import net.sf.jhylafax.SettingsWizard;
import net.sf.jhylafax.addressbook.AddressBook;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.xnap.commons.gui.AboutDialog;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.ErrorDialog;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.shortcut.ActionShortcut;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.IconHelper;
import org.xnap.commons.gui.util.LabelUpdater;
import org.xnap.commons.gui.util.WhatsThisAction;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.i18n.I18nManager;
import org.xnap.commons.io.Job;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.io.UserAbortException;
import org.xnap.commons.settings.SettingStore;
import org.xnap.commons.util.FileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHylaFAX
extends JFrame
implements LocaleChangeListener {
    public static final I18n i18n = I18nFactory.getI18n(JHylaFAX.class);
    public static final String JDK14_LOG_CONFIG_KEY = "java.util.logging.config.file";
    public static final Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, new Locale("ca"), new Locale("cs"), new Locale("de"), new Locale("es"), new Locale("fr"), new Locale("it"), new Locale("nl"), new Locale("pl"), new Locale("pt", "BR"), new Locale("tr")};
    private static final Log logger = LogFactory.getLog(JHylaFAX.class);
    private static final int BUFFER_SIZE = 524288;
    private static JHylaFAX app;
    private JTabbedPane mainTabbedPane;
    private JMenu fileMenu;
    private SettingsDialogAction settingsDialogAction;
    private JPanel statusBarPanel;
    private JLabel statusLabel;
    private JLabel serverInfoLabel;
    private ExitAction exitAction;
    private UpdateStatusAction updateStatusAction;
    private HylaFAXClient connection;
    private JToolBar mainToolBar;
    private SendAction sendAction;
    private PollAction pollAction;
    private JMenu helpMenu;
    private AboutAction aboutAction;
    private String password;
    private String adminPassword;
    private ResourceBundle resources;
    private ConnectionHandler connectionHandler = new ConnectionHandler();
    private ActionShortcut sendActionShortcut;
    private AddressBook addressBook;
    private AddressBookAction addressBookAction;
    private ActionShortcut updateStatusActionShortcut;
    private ReceiveQueuePanel recvqPanel;
    private JobQueuePanel sendqPanel;
    private JobQueuePanel pollqPanel;
    private JobQueuePanel doneqPanel;
    private DocumentQueuePanel docqPanel;
    private SettingsWizardAction settingsWizardAction;
    private JobQueue jobQueue = new JobQueue();
    private NotificationTimer notificationTimer = new NotificationTimer();
    private File addressBookFile;
    private Object connectionLock = new Object();

    public JHylaFAX() {
        app = this;
        try {
            Settings.load(JHylaFAX.getSettingsFile());
            Settings.DEFAULT_COMPLETION_MODE.updateMode();
        }
        catch (FileNotFoundException e) {
            logger.debug("Error loading settings", e);
        }
        catch (IOException e) {
            logger.debug("Error loading settings", e);
            ErrorDialog.showError(this, i18n.tr("Could not load settings"), i18n.tr("JHylaFAX Error"), e);
        }
        this.updateResourceBundle();
        I18nManager.getInstance().addLocaleChangeListener(new LabelUpdater());
        JHylaFAX.initializeToolkit();
        this.initialize();
        this.restoreLayout();
        PropertyChangeListener disconnector = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (JHylaFAX.this.connection != null) {
                    try {
                        JHylaFAX.this.connection.quit();
                    }
                    catch (Exception e) {
                        logger.debug("Error closing connection", e);
                    }
                    JHylaFAX.this.connection = null;
                }
            }
        };
        Settings.HOSTNAME.addPropertyChangeListener(disconnector);
        Settings.PORT.addPropertyChangeListener(disconnector);
        Settings.USE_PASSIVE.addPropertyChangeListener(disconnector);
        Settings.USERNAME.addPropertyChangeListener(disconnector);
        Settings.LOCALE.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JHylaFAX.this.updateResourceBundle();
            }
        });
        this.notificationTimer.settingsUpdated();
    }

    private void restoreLayout() {
        SettingStore store = new SettingStore(Settings.backstore);
        store.restoreWindow("window.main", 40, 40, 540, 400, this);
        this.recvqPanel.restoreLayout(store, new String[]{"sender", "pages", "time", "filename", "filesize", "error"});
        this.sendqPanel.restoreLayout(store, new String[]{"id", "priority", "sender", "number", "dials", "pages", "error", "state"});
        this.pollqPanel.restoreLayout(store, new String[]{"id", "priority", "sender", "number", "dials", "pages", "error", "state"});
        this.doneqPanel.restoreLayout(store, new String[]{"id", "priority", "sender", "number", "dials", "pages", "error", "state"});
        this.docqPanel.restoreLayout(store, new String[]{"permissions", "owner", "modified", "filename", "filesize", "time"});
    }

    private void saveLayout() {
        SettingStore store = new SettingStore(Settings.backstore);
        store.saveWindow("window.main", this);
        this.recvqPanel.saveLayout(store);
        this.sendqPanel.saveLayout(store);
        this.pollqPanel.saveLayout(store);
        this.doneqPanel.saveLayout(store);
        this.docqPanel.saveLayout(store);
    }

    private void updateResourceBundle() {
        try {
            I18nManager.getInstance().setDefaultLocale((Locale)Settings.LOCALE.getValue());
        }
        catch (MissingResourceException e) {
            logger.warn("Error loading resource bundle", e);
        }
    }

    public static void initializeToolkit() {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        UIManager.put("SplitPaneDivider.border", new BasicBorders.MarginBorder());
        UIManager.put("TitledBorder.font", UIManager.getFont("Label.font").deriveFont(1));
        UIManager.put("TitledBorder.titleColor", UIManager.getColor("Label.foreground").brighter());
        Builder.setProperty("enhancedTextFieldMenu", true);
    }

    private void initialize() {
        this.initializeActions();
        this.initializeShortCuts();
        this.initializeMenuBar();
        this.initializeContent();
        this.initializeToolBar();
        this.initializeStatusBar();
        this.updateLabels();
        this.updateServerInfo();
    }

    private void initializeActions() {
        this.updateStatusAction = new UpdateStatusAction();
        this.settingsDialogAction = new SettingsDialogAction();
        this.settingsWizardAction = new SettingsWizardAction();
        this.addressBookAction = new AddressBookAction();
        this.exitAction = new ExitAction();
        this.sendAction = new SendAction();
        this.pollAction = new PollAction();
        this.aboutAction = new AboutAction();
    }

    private void initializeShortCuts() {
        this.sendActionShortcut = new ActionShortcut(this.sendAction);
        this.sendActionShortcut.setKeyStroke(KeyStroke.getKeyStroke(83, 2));
        this.updateStatusActionShortcut = new ActionShortcut(this.updateStatusAction);
        this.updateStatusActionShortcut.setKeyStroke(KeyStroke.getKeyStroke(116, 0));
    }

    private void initializeContent() {
        this.setTitle("JHylaFAX");
        this.setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                JHylaFAX.this.exit();
            }
        });
        this.mainTabbedPane = new JTabbedPane();
        this.mainTabbedPane.setBorder(GUIHelper.createEmptyBorder(10));
        this.getContentPane().add((Component)this.mainTabbedPane, "Center");
        this.recvqPanel = new ReceiveQueuePanel("recvq");
        this.mainTabbedPane.addTab("", IconHelper.getTabTitleIcon("folder_outbox.png"), this.recvqPanel);
        this.sendqPanel = new JobQueuePanel("sendq");
        this.mainTabbedPane.addTab("", IconHelper.getTabTitleIcon("folder_outbox.png"), this.sendqPanel);
        this.doneqPanel = new JobQueuePanel("doneq");
        this.mainTabbedPane.addTab("", IconHelper.getTabTitleIcon("folder_sent_mail.png"), this.doneqPanel);
        this.pollqPanel = new JobQueuePanel("pollq");
        if (((Boolean)Settings.SHOW_POLLQ.getValue()).booleanValue()) {
            this.mainTabbedPane.addTab("", IconHelper.getTabTitleIcon("folder_print.png"), this.pollqPanel);
        }
        this.docqPanel = new DocumentQueuePanel("docq");
        this.mainTabbedPane.addTab("", IconHelper.getTabTitleIcon("folder_txt.png"), this.docqPanel);
    }

    public void exit() {
        if (this.addressBook != null) {
            try {
                this.addressBook.saveLayout(new SettingStore(Settings.backstore));
                this.addressBook.store(this.addressBookFile);
            }
            catch (Exception e) {
                logger.debug("Error storing addressbook", e);
                ErrorDialog.showError(this, i18n.tr("Could not store addressbook"), i18n.tr("JHylaFAX Error"), e);
            }
        }
        this.saveLayout();
        try {
            Settings.store(JHylaFAX.getSettingsFile());
        }
        catch (IOException e) {
            logger.debug("Error storing settings", e);
            ErrorDialog.showError(this, i18n.tr("Could not store settings"), i18n.tr("JHylaFAX Error"), e);
        }
        System.exit(0);
    }

    private void initializeToolBar() {
        this.mainToolBar = new JToolBar();
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.mainToolBar.add(Builder.createToolBarButton(this.sendAction));
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(Builder.createToolBarButton(this.updateStatusAction));
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(Builder.createToolBarButton(this.addressBookAction));
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(Builder.createToolBarButton(this.settingsDialogAction));
    }

    private void initializeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.fileMenu = new JMenu();
        menuBar.add(this.fileMenu);
        JComponent item = Builder.createMenuItem(this.sendAction);
        this.sendActionShortcut.setMenuItem((JMenuItem)item);
        this.fileMenu.add(item);
        this.fileMenu.add(Builder.createMenuItem(this.pollAction));
        this.fileMenu.addSeparator();
        item = Builder.createMenuItem(this.updateStatusAction);
        this.fileMenu.add(item);
        this.updateStatusActionShortcut.setMenuItem((JMenuItem)item);
        this.fileMenu.addSeparator();
        this.fileMenu.add(Builder.createMenuItem(this.settingsDialogAction));
        this.fileMenu.add(Builder.createMenuItem(this.settingsWizardAction));
        this.fileMenu.addSeparator();
        this.fileMenu.add(Builder.createMenuItem(this.addressBookAction));
        this.fileMenu.addSeparator();
        this.fileMenu.add(Builder.createMenuItem(this.exitAction));
        this.helpMenu = new JMenu();
        menuBar.add(this.helpMenu);
        this.helpMenu.add(Builder.createMenuItem(new WhatsThisAction()));
        this.helpMenu.addSeparator();
        this.helpMenu.add(Builder.createMenuItem(this.aboutAction));
    }

    private void initializeStatusBar() {
        this.statusBarPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.statusBarPanel, "South");
        this.statusLabel = new JLabel();
        this.statusBarPanel.add((Component)this.statusLabel, "Center");
        this.serverInfoLabel = new JLabel();
        this.statusBarPanel.add((Component)this.serverInfoLabel, "East");
    }

    public static JHylaFAX getInstance() {
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HylaFAXClient getConnection(ProgressMonitor monitor) throws IOException, ServerResponseException {
        Object object = this.connectionLock;
        synchronized (object) {
            monitor.setText(i18n.tr("Connecting to {0}", (String)Settings.HOSTNAME.getValue() + ":" + Settings.PORT.getValue()));
            if (this.connection == null) {
                this.connection = new HylaFAXClient();
                this.connection.addConnectionListener(this.connectionHandler);
                this.connection.setPassive((Boolean)Settings.USE_PASSIVE.getValue());
            }
            logger.info("Connecting to HylaFAX server at " + (String)Settings.HOSTNAME.getValue() + ":" + Settings.PORT.getValue());
            this.connection.open((String)Settings.HOSTNAME.getValue(), (Integer)Settings.PORT.getValue());
            if (this.password == null) {
                this.password = (String)Settings.PASSWORD.getValue();
            }
            while (this.connection.user((String)Settings.USERNAME.getValue())) {
                if (this.password.length() == 0) {
                    this.password = this.requestPassword(monitor, false);
                    if (this.password == null) {
                        throw new UserAbortException();
                    }
                }
                try {
                    this.connection.pass(this.password);
                    break;
                }
                catch (ServerResponseException e) {
                    this.password = "";
                }
            }
            if (this.adminPassword == null) {
                this.adminPassword = (String)Settings.ADMIN_PASSWORD.getValue();
            }
            if (((Boolean)Settings.ADMIN_MODE.getValue()).booleanValue()) {
                while (true) {
                    if (this.adminPassword.length() == 0) {
                        this.adminPassword = this.requestPassword(monitor, true);
                        if (this.adminPassword == null) break;
                    }
                    try {
                        this.connection.admin(this.adminPassword);
                    }
                    catch (ServerResponseException e) {
                        this.adminPassword = "";
                        continue;
                    }
                    break;
                }
            }
            return this.connection;
        }
    }

    private String requestPassword(final ProgressMonitor monitor, final boolean admin) throws ServerResponseException {
        final String[] password = new String[1];
        Runnable runner = new Runnable(){

            public void run() {
                String host = (String)Settings.USERNAME.getValue() + "@" + (String)Settings.HOSTNAME.getValue();
                password[0] = Dialogs.requestPassword(monitor.getComponent(), admin ? i18n.tr("Enter admin password for {0}:", host) : i18n.tr("Enter password for {0}:", host), i18n.tr("JHylaFAX Connection"));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runner);
            return password[0];
        }
        catch (InterruptedException e) {
            logger.error("Unexpected exception while waiting for password", e);
            throw new ServerResponseException(i18n.tr("Abort by user."));
        }
        catch (InvocationTargetException e) {
            logger.error("Unexpected exception while waiting for password", e);
            throw new ServerResponseException(i18n.tr("Abort by user."));
        }
    }

    public static File getSettingsFile() throws IOException {
        return new File(FileHelper.getHomeDir("jhylafax"), "jhlafax.prefs");
    }

    public static File getAddressBookFile() throws IOException {
        if (((Boolean)Settings.CUSTOMIZE_ADDRESS_BOOK_FILENAME.getValue()).booleanValue()) {
            return new File((String)Settings.ADDRESS_BOOK_FILENAME.getValue());
        }
        return new File(FileHelper.getHomeDir("jhylafax"), (String)Settings.ADDRESS_BOOK_FILENAME.getDefaultValue());
    }

    public <T> T runJob(Job<T> job) throws Exception {
        return this.jobQueue.runJob(null, job);
    }

    public <T> T runJob(JDialog owner, Job<T> job) throws Exception {
        return this.jobQueue.runJob(owner, job);
    }

    public void updateServerInfo() {
        this.serverInfoLabel.setText((String)Settings.HOSTNAME.getValue() + ":" + Settings.PORT.getValue());
    }

    @Override
    public void updateLabels() {
        this.fileMenu.setText(i18n.tr("File"));
        this.helpMenu.setText(i18n.tr("Help"));
        for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
            AbstractQueuePanel panel = (AbstractQueuePanel)this.mainTabbedPane.getComponent(i);
            panel.updateLabels();
            String queueName = panel.getQueueName();
            if (queueName.equals("recvq")) {
                this.mainTabbedPane.setTitleAt(i, i18n.tr("Received"));
                continue;
            }
            if (queueName.equals("sendq")) {
                this.mainTabbedPane.setTitleAt(i, i18n.tr("Sending"));
                continue;
            }
            if (queueName.equals("pollq")) {
                this.mainTabbedPane.setTitleAt(i, i18n.tr("Pollable"));
                continue;
            }
            if (queueName.equals("doneq")) {
                this.mainTabbedPane.setTitleAt(i, i18n.tr("Done"));
                continue;
            }
            if (!queueName.equals("docq")) continue;
            this.mainTabbedPane.setTitleAt(i, i18n.tr("Documents"));
        }
        this.sendAction.putValue("Name", i18n.tr("Send Fax..."));
        this.sendAction.putValue("ShortDescription", i18n.tr("Opens a dialog for sending a fax"));
        this.pollAction.putValue("Name", i18n.tr("Poll Fax..."));
        this.pollAction.putValue("ShortDescription", i18n.tr("Opens a dialog for polling a fax"));
        this.addressBookAction.putValue("Name", i18n.tr("Address Book"));
        this.updateStatusAction.putValue("Name", i18n.tr("Update Status"));
        this.updateStatusAction.putValue("ShortDescription", i18n.tr("Queries the status from the server"));
        this.settingsDialogAction.putValue("Name", i18n.tr("Settings..."));
        this.settingsDialogAction.putValue("ShortDescription", i18n.tr("Displays the settings dialog"));
        this.settingsDialogAction.updateLabels();
        this.settingsWizardAction.putValue("Name", i18n.tr("Setup Wizard..."));
        this.settingsWizardAction.putValue("ShortDescription", i18n.tr("Displays the settings wizard"));
        this.settingsWizardAction.updateLabels();
        this.exitAction.putValue("Name", i18n.tr("Exit"));
        this.exitAction.putValue("ShortDescription", i18n.tr("Closes the application"));
        this.aboutAction.putValue("Name", i18n.tr("About..."));
        this.aboutAction.putValue("ShortDescription", i18n.tr("Opens a dialog that displays funny information"));
        GUIHelper.setMnemonics(this.getJMenuBar());
    }

    public static void main(String[] args) {
        final ArgsHandler handler = new ArgsHandler();
        handler.evaluate(args);
        JHylaFAX.evaluateArgumentsPreVisible(handler);
        ThreadGroup tg = new ThreadGroup("JHylaFAXThreadGroup"){

            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        };
        Thread mainRunner = new Thread(tg, "JHylaFAXMain"){

            public void run() {
                this.setContextClassLoader(JHylaFAX.class.getClassLoader());
                JHylaFAX app = new JHylaFAX();
                app.setVisible(true);
                app.evaluateArgumentsPostVisible(handler);
            }
        };
        mainRunner.start();
    }

    private static void evaluateArgumentsPreVisible(ArgsHandler handler) {
        URL url = JHylaFAX.class.getResource(handler.getLogConfigFilename());
        if (url != null) {
            PropertyConfigurator.configure(url);
        } else {
            System.err.println("Could not find logging configuration: " + handler.getLogConfigFilename());
            BasicConfigurator.configure();
        }
    }

    protected void evaluateArgumentsPostVisible(ArgsHandler handler) {
        if (!((Boolean)Settings.HAS_SEEN_WIZARD.getValue()).booleanValue()) {
            SettingsWizard wizard = new SettingsWizard(this);
            wizard.setModal(true);
            wizard.setLocationRelativeTo(this);
            wizard.setVisible(true);
        }
        if (((Boolean)Settings.UPDATE_ON_STARTUP.getValue()).booleanValue()) {
            this.updateTables();
        }
        String[] filenames = handler.getFilenames();
        String[] numbers = handler.getNumbers();
        File tempFile = null;
        if (handler.getReadStdin() && (tempFile = this.saveStdInToFile()) != null) {
            String[] newFilenames = new String[filenames.length + 1];
            newFilenames[0] = tempFile.getAbsolutePath();
            System.arraycopy(filenames, 0, newFilenames, 1, filenames.length);
            filenames = newFilenames;
        }
        if (filenames.length > 0 || numbers.length > 0) {
            SendDialog dialog = new SendDialog(this);
            for (String number : numbers) {
                dialog.setNumber(number);
            }
            if (filenames.length > 0) {
                dialog.setDocument(filenames[0]);
                for (int i = 1; i < filenames.length; ++i) {
                    dialog.addDocument(filenames[i]);
                }
            }
            dialog.setQuitAfterSending(handler.getQuitAfterSending());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveStdInToFile() {
        File tempFile;
        try {
            tempFile = File.createTempFile("jhylafax", null);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            logger.debug("Error creating temporary file", e);
            ErrorDialog.showError(JHylaFAX.getInstance(), i18n.tr("Error creating temporary file"), i18n.tr("JHylaFAX Error"), e);
            return null;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(System.in);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                try {
                    int bytesRead;
                    byte[] buf = new byte[524288];
                    while ((bytesRead = in.read(buf)) > 0) {
                        out.write(buf, 0, bytesRead);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            logger.debug("Error creating temporary file", e);
            ErrorDialog.showError(JHylaFAX.getInstance(), i18n.tr("Error creating temporary file"), i18n.tr("JHylaFAX Error"), e);
            return null;
        }
        return tempFile;
    }

    public void updateTables() {
        this.updateTables(JobHelper.updateStatus());
    }

    public void updateTables(JobHelper.StatusResponse response) {
        this.jobQueue.setLastUpdate(System.currentTimeMillis());
        if (response != null) {
            this.updateServerInfo();
            this.statusLabel.setText(response.status);
            this.statusLabel.setToolTipText("<html><pre><b>" + response.verboseStatus + "</b></pre>");
            this.recvqPanel.setData(response.recvq);
            this.sendqPanel.setData(response.sendq);
            this.pollqPanel.setData(response.pollq);
            this.doneqPanel.setData(response.doneq);
            this.docqPanel.setData(response.docq);
        }
    }

    public AddressBook getAddressBook() {
        if (this.addressBook == null) {
            this.addressBook = new AddressBook();
            this.addressBook.restoreLayout(new SettingStore(Settings.backstore));
            try {
                this.addressBookFile = JHylaFAX.getAddressBookFile();
                if (this.addressBookFile.exists()) {
                    this.addressBook.load(this.addressBookFile);
                }
            }
            catch (Exception e) {
                logger.debug("Error loading addressbook", e);
                ErrorDialog.showError(this, i18n.tr("Could not load addressbook"), i18n.tr("JHylaFAX Error"), e);
            }
        }
        return this.addressBook;
    }

    public void showError(String message, Exception e) {
        ErrorDialog.showError(this, message, i18n.tr("JHylaFAX Error"), e);
    }

    public void showError(String message) {
        Dialogs.showError((Component)this, message, i18n.tr("JHylaFAX Error"));
    }

    public void resetAllTables() {
        this.recvqPanel.resetTable();
        this.sendqPanel.resetTable();
        this.pollqPanel.resetTable();
        this.doneqPanel.resetTable();
        this.docqPanel.resetTable();
    }

    public void runNotification(Notification notification) {
        this.jobQueue.addNotification(notification);
    }

    public void settingsUpdated() {
        this.notificationTimer.settingsUpdated();
    }

    private class ConnectionHandler
    implements ConnectionListener {
        private ConnectionHandler() {
        }

        public void connectionOpened(ConnectionEvent event) {
            logger.info("Connected to " + event.getRemoteInetAddress().getHostAddress() + ":" + event.getRemotePort());
        }

        public void connectionClosed(ConnectionEvent event) {
            logger.info("Disconnected from " + event.getRemoteInetAddress().getHostAddress() + ":" + event.getRemotePort());
            JHylaFAX.this.connection.removeConnectionListener(this);
            JHylaFAX.this.connection = null;
        }

        public void connectionFailed(Exception e) {
            logger.info("Connection failed", e);
            JHylaFAX.this.connection.removeConnectionListener(this);
            JHylaFAX.this.connection = null;
        }
    }

    private class UpdateStatusAction
    extends AbstractXNapAction {
        public UpdateStatusAction() {
            this.putValue("XNapIcon", "reload.png");
        }

        public void actionPerformed(ActionEvent e) {
            JHylaFAX.this.updateTables();
        }
    }

    private class ExitAction
    extends AbstractXNapAction {
        public ExitAction() {
            this.putValue("XNapIcon", "exit.png");
        }

        public void actionPerformed(ActionEvent e) {
            JHylaFAX.this.exit();
        }
    }

    private class SettingsWizardAction
    extends AbstractXNapAction
    implements LocaleChangeListener {
        public SettingsWizardAction() {
            this.putValue("XNapIcon", "wizard.png");
        }

        public void updateLabels() {
        }

        public void actionPerformed(ActionEvent e) {
            SettingsWizard wizard = new SettingsWizard(JHylaFAX.this);
            wizard.setLocationRelativeTo(JHylaFAX.this);
            wizard.setVisible(true);
        }
    }

    private class SettingsDialogAction
    extends AbstractXNapAction
    implements LocaleChangeListener {
        private SettingsDialog dialog;

        public SettingsDialogAction() {
            this.putValue("XNapIcon", "configure.png");
        }

        public void updateLabels() {
            if (this.dialog != null) {
                this.dialog.updateLabels();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = new SettingsDialog(JHylaFAX.this);
                this.dialog.setLocationRelativeTo(JHylaFAX.this);
            }
            if (!this.dialog.isVisible()) {
                this.dialog.revert();
                this.dialog.setVisible(true);
            }
        }
    }

    private class PollAction
    extends AbstractXNapAction {
        public PollAction() {
            this.putValue("XNapIcon", "mail_get.png");
        }

        public void actionPerformed(ActionEvent e) {
            PollDialog dialog = new PollDialog(JHylaFAX.this);
            dialog.setLocationRelativeTo(JHylaFAX.this);
            dialog.setVisible(true);
        }
    }

    private class SendAction
    extends AbstractXNapAction {
        public SendAction() {
            this.putValue("XNapIcon", "mail_new.png");
        }

        public void actionPerformed(ActionEvent e) {
            SendDialog dialog = new SendDialog(JHylaFAX.this);
            dialog.setLocationRelativeTo(JHylaFAX.this);
            dialog.setVisible(true);
        }
    }

    private class AddressBookAction
    extends AbstractXNapAction {
        public AddressBookAction() {
            this.putValue("XNapIcon", "contents.png");
        }

        public void actionPerformed(ActionEvent e) {
            JHylaFAX.this.getAddressBook().setVisible(true);
        }
    }

    private class AboutAction
    extends AbstractXNapAction {
        private AboutDialog dialog;

        public AboutAction() {
            this.putValue("XNapIcon", "jhylafax.png");
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = new AboutDialog();
                this.dialog.setTitle(i18n.tr("About JHylaFax {0}", "1.3.9"));
                this.dialog.setLocationRelativeTo(JHylaFAX.this);
                this.dialog.addHTMLTab(i18n.tr("General Information"), "about.html", true);
                JTextArea textArea = this.dialog.addTab(i18n.tr("License"), "LICENSE.jhylafax");
                textArea.setFont(new Font("Monospaced", 0, 10));
                this.dialog.addHTMLTab(i18n.tr("3rd Party Software"), "LICENSE.other.html", true);
                this.dialog.getTabbedPane().setSelectedIndex(0);
            }
            if (!this.dialog.isVisible()) {
                this.dialog.setVisible(true);
            }
        }
    }
}

