/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.fax.Document;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.util.DoubleClickListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentQueuePanel
extends AbstractQueuePanel {
    private AbstractQueuePanel.ViewAction viewAction = new AbstractQueuePanel.ViewAction(this);
    private AbstractQueuePanel.SaveAction saveAction = new AbstractQueuePanel.SaveAction(this);
    private AbstractQueuePanel.DeleteAction deleteAction = new AbstractQueuePanel.DeleteAction(this);
    private DocTableModel docTableModel;

    public DocumentQueuePanel(String queueName) {
        super(queueName);
        this.getButtonPanel().add(Builder.createButton(this.viewAction));
        this.getButtonPanel().add(Builder.createButton(this.saveAction));
        this.getButtonPanel().add(Builder.createButton(this.deleteAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.viewAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.saveAction));
        this.getTablePopupMenu().add(Builder.createMenuItem(this.deleteAction));
        this.getTable().addMouseListener(new DoubleClickListener(this.viewAction));
        this.updateLabels();
        this.updateActions();
    }

    @Override
    public JobHelper.FileStat getSelectedFile() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        Document doc = this.docTableModel.getDocument(row);
        return new JobHelper.FileStat(doc.getFilename(), doc.getFilesize());
    }

    @Override
    protected TableModel getTableModel() {
        if (this.docTableModel == null) {
            this.docTableModel = new DocTableModel();
        }
        return this.docTableModel;
    }

    @Override
    protected void initializeTableLayout() {
        this.getTableLayout().setColumnProperties(0, "permissions", 40);
        this.getTableLayout().setColumnProperties(1, "owner", 40);
        this.getTableLayout().setColumnProperties(2, "created", 80);
        this.getTableLayout().setColumnProperties(3, "modified", 80);
        this.getTableLayout().setColumnProperties(4, "accessed", 80);
        this.getTableLayout().setColumnProperties(5, "filename", 120);
        this.getTableLayout().setColumnProperties(6, "filesize", 20);
    }

    public void setData(List<Document> data) {
        this.docTableModel.setData(data);
    }

    @Override
    public void updateActions() {
        JobHelper.FileStat file = this.getSelectedFile();
        this.viewAction.setEnabled(file != null);
        this.saveAction.setEnabled(file != null);
        this.deleteAction.setEnabled(file != null);
    }

    @Override
    public void updateLabels() {
        super.updateLabels();
        this.viewAction.updateLabels();
        this.saveAction.updateLabels();
        this.deleteAction.updateLabels();
        this.getTableLayout().setColumnNames(new String[]{JHylaFAX.i18n.tr("Permissions"), JHylaFAX.i18n.tr("Owner"), JHylaFAX.i18n.tr("Created"), JHylaFAX.i18n.tr("Modified"), JHylaFAX.i18n.tr("Accessed"), JHylaFAX.i18n.tr("Name"), JHylaFAX.i18n.tr("Size")});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocTableModel
    extends AbstractTableModel {
        private static final Class[] columnClasses = new Class[]{Integer.class, String.class, Date.class, Date.class, Date.class, String.class, Long.class};
        private List<Document> data = new ArrayList<Document>(0);

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return columnClasses.length;
        }

        public Document getDocument(int row) {
            return this.data.get(row);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Document doc = this.data.get(row);
            switch (column) {
                case 0: {
                    return doc.getPermissions();
                }
                case 1: {
                    return doc.getOwner();
                }
                case 2: {
                    return doc.getCreationTime();
                }
                case 3: {
                    return doc.getLastModificationTime();
                }
                case 4: {
                    return doc.getLastAccessTime();
                }
                case 5: {
                    return doc.getFilename();
                }
                case 6: {
                    return doc.getFilesize();
                }
            }
            return null;
        }

        public void setData(List<Document> data) {
            this.data = data;
            this.fireTableDataChanged();
        }
    }
}

