/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.jhylafax.JHylaFAX;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.ColoredTable;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.table.SortableModel;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.gui.table.TableSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailsDialog
extends DefaultDialog {
    private static final Log logger = LogFactory.getLog(DetailsDialog.class);
    private KeyValueTableModel jobTableModel;
    private ColoredTable jobTable;
    private TableLayout jobTableLayout;
    private List<Property> data;

    public DetailsDialog(JFrame owner, List<Property> data) {
        super((Frame)owner, BUTTON_CLOSE);
        this.initialize();
        this.setData(data);
        this.revert();
        this.updateLabels();
        this.pack();
    }

    public void setData(List<Property> data) {
        this.data = data;
    }

    public List<Property> getData() {
        return this.data;
    }

    private void initialize() {
        this.jobTableModel = new KeyValueTableModel();
        TableSorter sorter = new TableSorter(this.jobTableModel);
        this.jobTable = new ColoredTable(sorter);
        this.jobTable.setShowVerticalLines(true);
        this.jobTable.setShowHorizontalLines(false);
        this.jobTable.setAutoCreateColumnsFromModel(true);
        this.jobTable.setIntercellSpacing(new Dimension(2, 1));
        this.jobTable.setDefaultRenderer(Object.class, new ValueTableCellRenderer());
        this.jobTableLayout = new TableLayout(this.jobTable);
        this.jobTableLayout.setColumnProperties(0, "key", 200);
        this.jobTableLayout.setColumnProperties(1, "value", 150);
        this.jobTableLayout.setMaintainSortOrder(true);
        this.jobTableLayout.sortByColumn(0, SortableModel.Order.ASCENDING, false);
        this.setMainComponent(new JScrollPane(this.jobTable));
    }

    public void revert() {
        this.jobTableModel.setJob(this.data);
    }

    public void updateLabels() {
        this.setTitle(JHylaFAX.i18n.tr("JHylaFAX Job Details"));
        this.jobTableLayout.setColumnNames(new String[]{JHylaFAX.i18n.tr("Property"), JHylaFAX.i18n.tr("Value")});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyValueTableModel
    extends AbstractTableModel {
        private List<Property> data = new ArrayList<Property>();
        private static final Class[] columnClasses = new Class[]{String.class, Object.class};

        public void setJob(List<Property> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Property property = this.data.get(row);
            switch (column) {
                case 0: {
                    return property.getKey();
                }
                case 1: {
                    return property.getValue();
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return columnClasses.length;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }

        public Property getProperty(int row) {
            return this.data.get(row);
        }
    }

    public static class Property {
        private String key;
        private Object value;

        public Property(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    private static class ValueTableCellRenderer
    extends DefaultTableCellRenderer {
        private ValueTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

