/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.jhylafax.JHylaFAX;

public class ArgsHandler {
    private LinkedList<String> args;
    private List<String> filenames = new ArrayList<String>();
    private String logConfigFilename = "logging-default.properties";
    private List<String> numbers = new ArrayList<String>();
    private boolean readStdin = false;
    private boolean quitAfterSending;

    private void error(String error) {
        System.err.println(error);
        System.exit(1);
    }

    public void evaluate(String[] args) {
        this.args = new LinkedList<String>(Arrays.asList(args));
        while (this.hasNext()) {
            String arg = this.pop();
            if (!arg.startsWith("-")) {
                this.filenames.add(arg);
                continue;
            }
            if ("-n".equals(arg)) {
                this.numbers.add(this.popArg("-n"));
                continue;
            }
            if ("-d".equals(arg)) {
                this.logConfigFilename = "logging-info.properties";
                continue;
            }
            if ("-dd".equals(arg)) {
                this.logConfigFilename = "logging-debug.properties";
                continue;
            }
            if ("--stdin".equals(arg)) {
                this.readStdin = true;
                continue;
            }
            if ("-q".equals(arg)) {
                this.quitAfterSending = true;
                continue;
            }
            if ("-h".equals(arg) | "-?".equals(arg) | "-help".equals(arg) | "--help".equals(arg)) {
                System.out.println("Usage: java -jar jhylafax.jar [options] [files]");
                System.out.println();
                System.out.println(" -d\t            Output debug information to stderr");
                System.out.println(" -dd            Output more debug information to stderr");
                System.out.println(" -h --help      Print this help message");
                System.out.println(" -n number      Send fax to number");
                System.out.println(" -q\t            Quit after sending fax");
                System.out.println(" --stdin        Read PostScript from stdin");
                System.exit(0);
                continue;
            }
            this.error(JHylaFAX.i18n.tr("Invalid parameter. Use -h for help."));
        }
    }

    public String[] getFilenames() {
        return this.filenames.toArray(new String[0]);
    }

    public String getLogConfigFilename() {
        return this.logConfigFilename;
    }

    public String[] getNumbers() {
        return this.numbers.toArray(new String[0]);
    }

    public boolean getReadStdin() {
        return this.readStdin;
    }

    public boolean getQuitAfterSending() {
        return this.quitAfterSending;
    }

    private boolean hasNext() {
        return !this.args.isEmpty();
    }

    private String pop() {
        return this.args.remove();
    }

    private String popArg(String parameter) {
        String arg;
        if (!this.hasNext()) {
            this.error(JHylaFAX.i18n.tr("{0} parameter requires argument", parameter));
        }
        if ((arg = this.pop()).startsWith("-")) {
            this.error(JHylaFAX.i18n.tr("{0} parameter requires argument", parameter));
        }
        return arg;
    }
}

