/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JHylaFAXHelper;
import net.sf.jhylafax.JobHelper;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.StateCellRenderer;
import net.sf.jhylafax.TimeCellRenderer;
import net.sf.jhylafax.fax.FaxJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.ColoredTable;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.table.FilesizeCellRenderer;
import org.xnap.commons.gui.table.StringCellRenderer;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.gui.table.TableSorter;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.PopupListener;
import org.xnap.commons.settings.SettingStore;
import org.xnap.commons.util.StringHelper;

public abstract class AbstractQueuePanel
extends JPanel
implements ListSelectionListener,
LocaleChangeListener {
    private static final Log logger = LogFactory.getLog(AbstractQueuePanel.class);
    private String[] defaultColumns;
    private String queueName;
    private ColoredTable queueTable;
    private TableLayout queueTableLayout;
    private ResetQueueTableAction resetQueueTableAction;
    private JPanel buttonPanel;
    private JPopupMenu tablePopupMenu;

    public AbstractQueuePanel(String queueName) {
        this.queueName = queueName;
        this.setLayout(new BorderLayout());
        this.setBorder(GUIHelper.createEmptyBorder(10));
        this.resetQueueTableAction = new ResetQueueTableAction();
        this.tablePopupMenu = new JPopupMenu();
        TableSorter sorter = new TableSorter(this.getTableModel());
        this.queueTable = new ColoredTable(sorter);
        this.queueTableLayout = new TableLayout(this.queueTable);
        this.initializeTableLayout();
        this.queueTableLayout.getHeaderPopupMenu().add(new JMenuItem(this.resetQueueTableAction));
        this.add((Component)new JScrollPane(this.queueTable), "Center");
        this.queueTable.setShowVerticalLines(true);
        this.queueTable.setShowHorizontalLines(false);
        this.queueTable.setAutoCreateColumnsFromModel(true);
        this.queueTable.setIntercellSpacing(new Dimension(2, 1));
        this.queueTable.setSelectionMode(0);
        this.queueTable.getSelectionModel().addListSelectionListener(this);
        this.queueTable.addMouseListener(new PopupListener(this.tablePopupMenu));
        this.queueTable.setDefaultRenderer(Long.class, new FilesizeCellRenderer());
        this.queueTable.setDefaultRenderer(String.class, new StringCellRenderer());
        this.queueTable.setDefaultRenderer(Date.class, new TimeCellRenderer());
        this.queueTable.setDefaultRenderer(FaxJob.State.class, new StateCellRenderer());
        this.buttonPanel = new JPanel(new FlowLayout());
        this.add((Component)this.buttonPanel, "South");
    }

    protected File createTempFile(String filename) {
        try {
            File tempFile = File.createTempFile("jhylafax", null);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            logger.debug("Error creating temporary file", e);
            JHylaFAX.getInstance().showError(JHylaFAX.i18n.tr("Error creating temporary file"), e);
            return null;
        }
    }

    public String getAbsolutePath(String filename) {
        return this.getQueueName() + "/" + filename;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public abstract JobHelper.FileStat getSelectedFile();

    protected abstract TableModel getTableModel();

    protected TableLayout getTableLayout() {
        return this.queueTableLayout;
    }

    protected JTable getTable() {
        return this.queueTable;
    }

    protected JPopupMenu getTablePopupMenu() {
        return this.tablePopupMenu;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected int getSelectedRow() {
        int row = this.queueTable.getSelectedRow();
        return row == -1 ? -1 : ((TableSorter)this.queueTable.getModel()).mapToIndex(row);
    }

    protected abstract void initializeTableLayout();

    public void restoreLayout(SettingStore store, String[] defaultColumns) {
        this.defaultColumns = defaultColumns;
        store.restoreTable(this.getQueueName(), defaultColumns, this.queueTableLayout);
    }

    public void saveLayout(SettingStore store) {
        store.saveTable(this.getQueueName(), this.queueTableLayout);
    }

    public abstract void updateActions();

    public void updateLabels() {
        this.resetQueueTableAction.putValue("Name", JHylaFAX.i18n.tr("Reset to Defaults"));
    }

    public void resetTable() {
        this.initializeTableLayout();
        this.getTableLayout().setColumnsVisible(this.defaultColumns);
        this.queueTable.getTableHeader().revalidate();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateActions();
    }

    protected class ViewAction
    extends AbstractXNapAction {
        public ViewAction() {
            this.putValue("XNapIcon", "viewmag.png");
        }

        public void actionPerformed(ActionEvent event) {
            File tempFile;
            JobHelper.FileStat selectedFile = AbstractQueuePanel.this.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            String viewerPath = JHylaFAXHelper.getViewerPath(AbstractQueuePanel.this.getQueueName());
            if (viewerPath != null && (tempFile = AbstractQueuePanel.this.createTempFile(selectedFile.filename)) != null && JobHelper.save(tempFile, AbstractQueuePanel.this.getAbsolutePath(selectedFile.filename), selectedFile.filesize)) {
                JHylaFAXHelper.view(viewerPath, new File[]{tempFile});
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("View"));
            this.putValue("LongDescription", JHylaFAX.i18n.tr("The selected file is opened in an external viewer."));
        }
    }

    protected class SaveAction
    extends AbstractXNapAction {
        public SaveAction() {
            this.putValue("XNapIcon", "filesaveas.png");
        }

        public void actionPerformed(ActionEvent e) {
            JobHelper.FileStat selectedFile = AbstractQueuePanel.this.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(StringHelper.lastToken(selectedFile.filename, "/")));
            if (chooser.showSaveDialog(JHylaFAX.getInstance()) == 0) {
                JobHelper.save(chooser.getSelectedFile(), AbstractQueuePanel.this.getAbsolutePath(selectedFile.filename), selectedFile.filesize);
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Save"));
        }
    }

    protected class ResetQueueTableAction
    extends AbstractXNapAction {
        public void actionPerformed(ActionEvent event) {
            AbstractQueuePanel.this.resetTable();
        }
    }

    protected class DeleteAction
    extends AbstractXNapAction {
        public DeleteAction() {
            this.putValue("XNapIcon", "editdelete.png");
        }

        public void actionPerformed(ActionEvent e) {
            JobHelper.FileStat selectedFile = AbstractQueuePanel.this.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            if (Dialogs.showConfirmDialog(JHylaFAX.getInstance(), JHylaFAX.i18n.tr("Do you really want to delete the file {0}?", selectedFile.filename), JHylaFAX.i18n.tr("Delete File"), 0, Settings.CONFIRM_DELETE) == 0) {
                JobHelper.delete(AbstractQueuePanel.this.getAbsolutePath(selectedFile.filename));
            }
        }

        public void updateLabels() {
            this.putValue("Name", JHylaFAX.i18n.tr("Delete"));
        }
    }
}

