/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jhylafax;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jhylafax.AbstractQueuePanel;
import net.sf.jhylafax.JHylaFAX;
import net.sf.jhylafax.JobDialog;
import net.sf.jhylafax.JobPanel;
import net.sf.jhylafax.LocaleChangeListener;
import net.sf.jhylafax.Settings;
import net.sf.jhylafax.addressbook.AbstractContactTransferHandler;
import net.sf.jhylafax.fax.FaxHelper;
import net.sf.jhylafax.fax.FaxJob;
import net.wimpi.pim.contact.facades.SimpleContact;
import net.wimpi.pim.contact.model.Contact;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.DefaultCompletionModel;
import org.xnap.commons.settings.CompletionSettingDirector;

public abstract class AbstractFaxDialog
extends DefaultDialog
implements LocaleChangeListener {
    private static final Log logger = LogFactory.getLog(AbstractQueuePanel.class);
    public static final int DEFAULT_COLUMNS = 20;
    private JobPanel jobPanel;
    private SpinnerDateModel dateModel;
    private FaxJob job;
    private JLabel dateLabel;
    private ParameterDialogAction parameterAction;
    private JRadioButton dateNowRadionButton;
    private JRadioButton dateLaterRadionButton;
    protected DefaultFormBuilder builder;
    private JTextField numberTextField;
    private JLabel numberLabel;
    private Completion numberCompletion;
    private DefaultCompletionModel numberCompletionModel;
    private AddressBookAction addressBookAction;

    public AbstractFaxDialog(JFrame owner) {
        super((Frame)owner, BUTTON_OKAY | BUTTON_CANCEL);
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, pref, 3dlu, min, min:grow", "");
        this.builder = new DefaultFormBuilder(layout);
        this.builder.setDefaultDialogBorder();
        this.setMainComponent(this.builder.getPanel());
        this.parameterAction = new ParameterDialogAction();
        this.getButtonPanel().add((Component)Builder.createButton(this.parameterAction), 0);
    }

    protected void addNumberTextField() {
        Box box = Box.createHorizontalBox();
        this.addressBookAction = new AddressBookAction();
        this.numberTextField = new JTextField();
        this.numberTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.numberTextField.getPreferredSize().height));
        this.numberTextField.setTransferHandler(new ContactTransferHandler());
        box.add(this.numberTextField);
        box.add(Box.createHorizontalStrut(4));
        box.add(Builder.createIconButton(this.addressBookAction));
        this.numberLabel = this.builder.append("", (Component)box, 4);
        this.builder.nextLine();
        this.numberCompletionModel = new DefaultCompletionModel();
        this.numberCompletion = Builder.addCompletion((JTextComponent)this.numberTextField, this.numberCompletionModel);
        new CompletionSettingDirector(Settings.backstore, "number").restore(this.numberCompletion);
    }

    protected void addDateControls() {
        this.dateNowRadionButton = new JRadioButton();
        this.dateNowRadionButton.setSelected(true);
        this.dateLabel = this.builder.append("", (Component)this.dateNowRadionButton);
        this.builder.nextLine();
        this.dateLaterRadionButton = new JRadioButton();
        this.dateModel = new SpinnerDateModel();
        final JSpinner dateSpinner = new JSpinner(this.dateModel);
        dateSpinner.setEnabled(false);
        this.dateLaterRadionButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                dateSpinner.setEnabled(AbstractFaxDialog.this.dateLaterRadionButton.isSelected());
            }
        });
        this.builder.append("", (Component)this.dateLaterRadionButton, (Component)dateSpinner);
        this.builder.nextLine();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dateNowRadionButton);
        buttonGroup.add(this.dateLaterRadionButton);
    }

    public boolean apply() {
        if (this.numberTextField != null) {
            if (this.numberTextField.getText().trim().length() == 0) {
                Dialogs.showError((Component)this, JHylaFAX.i18n.tr("Please enter a number"), JHylaFAX.i18n.tr("JHylaFAX Error"));
                this.numberTextField.requestFocus();
                return false;
            }
            this.getJob().setNumber(FaxHelper.extractNumber(this.numberTextField.getText().trim()));
            this.numberCompletionModel.insert(this.numberTextField.getText());
            new CompletionSettingDirector(Settings.backstore, "number").save(this.numberCompletion);
        }
        if (this.dateNowRadionButton != null) {
            this.job.setSendTime(this.dateNowRadionButton.isSelected() ? null : this.dateModel.getDate());
        }
        return true;
    }

    public FaxJob getJob() {
        return this.job;
    }

    public void updateLabels() {
        if (this.numberTextField != null) {
            this.numberLabel.setText(JHylaFAX.i18n.tr("Number"));
        }
        if (this.dateNowRadionButton != null) {
            this.dateLabel.setText(JHylaFAX.i18n.tr("Date"));
            this.dateNowRadionButton.setText(JHylaFAX.i18n.tr("Now"));
            this.dateLaterRadionButton.setText(JHylaFAX.i18n.tr("Later"));
        }
        this.parameterAction.updateLabels();
    }

    public void revert() {
        if (this.numberTextField != null) {
            this.numberTextField.setText(this.getJob().getNumber());
        }
        if (this.dateNowRadionButton != null) {
            if (this.getJob().getSendTime() == null) {
                this.dateNowRadionButton.setSelected(true);
            } else {
                this.dateLaterRadionButton.setSelected(true);
                this.dateModel.setValue(this.job.getSendTime());
            }
        }
    }

    public void setJob(FaxJob job) {
        this.job = job;
    }

    public void setNumber(String number) {
        if (this.numberTextField != null) {
            this.numberTextField.setText(number);
        }
    }

    private class ContactTransferHandler
    extends AbstractContactTransferHandler {
        private ContactTransferHandler() {
        }

        public void importData(Contact[] contacts) {
            SimpleContact contact = new SimpleContact(contacts[0]);
            AbstractFaxDialog.this.setNumber(contact.getFaxNumber());
        }
    }

    private class AddressBookAction
    extends AbstractXNapAction {
        public AddressBookAction() {
            this.putValue("XNapIcon", "contents.png");
        }

        public void actionPerformed(ActionEvent e) {
            JHylaFAX.getInstance().getAddressBook().setDoubleClickAction(new InsertNumberAction());
            JHylaFAX.getInstance().getAddressBook().setVisible(true);
        }
    }

    private class InsertNumberAction
    extends AbstractAction {
        private boolean visible = JHylaFAX.getInstance().getAddressBook().isVisible();

        public void actionPerformed(ActionEvent e) {
            SimpleContact[] contacts = JHylaFAX.getInstance().getAddressBook().getSelectedContacts();
            if (contacts.length > 0) {
                String receipient = this.add("", "", contacts[0].getFirstname());
                receipient = this.add(receipient, " ", contacts[0].getLastname());
                receipient = this.add(receipient, ", ", contacts[0].getCompany());
                receipient = receipient + " <" + contacts[0].getFaxNumber() + ">";
                AbstractFaxDialog.this.setNumber(receipient);
            }
            JHylaFAX.getInstance().getAddressBook().setDoubleClickAction(null);
            JHylaFAX.getInstance().getAddressBook().setVisible(false);
            AbstractFaxDialog.this.requestFocus();
        }

        public String add(String input, String glue, String token) {
            if (token != null) {
                return input + glue + token;
            }
            return input;
        }
    }

    private class ParameterDialogAction
    extends AbstractXNapAction
    implements LocaleChangeListener {
        private JobDialog dialog;

        public void actionPerformed(ActionEvent e) {
            if (AbstractFaxDialog.this.job == null) {
                return;
            }
            if (this.dialog == null) {
                this.dialog = new JobDialog(AbstractFaxDialog.this.job);
                this.dialog.setLocationRelativeTo(AbstractFaxDialog.this);
                this.dialog.setModal(true);
            }
            if (!this.dialog.isVisible()) {
                this.dialog.revert();
                this.dialog.getJobPanel().setSenderEditable(AbstractFaxDialog.this.getJob().getID() == -1);
                this.dialog.setVisible(true);
            }
        }

        public void updateLabels() {
            AbstractFaxDialog.this.parameterAction.putValue("Name", JHylaFAX.i18n.tr("Parameter..."));
            AbstractFaxDialog.this.parameterAction.putValue("ShortDescription", JHylaFAX.i18n.tr("Opens a dialog for entering job parameter"));
            if (this.dialog != null) {
                this.dialog.updateLabels();
            }
        }
    }
}

