/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.hylafax.logging.ConsoleLogger;
import gnu.hylafax.logging.Logger;
import gnu.hylafax.logging.LoggingFactory;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.ConnectionEventSource;
import gnu.inet.ftp.ConnectionListener;
import gnu.inet.ftp.TransferEventSource;
import gnu.inet.ftp.TransferListener;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Getter
extends Thread
implements ConnectionEventSource,
TransferEventSource {
    public static final int BUFFER_SIZE = 1024;
    private static final Logger log = LoggingFactory.getLogger(Getter.class);
    protected OutputStream ostream;
    protected boolean cancelled = false;
    protected Vector connectionListeners;
    protected Vector transferListeners;
    protected char mode;
    protected char type;

    public Getter() {
        this.setDebug(false);
        this.cancelled = false;
        this.connectionListeners = new Vector();
        this.transferListeners = new Vector();
        this.mode = (char)83;
        this.type = (char)73;
    }

    public synchronized void setOutputStream(OutputStream ostream) {
        this.ostream = ostream;
    }

    public synchronized void setMode(char mode) {
        this.mode = mode;
    }

    public synchronized void setType(char type) {
        this.type = type;
    }

    public void setDebug(boolean value) {
        if (log instanceof ConsoleLogger) {
            ConsoleLogger cl = (ConsoleLogger)log;
            cl.setDebugEnabled(value);
        }
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.interrupt();
        }
    }

    public synchronized void start() {
        this.cancelled = false;
        super.start();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.addElement(listener);
    }

    public void addConnectionListeners(Vector listeners) {
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)e.nextElement();
            this.connectionListeners.addElement(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.removeElement(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.transferListeners.addElement(listener);
    }

    public void addTransferListeners(Vector listeners) {
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            TransferListener listener = (TransferListener)e.nextElement();
            this.transferListeners.addElement(listener);
        }
    }

    public void removeTransferListener(TransferListener listener) {
        this.transferListeners.removeElement(listener);
    }

    protected void signalConnectionOpened(ConnectionEvent event) {
        Enumeration listeners = this.connectionListeners.elements();
        while (listeners.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)listeners.nextElement();
            listener.connectionOpened(event);
        }
    }

    protected void signalConnectionClosed(ConnectionEvent event) {
        Enumeration listeners = this.connectionListeners.elements();
        while (listeners.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)listeners.nextElement();
            listener.connectionClosed(event);
        }
    }

    protected void signalConnectionFailed(Exception exception) {
        Enumeration listeners = this.connectionListeners.elements();
        while (listeners.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)listeners.nextElement();
            listener.connectionFailed(exception);
        }
    }

    protected void signalTransferStarted() {
        Enumeration listeners = this.transferListeners.elements();
        while (listeners.hasMoreElements()) {
            TransferListener listener = (TransferListener)listeners.nextElement();
            listener.transferStarted();
        }
    }

    protected void signalTransferCompleted() {
        Enumeration listeners = this.transferListeners.elements();
        while (listeners.hasMoreElements()) {
            TransferListener listener = (TransferListener)listeners.nextElement();
            listener.transferCompleted();
        }
    }

    protected void signalTransfered(long amount) {
        Enumeration listeners = this.transferListeners.elements();
        while (listeners.hasMoreElements()) {
            TransferListener listener = (TransferListener)listeners.nextElement();
            listener.transfered(amount);
        }
    }
}

