/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.hylafax.logging.Logger;
import gnu.hylafax.logging.LoggingFactory;
import gnu.inet.ftp.ActiveGetter;
import gnu.inet.ftp.ActivePutter;
import gnu.inet.ftp.ConnectionEventSource;
import gnu.inet.ftp.ConnectionListener;
import gnu.inet.ftp.FtpClientProtocol;
import gnu.inet.ftp.Getter;
import gnu.inet.ftp.PassiveConnection;
import gnu.inet.ftp.PassiveGetter;
import gnu.inet.ftp.PassivePutter;
import gnu.inet.ftp.Putter;
import gnu.inet.ftp.ServerResponseException;
import gnu.inet.ftp.TransferEventSource;
import gnu.inet.ftp.TransferListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;

public class FtpClient
extends FtpClientProtocol
implements ConnectionEventSource,
TransferEventSource {
    private boolean passive = false;
    private static final Logger log = LoggingFactory.getLogger(FtpClient.class);
    private char mode = (char)83;
    private Vector connectionListeners;
    private Vector transferListeners = new Vector();
    protected PassiveConnection connection = null;

    public FtpClient() {
        this.connectionListeners = new Vector();
    }

    public synchronized void setPassive(boolean passive) {
        this.passive = passive;
    }

    public synchronized boolean getPassive() {
        return this.passive;
    }

    public synchronized void mode(char mode) throws IOException, ServerResponseException {
        super.mode(mode);
        this.mode = mode;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.addElement(listener);
    }

    public void addConnectionListeners(Vector listeners) {
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)e.nextElement();
            this.connectionListeners.addElement(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.removeElement(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.transferListeners.addElement(listener);
    }

    public void addTransferListeners(Vector listeners) {
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            TransferListener listener = (TransferListener)e.nextElement();
            this.transferListeners.addElement(listener);
        }
    }

    public void removeTransferListener(TransferListener listener) {
        this.transferListeners.removeElement(listener);
    }

    public synchronized String putTemporary(InputStream data) throws IOException, ServerResponseException {
        String filename;
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(data, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(data);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.setType(this.fileType);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            filename = this.stot(data);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        return filename;
    }

    public synchronized String put(InputStream in) throws IOException, ServerResponseException {
        String filename;
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(in, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(in);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.setType(this.fileType);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            filename = this.stou(in);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        return filename;
    }

    public synchronized void put(InputStream in, String pathname) throws IOException, ServerResponseException {
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(in, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(in);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.setType(this.fileType);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            this.stor(in, pathname);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
    }

    public synchronized Vector getList(String path) throws IOException, FileNotFoundException, ServerResponseException {
        Getter spot;
        Vector<String> filenames = new Vector<String>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            spot = new PassiveGetter(buffer, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(buffer);
            this.port(this.getInetAddress(), aget.getPort());
            spot = aget;
        }
        spot.setDebug(this.getDebug());
        spot.addConnectionListeners(this.connectionListeners);
        spot.addTransferListeners(this.transferListeners);
        spot.start();
        try {
            this.list(path);
        }
        catch (FileNotFoundException fnfe) {
            spot.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            spot.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            spot.cancel();
            throw sree;
        }
        finally {
            try {
                spot.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        BufferedReader data = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
        boolean done = false;
        while (!done) {
            String line = data.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            filenames.addElement(line);
        }
        return filenames;
    }

    public synchronized Vector getList() throws IOException, FileNotFoundException, ServerResponseException {
        return this.getList(null);
    }

    public synchronized Vector getNameList(String path) throws IOException, ServerResponseException, FileNotFoundException {
        Getter sparky;
        Vector<String> filenames = new Vector<String>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            sparky = new PassiveGetter(buffer, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(buffer);
            this.port(this.getInetAddress(), aget.getPort());
            sparky = aget;
        }
        sparky.setDebug(this.getDebug());
        sparky.addConnectionListeners(this.connectionListeners);
        sparky.addTransferListeners(this.transferListeners);
        sparky.start();
        try {
            this.nlst(path);
        }
        catch (FileNotFoundException fnfe) {
            sparky.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            sparky.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            sparky.cancel();
            throw sree;
        }
        catch (Exception e) {
            sparky.cancel();
            throw new ServerResponseException(e.getMessage());
        }
        finally {
            try {
                sparky.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        BufferedReader data = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
        boolean done = false;
        while (!done) {
            String line = data.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            filenames.addElement(line);
        }
        return filenames;
    }

    public synchronized Vector getNameList() throws IOException, ServerResponseException, FileNotFoundException {
        return this.getNameList(null);
    }

    public synchronized void get(String path, OutputStream out) throws IOException, FileNotFoundException, ServerResponseException {
        Getter get;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            get = new PassiveGetter(out, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(out);
            get = aget;
            this.port(this.getInetAddress(), aget.getPort());
        }
        get.setDebug(this.getDebug());
        get.setMode(this.mode);
        get.setType(this.fileType);
        get.addConnectionListeners(this.connectionListeners);
        get.addTransferListeners(this.transferListeners);
        get.start();
        try {
            this.retr(path);
        }
        catch (FileNotFoundException fnfe) {
            get.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            get.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            get.cancel();
            throw sree;
        }
        finally {
            try {
                get.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
    }

    public synchronized void rename(String source, String target) throws IOException, ServerResponseException, FileNotFoundException {
        this.rnfr(source);
        this.rnto(target);
    }

    public static void main(String[] Arguments) {
        BasicConfigurator.configure();
        FtpClient c = new FtpClient();
        try {
            int counter;
            int counter2;
            c.setDebug(true);
            c.open("localhost");
            c.noop();
            c.setPassive(true);
            c.user("jaiger");
            c.type('I');
            System.out.println("current directory is: " + c.pwd());
            c.cwd("docq");
            System.out.println("current directory is: " + c.pwd());
            c.cdup();
            System.out.println("current directory is: " + c.pwd());
            System.out.println("idle timer set to " + c.idle() + " seconds.");
            c.idle(1800L);
            System.out.println("idle timer set to " + c.idle() + " seconds.");
            c.stru('F');
            c.stru('T');
            c.stru('F');
            String filename = "test.ps";
            FileInputStream file = new FileInputStream(filename);
            String f = c.putTemporary(file);
            System.out.println("filename= " + f);
            long local_size = new RandomAccessFile(filename, "r").length();
            long remote_size = c.size(f);
            System.out.println(filename + " local size is " + local_size);
            System.out.println(f + " remote size is " + remote_size);
            FileOutputStream out_file = new FileOutputStream(filename + ".retr");
            c.get(f, out_file);
            local_size = new RandomAccessFile(filename + ".retr", "r").length();
            System.out.println(filename + ".retr size is " + local_size);
            FileOutputStream zip_file = new FileOutputStream(filename + ".gz");
            c.mode('Z');
            c.get(f, zip_file);
            local_size = new RandomAccessFile(filename + ".gz", "r").length();
            System.out.println(filename + ".gz size is " + local_size);
            c.mode('S');
            Vector files = c.getList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('Z');
            files = c.getList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('S');
            try {
                c.getList("/joey-joe-joe-jr.shabba-do");
                System.out.println("ERROR: file not found was expected");
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("GOOD: file not found, as expected");
            }
            files = c.getList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('Z');
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('S');
            files = c.getNameList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            String system = c.syst();
            System.out.println("system type: " + system + ".");
            c.noop();
            Vector status = c.stat();
            for (counter = 0; counter < status.size(); ++counter) {
                System.out.println(status.elementAt(counter));
            }
            status = c.stat("docq");
            for (counter = 0; counter < status.size(); ++counter) {
                System.out.println(status.elementAt(counter));
            }
            try {
                status = c.stat("joey-joe-joe-junior-shabba-do");
                for (counter = 0; counter < status.size(); ++counter) {
                    System.out.println(status.elementAt(counter));
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("GOOD: file not found.  this is what we expected");
            }
            c.noop();
            c.quit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        System.out.println("main: end");
    }
}

