/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.pool;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.hylafax.logging.Logger;
import gnu.hylafax.logging.LoggingFactory;
import gnu.hylafax.pool.ClientPool;
import gnu.hylafax.pool.ClientPoolException;
import gnu.hylafax.pool.PooledClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class HylaFAXPooledClient
extends HylaFAXClient
implements PooledClient,
Runnable {
    private static final Logger log = LoggingFactory.getLogger(HylaFAXPooledClient.class);
    private ClientPool clientPool;
    private boolean terminated = false;
    private Thread thread = new Thread(this);
    private boolean valid = true;
    private boolean working = true;
    private boolean forceReopen = false;
    private long lastNoop = -1L;
    private long lastReopen = -1L;

    public HylaFAXPooledClient(ClientPool clientPool) {
        this.clientPool = clientPool;
        this.start();
    }

    public void admin(String password) throws IOException, ServerResponseException {
        log.warn("Method ignored for pooled clients.");
    }

    public Job createJob() throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            return super.createJob();
        }
        return null;
    }

    public void delete(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.delete(job);
        }
    }

    public void destroy() throws ClientPoolException {
        try {
            super.quit();
            this.stop();
        }
        catch (Exception e) {
            throw new ClientPoolException(e.getMessage());
        }
    }

    public String filefmt() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.filefmt();
        }
        return null;
    }

    public void filefmt(String value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.filefmt(value);
        }
    }

    public void get(String path, OutputStream out) throws IOException, FileNotFoundException, ServerResponseException {
        if (this.valid && this.working) {
            super.get(path, out);
        }
    }

    public Job getJob(long id) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            return super.getJob(id);
        }
        return null;
    }

    public Vector getList() throws IOException, FileNotFoundException, ServerResponseException {
        if (this.valid && this.working) {
            return super.getList();
        }
        return null;
    }

    public Vector getList(String path) throws IOException, FileNotFoundException, ServerResponseException {
        if (this.valid && this.working) {
            return super.getList(path);
        }
        return null;
    }

    public Vector getNameList() throws IOException, ServerResponseException, FileNotFoundException {
        if (this.valid && this.working) {
            return super.getNameList();
        }
        return null;
    }

    public Vector getNameList(String path) throws IOException, ServerResponseException, FileNotFoundException {
        if (this.valid && this.working) {
            return super.getNameList(path);
        }
        return null;
    }

    public boolean getPassive() {
        if (this.valid && this.working) {
            return super.getPassive();
        }
        return false;
    }

    public long idle() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.idle();
        }
        return -1L;
    }

    public void idle(long timeout) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.idle(timeout);
        }
    }

    public void interrupt(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.interrupt(job);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void jdele(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jdele(jobid);
        }
    }

    public void jintr(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jintr(jobid);
        }
    }

    public void jkill(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jkill(jobid);
        }
    }

    public void jnew() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jnew();
        }
    }

    public long job() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.job();
        }
        return -1L;
    }

    public void job(long value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.job(value);
        }
    }

    public String jobfmt() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.jobfmt();
        }
        return null;
    }

    public void jobfmt(String value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jobfmt(value);
        }
    }

    public String jparm(String parm) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.jparm(parm);
        }
        return null;
    }

    public void jparm(String parm, int value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jparm(parm, value);
        }
    }

    public void jparm(String parm, long value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jparm(parm, value);
        }
    }

    public void jparm(String parm, Object value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jparm(parm, value);
        }
    }

    public void jparm(String parm, String value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jparm(parm, value);
        }
    }

    public void jrest() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jrest();
        }
    }

    public long jsubm() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.jsubm();
        }
        return -1L;
    }

    public int jsubm(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.jsubm(jobid);
        }
        return -1;
    }

    public void jsusp(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jsusp(jobid);
        }
    }

    public void jwait(long jobid) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.jwait(jobid);
        }
    }

    public void kill(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.kill(job);
        }
    }

    public String mdmfmt() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.mdmfmt();
        }
        return null;
    }

    public void mdmfmt(String value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.mdmfmt(value);
        }
    }

    public void mode(char mode) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.mode(mode);
        }
    }

    public void noop() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.noop();
        }
    }

    public void open() throws UnknownHostException, IOException, ServerResponseException {
        log.warn("Method open() ignored for pooled clients.");
    }

    public void open(String host) throws UnknownHostException, IOException, ServerResponseException {
        log.warn("Method open(String host) ignored for pooled clients.");
    }

    public void open(String host, int port) throws UnknownHostException, IOException, ServerResponseException {
        log.warn("Method open(String host, int port) ignored for pooled clients.");
    }

    public void pass(String password) throws IOException, ServerResponseException {
        log.warn("Method pass(String password) ignored for pooled clients.");
    }

    void poolAdmin(String password) throws IOException, ServerResponseException {
        super.admin(password);
    }

    void poolOpen() throws UnknownHostException, IOException, ServerResponseException {
        super.open();
    }

    void poolOpen(String host) throws UnknownHostException, IOException, ServerResponseException {
        super.open(host);
    }

    void poolOpen(String host, int port) throws UnknownHostException, IOException, ServerResponseException {
        super.open(host, port);
    }

    void poolPass(String password) throws IOException, ServerResponseException {
        super.pass(password);
    }

    void poolTzone(String value) throws IOException, ServerResponseException {
        super.tzone(value);
    }

    boolean poolUser(String username) throws IOException, ServerResponseException {
        return super.user(username);
    }

    public String put(InputStream in) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.put(in);
        }
        return null;
    }

    public void put(InputStream in, String pathname) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.put(in, pathname);
        }
    }

    public String putTemporary(InputStream data) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.putTemporary(data);
        }
        return null;
    }

    public void quit() throws IOException, ServerResponseException {
        try {
            this.forceReopen = true;
            this.clientPool.put(this);
        }
        catch (ClientPoolException e) {
            log.error(e);
        }
    }

    public String rcvfmt() throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.rcvfmt();
        }
        return null;
    }

    public void rcvfmt(String value) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            super.rcvfmt(value);
        }
    }

    private void reopen() throws ClientPoolException {
        try {
            log.debug("Attempting to reopen client.");
            this.forceReopen = false;
            super.quit();
            this.clientPool.openClient(this);
            log.debug("Reopen successful.");
        }
        catch (Exception e) {
            throw new ClientPoolException(e.getMessage());
        }
    }

    public void run() {
        Thread.currentThread().setName("Pooled Client");
        while (!this.terminated) {
            try {
                if (!this.working) {
                    long time = System.currentTimeMillis();
                    if (this.forceReopen || time - this.lastReopen >= this.clientPool.getConfiguration().getMaxIdleTime()) {
                        this.reopen();
                        this.lastReopen = System.currentTimeMillis();
                    } else if (time - this.lastNoop >= this.clientPool.getConfiguration().getMaxNoopTime()) {
                        super.noop();
                        this.lastNoop = System.currentTimeMillis();
                    }
                }
                Thread.sleep(1000L);
                if (!this.clientPool.isStopped()) continue;
                this.terminated = true;
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                this.valid = false;
                this.forceReopen = true;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setDebug(boolean value) {
        if (this.valid && this.working) {
            super.setDebug(value);
        }
    }

    public void setPassive(boolean passive) {
        if (this.valid && this.working) {
            super.setPassive(passive);
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    void setWorking(boolean working) {
        this.working = working;
    }

    public long size(String pathname) throws IOException, FileNotFoundException, ServerResponseException {
        if (this.valid && this.working) {
            return super.size(pathname);
        }
        return -1L;
    }

    public void start() {
        this.terminated = false;
        this.lastNoop = this.lastReopen = System.currentTimeMillis();
        this.thread.start();
    }

    public void stop() {
        this.terminated = true;
    }

    public String stot(InputStream data) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.stot(data);
        }
        return null;
    }

    public void submit(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.submit(job);
        }
    }

    public void suspend(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.suspend(job);
        }
    }

    public void tzone(String value) throws IOException, ServerResponseException {
        log.warn("Method tzone(String value) ignored for pooled clients.");
    }

    public boolean user(String username) throws IOException, ServerResponseException {
        log.warn("Method user(String username) ignored for pooled clients.");
        return false;
    }

    public InetAddress vrfy(String dialstring) throws IOException, ServerResponseException {
        if (this.valid && this.working) {
            return super.vrfy(dialstring);
        }
        return null;
    }

    public void wait(Job job) throws ServerResponseException, IOException {
        if (this.valid && this.working) {
            super.wait(job);
        }
    }
}

