/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.pool;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import gnu.hylafax.logging.Logger;
import gnu.hylafax.logging.LoggingFactory;
import gnu.hylafax.pool.ClientPoolConfiguration;
import gnu.hylafax.pool.ClientPoolException;
import gnu.hylafax.pool.HylaFAXPooledClient;
import gnu.hylafax.pool.PooledClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ClientPool {
    private static final Logger log = LoggingFactory.getLogger(ClientPool.class);
    private boolean blocked = false;
    private boolean stopped = false;
    private HashMap clientMap;
    private LinkedQueue clients;
    private ClientPoolConfiguration configuration;
    private ArrayList creationTimes;
    private boolean logClientCreationTimes = true;
    private Object mutex = new Object();
    private int size = 0;
    private int totalSize = 0;
    private HashSet workingClients;
    private HashSet workingClientsToClose;
    private int workingSize = 0;

    public ClientPool(ClientPoolConfiguration configuration) {
        this.configuration = configuration;
        this.clients = new LinkedQueue();
        this.clientMap = new HashMap();
        this.workingClients = new HashSet();
        this.workingClientsToClose = new HashSet();
        this.creationTimes = new ArrayList();
    }

    private synchronized boolean addClient() throws InterruptedException, ClientPoolException {
        boolean maximumCapacityReached;
        log.debug("Trying To Create Client, Total Connections: " + this.totalSize + ", Max Allowed: " + this.getConfiguration().getMaxPoolSize());
        boolean bl = maximumCapacityReached = this.getConfiguration().getMaxPoolSize() <= this.totalSize && this.getConfiguration().getMaxPoolSize() != 0 && this.getConfiguration().isPooling();
        if (maximumCapacityReached) {
            log.debug("Maximum Clients Reached.");
            return false;
        }
        PooledClient client = this.createClient();
        log.debug("Client Created.");
        this.put(client);
        this.clientMap.put(client, client);
        ++this.totalSize;
        return true;
    }

    private PooledClient createClient() throws ClientPoolException {
        return this.openClient(new HylaFAXPooledClient(this));
    }

    private void destroyClient(PooledClient client) throws ClientPoolException {
        try {
            client.destroy();
            --this.totalSize;
            this.workingClients.remove(client);
            this.clientMap.remove(client);
        }
        catch (Exception e) {
            throw new ClientPoolException("Could Not Destroy Client: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledClient get() throws ClientPoolException {
        long startTime = System.currentTimeMillis();
        log.debug("Wants A Client.");
        PooledClient client = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (this.clients.isEmpty()) {
                    while (client == null) {
                        if (!this.keepBlocking(startTime)) {
                            ClientPoolException e = new ClientPoolException("Could Not Obtain Client During Blocking Timeout (" + this.getConfiguration().getBlockingTimeout() + " ms)");
                            throw e;
                        }
                        boolean clientAdded = false;
                        try {
                            clientAdded = this.addClient();
                        }
                        catch (ClientPoolException e) {
                            log.warn("Could Not Create Connection: " + e.getMessage());
                        }
                        if (!clientAdded) {
                            log.warn("Pool Is Empty And Will Block Here.");
                            this.blocked = true;
                        }
                        if ((client = (PooledClient)this.clients.poll(this.getConfiguration().getRetryInterval())) == null) {
                            log.warn("No Clients Available.");
                            continue;
                        }
                        if (client == null || clientAdded) continue;
                        log.info("Obtained Connection.");
                    }
                } else {
                    client = (PooledClient)this.clients.take();
                }
            }
        }
        catch (InterruptedException e) {
            throw new ClientPoolException("Interrupted Thread and No Free Connection Available.");
        }
        --this.size;
        ((HylaFAXPooledClient)client).setWorking(true);
        this.workingClients.add(client);
        log.debug("Got Client.");
        return client;
    }

    public long getAverageClientCreationTime() {
        if (this.creationTimes.size() > 0) {
            long average = 0L;
            for (int count = 0; count < this.creationTimes.size(); ++count) {
                average += ((Long)this.creationTimes.get(count)).longValue();
            }
            return average / (long)this.creationTimes.size();
        }
        return -1L;
    }

    public HashMap getClientMap() {
        return this.clientMap;
    }

    public ClientPoolConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getWorkingSize() {
        return this.workingSize;
    }

    public boolean isLogClientCreationTimes() {
        return this.logClientCreationTimes;
    }

    public boolean keepBlocking(long startTime) {
        return System.currentTimeMillis() - startTime < this.getConfiguration().getBlockingTimeout();
    }

    PooledClient openClient(HylaFAXPooledClient client) throws ClientPoolException {
        try {
            long startTime = System.currentTimeMillis();
            ClientPoolConfiguration config = this.getConfiguration();
            if (config.getHost() != null && config.getPort() != -1) {
                client.poolOpen(config.getHost(), config.getPort());
            } else if (config.getHost() != null) {
                client.poolOpen(config.getHost());
            } else {
                client.poolOpen();
            }
            if (config.getUserName() != null) {
                client.poolUser(config.getUserName());
            }
            if (config.getPassword() != null) {
                client.poolPass(config.getPassword());
            }
            if (config.getAdminPassword() != null) {
                client.poolAdmin(config.getAdminPassword());
            }
            if (config.getTimeZone() != null) {
                client.poolTzone(config.getTimeZone());
            }
            if (this.isLogClientCreationTimes()) {
                this.creationTimes.add(new Long(System.currentTimeMillis() - startTime));
            }
            client.setPassive(true);
            return client;
        }
        catch (Exception e) {
            throw new ClientPoolException(e.getMessage());
        }
    }

    public void put(PooledClient client) throws ClientPoolException {
        try {
            if (!client.isValid()) {
                this.workingClientsToClose.add(client);
            }
            ((HylaFAXPooledClient)client).setWorking(false);
            if (this.blocked) {
                log.warn("Will Be Unblocked");
            }
            if (this.getConfiguration().isPooling()) {
                if (this.workingClientsToClose.remove(client)) {
                    this.destroyClient(client);
                    this.addClient();
                } else {
                    this.clients.put((Object)client);
                    ++this.size;
                }
            }
            this.blocked = false;
            this.workingClients.remove(client);
            if (!this.getConfiguration().isPooling()) {
                this.destroyClient(client);
            }
            log.debug("Released Client.");
        }
        catch (InterruptedException e) {
            log.warn("Was Interrupted.", e);
            this.destroyClient(client);
        }
    }

    public void restart() {
        this.workingClientsToClose.addAll(this.workingClients);
        while (this.getSize() > 0) {
            try {
                PooledClient client = this.get();
                this.destroyClient(client);
            }
            catch (ClientPoolException e) {
                log.warn("Could Not Close Connection.", e);
            }
        }
        while (this.getTotalSize() < this.getConfiguration().getMinPoolSize()) {
            try {
                this.addClient();
            }
            catch (Exception e) {
                log.warn("Could Not Add Connection.", e);
            }
        }
    }

    public void setClientMap(HashMap clientMap) {
        this.clientMap = clientMap;
    }

    public void setConfiguration(ClientPoolConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setLogClientCreationTimes(boolean logClientCreationTimes) {
        this.logClientCreationTimes = logClientCreationTimes;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setWorkingSize(int workingSize) {
        this.workingSize = workingSize;
    }

    public void start() throws ClientPoolException {
        this.stopped = false;
        for (int i = 0; i < this.getConfiguration().getMinPoolSize(); ++i) {
            try {
                this.addClient();
                continue;
            }
            catch (InterruptedException e) {
                throw new ClientPoolException("Could Not Start Client Pool.");
            }
        }
    }

    public void stop() {
        PooledClient item;
        this.stopped = true;
        Iterator iter = this.workingClients.iterator();
        while (iter.hasNext()) {
            try {
                item = (PooledClient)iter.next();
                this.destroyClient(item);
            }
            catch (ClientPoolException e) {
                log.warn("Could Not Close Connection.", e);
            }
        }
        while (this.getSize() > 0) {
            try {
                item = this.get();
                this.destroyClient(item);
            }
            catch (ClientPoolException e) {
                log.warn("Could Not Close Connection.", e);
            }
        }
        this.totalSize = 0;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

