/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.logging;

import gnu.hylafax.logging.ConsoleLogger;
import gnu.hylafax.logging.Log4jLogger;
import gnu.hylafax.logging.Logger;

public class LoggingFactory {
    private static boolean log4jFound = false;
    private static boolean loggerChecked = false;
    private static boolean forceConsole = false;

    public static Logger getLogger(Class logClass) {
        if (!loggerChecked) {
            try {
                Class<?> verify = Class.forName("org.apache.log4j.Logger");
                log4jFound = true;
            }
            catch (ClassNotFoundException e) {
                log4jFound = false;
            }
            loggerChecked = true;
        }
        if (log4jFound && !forceConsole) {
            return new Log4jLogger(logClass);
        }
        return new ConsoleLogger(logClass);
    }

    public static Logger getLogger(String logClass) {
        try {
            return LoggingFactory.getLogger(Class.forName(logClass));
        }
        catch (Exception e) {
            return null;
        }
    }
}

