/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.logging;

import gnu.hylafax.logging.Logger;
import org.apache.log4j.Level;

public class Log4jLogger
implements Logger {
    private org.apache.log4j.Logger logger = null;

    protected Log4jLogger(Class logClass) {
        if (this.logger == null) {
            this.init(logClass);
        }
    }

    protected Log4jLogger(String logClassName) throws ClassNotFoundException {
        if (this.logger == null) {
            this.init(Class.forName(logClassName));
        }
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            if (t != null) {
                this.logger.debug(message, t);
            } else {
                this.logger.debug(message);
            }
        }
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            if (t != null) {
                this.logger.error(message, t);
            } else {
                this.logger.error(message);
            }
        }
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            if (t != null) {
                this.logger.fatal(message, t);
            } else {
                this.logger.fatal(message);
            }
        }
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            if (t != null) {
                this.logger.info(message, t);
            } else {
                this.logger.info(message);
            }
        }
    }

    private void init(Class logClass) {
        try {
            this.logger = org.apache.log4j.Logger.getLogger(logClass);
        }
        catch (Throwable t) {
            this.logger = null;
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    private boolean isEnabledFor(Level level) {
        return this.logger != null && this.logger.isEnabledFor(level);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(Level.WARN);
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            if (t != null) {
                this.logger.warn(message, t);
            } else {
                this.logger.warn(message);
            }
        }
    }
}

