/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.logging;

import gnu.hylafax.logging.Logger;
import java.io.OutputStream;
import java.io.PrintStream;

public class ConsoleLogger
implements Logger {
    public static final String DEBUG_TYPE = "DEBUG";
    public static final String ERROR_TYPE = "ERROR";
    public static final String FATAL_TYPE = "FATAL";
    public static final String INFO_TYPE = "INFO";
    private static PrintStream out = System.out;
    public static final String WARN_TYPE = "WARN";
    private String className;
    private boolean debugEnabled = false;
    private boolean errorEnabled = true;
    private boolean fatalEnabled = true;
    private boolean infoEnabled = true;
    private boolean warnEnabled = true;

    public ConsoleLogger(Class logClass) {
        this.className = logClass.getName();
    }

    public ConsoleLogger(String className) {
        this.className = className;
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(DEBUG_TYPE, message, t);
        }
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(ERROR_TYPE, message, t);
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(FATAL_TYPE, message, t);
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(INFO_TYPE, message, t);
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public boolean isFatalEnabled() {
        return this.fatalEnabled;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String type, Object message, Throwable t) {
        PrintStream printStream = out;
        synchronized (printStream) {
            out.println(type + " " + this.className + " - " + message);
            if (t != null) {
                t.printStackTrace(out);
            }
        }
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void setErrorEnabled(boolean errorEnabled) {
        this.errorEnabled = errorEnabled;
    }

    public void setFatalEnabled(boolean fatalEnabled) {
        this.fatalEnabled = fatalEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    public void setOutputStream(OutputStream out) {
        ConsoleLogger.out = new PrintStream(out);
    }

    public void setWarnEnabled(boolean warnEnabled) {
        this.warnEnabled = warnEnabled;
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(WARN_TYPE, message, t);
    }
}

