/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax;

import gnu.hylafax.Client;
import gnu.hylafax.HylaFAXClientProtocol;
import gnu.hylafax.Job;
import gnu.hylafax.logging.Logger;
import gnu.hylafax.logging.LoggingFactory;
import gnu.inet.ftp.ActiveGetter;
import gnu.inet.ftp.ActivePutter;
import gnu.inet.ftp.ConnectionEventSource;
import gnu.inet.ftp.ConnectionListener;
import gnu.inet.ftp.Getter;
import gnu.inet.ftp.PassiveConnection;
import gnu.inet.ftp.PassiveGetter;
import gnu.inet.ftp.PassivePutter;
import gnu.inet.ftp.Putter;
import gnu.inet.ftp.ServerResponseException;
import gnu.inet.ftp.TransferEventSource;
import gnu.inet.ftp.TransferListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class HylaFAXClient
extends HylaFAXClientProtocol
implements Client,
ConnectionEventSource,
TransferEventSource {
    private static final Logger log = LoggingFactory.getLogger(Client.class);
    private boolean passive = false;
    private char mode = (char)83;
    private Vector connectionListeners = new Vector();
    private Vector transferListeners = new Vector();
    protected PassiveConnection connection = null;

    public synchronized void setPassive(boolean passive) {
        this.passive = passive;
    }

    public synchronized boolean getPassive() {
        return this.passive;
    }

    public synchronized void mode(char mode) throws IOException, ServerResponseException {
        super.mode(mode);
        this.mode = mode;
    }

    public synchronized String putTemporary(InputStream data) throws IOException, ServerResponseException {
        String filename;
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(data, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(data);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            filename = this.stot(data);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        return filename;
    }

    public synchronized String put(InputStream in) throws IOException, ServerResponseException {
        String filename;
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(in, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(in);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            filename = this.stou(in);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        return filename;
    }

    public synchronized void put(InputStream in, String pathname) throws IOException, ServerResponseException {
        Putter put;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            put = new PassivePutter(in, this.connection);
        } else {
            ActivePutter aput = new ActivePutter(in);
            put = aput;
            this.port(this.getInetAddress(), aput.getPort());
        }
        put.setDebug(this.getDebug());
        put.setMode(this.mode);
        put.addConnectionListeners(this.connectionListeners);
        put.addTransferListeners(this.transferListeners);
        put.start();
        try {
            this.stor(in, pathname);
        }
        catch (IOException ioe) {
            put.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            put.cancel();
            throw sree;
        }
        finally {
            try {
                put.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
    }

    public synchronized Vector getList(String path) throws IOException, FileNotFoundException, ServerResponseException {
        Getter spot;
        Vector<String> filenames = new Vector<String>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            spot = new PassiveGetter(buffer, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(buffer);
            this.port(this.getInetAddress(), aget.getPort());
            spot = aget;
        }
        spot.setDebug(this.getDebug());
        spot.addConnectionListeners(this.connectionListeners);
        spot.addTransferListeners(this.transferListeners);
        spot.start();
        try {
            this.list(path);
        }
        catch (FileNotFoundException fnfe) {
            spot.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            spot.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            spot.cancel();
            throw sree;
        }
        finally {
            try {
                spot.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        BufferedReader data = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
        boolean done = false;
        while (!done) {
            String line = data.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            filenames.addElement(line);
        }
        return filenames;
    }

    public synchronized Vector getList() throws IOException, FileNotFoundException, ServerResponseException {
        return this.getList(null);
    }

    public synchronized Vector getNameList(String path) throws IOException, ServerResponseException, FileNotFoundException {
        Getter sparky;
        Vector<String> filenames = new Vector<String>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            sparky = new PassiveGetter(buffer, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(buffer);
            this.port(this.getInetAddress(), aget.getPort());
            sparky = aget;
        }
        sparky.setDebug(this.getDebug());
        sparky.addConnectionListeners(this.connectionListeners);
        sparky.addTransferListeners(this.transferListeners);
        sparky.start();
        try {
            this.nlst(path);
        }
        catch (FileNotFoundException fnfe) {
            sparky.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            sparky.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            sparky.cancel();
            throw sree;
        }
        finally {
            try {
                sparky.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
        BufferedReader data = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
        boolean done = false;
        while (!done) {
            String line = data.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            filenames.addElement(line);
        }
        return filenames;
    }

    public synchronized Vector getNameList() throws IOException, ServerResponseException, FileNotFoundException {
        return this.getNameList(null);
    }

    public synchronized void get(String path, OutputStream out) throws IOException, FileNotFoundException, ServerResponseException {
        Getter get;
        if (this.passive) {
            if (this.connection == null) {
                this.connection = new PassiveConnection(this.pasv());
            }
            get = new PassiveGetter(out, this.connection);
        } else {
            ActiveGetter aget = new ActiveGetter(out);
            get = aget;
            this.port(this.getInetAddress(), aget.getPort());
        }
        get.setDebug(this.getDebug());
        get.setMode(this.mode);
        get.addConnectionListeners(this.connectionListeners);
        get.addTransferListeners(this.transferListeners);
        get.start();
        try {
            this.retr(path);
        }
        catch (FileNotFoundException fnfe) {
            get.cancel();
            throw fnfe;
        }
        catch (IOException ioe) {
            get.cancel();
            throw ioe;
        }
        catch (ServerResponseException sree) {
            get.cancel();
            throw sree;
        }
        finally {
            try {
                get.join();
            }
            catch (InterruptedException ie) {}
        }
        this.connection = null;
    }

    public Job createJob() throws ServerResponseException, IOException {
        return new gnu.hylafax.job.Job(this);
    }

    public Job getJob(long id) throws ServerResponseException, IOException {
        return new gnu.hylafax.job.Job(this, id);
    }

    public void submit(Job job) throws ServerResponseException, IOException {
        this.jsubm(job.getId());
    }

    public void delete(Job job) throws ServerResponseException, IOException {
        this.jdele(job.getId());
    }

    public void suspend(Job job) throws ServerResponseException, IOException {
        this.jsusp(job.getId());
    }

    public void wait(Job job) throws ServerResponseException, IOException {
        this.jwait(job.getId());
    }

    public void kill(Job job) throws ServerResponseException, IOException {
        this.jkill(job.getId());
    }

    public void interrupt(Job job) throws ServerResponseException, IOException {
        this.jintr(job.getId());
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.addElement(listener);
    }

    public void addConnectionListeners(Vector listeners) {
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionListener listener = (ConnectionListener)enumeration.nextElement();
            this.connectionListeners.addElement(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.removeElement(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.transferListeners.addElement(listener);
    }

    public void addTransferListeners(Vector listeners) {
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            TransferListener listener = (TransferListener)enumeration.nextElement();
            this.transferListeners.addElement(listener);
        }
    }

    public void removeTransferListener(TransferListener listener) {
        this.transferListeners.removeElement(listener);
    }
}

