/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.ColoredTable;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.gui.table.TableSorter;
import org.xnap.commons.settings.PropertyResource;
import org.xnap.commons.settings.TableSettingDirector;

public class TableExample
extends JFrame {
    PropertyResource settingsStore = new PropertyResource();
    TableSettingDirector director = new TableSettingDirector(this.settingsStore, "table");
    TableLayout layout;
    static /* synthetic */ Class class$0;

    public TableExample() {
        JTabbedPane pane = new JTabbedPane();
        MyTableModel model = new MyTableModel();
        TableSorter sorter = new TableSorter(model);
        ColoredTable table = new ColoredTable(sorter);
        this.layout = new TableLayout(table);
        pane.addTab("Sortable Table", new JScrollPane(table));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(Builder.createButton(new SaveAction()));
        buttonPanel.add(Builder.createButton(new RestoreAction()));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public static void main(String[] args) {
        TableExample app = new TableExample();
        app.setTitle("XNap-Commons - " + TableExample.class);
        app.setDefaultCloseOperation(3);
        app.pack();
        app.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTableModel
    extends AbstractTableModel {
        private static final Object[][] data = new Object[][]{{"StatCvs-XML", "0.9.6", MyTableModel.createDate(2004, 10, 23), new Integer(8500)}, {"XNap", "3.0-rc1", MyTableModel.createDate(2003, 10, 5), new Integer(60000)}, {"XNap-Commons", "1.0", MyTableModel.createDate(2005, 2, 5), new Integer(3500)}};
        private static final String[] columnNames = new String[]{"Project", "Version", "Release Date", "Lines of Code"};
        private static final Class[] columnClasses = new Class[]{String.class, String.class, Date.class, Integer.class};
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        private static Date createDate(int year, int month, int day) {
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day);
            return cal.getTime();
        }

        public MyTableModel() {
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int aRow, int aColumn) {
            return data[aRow][aColumn];
        }

        @Override
        public int getRowCount() {
            return data.length;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return columnClasses[column];
        }
    }

    private class SaveAction
    extends AbstractXNapAction {
        public SaveAction() {
            this.putValue("Name", "Save");
        }

        public void actionPerformed(ActionEvent e) {
            TableExample.this.director.save(TableExample.this.layout);
        }
    }

    private class RestoreAction
    extends AbstractXNapAction {
        public RestoreAction() {
            this.putValue("Name", "Restore");
        }

        public void actionPerformed(ActionEvent e) {
            TableExample.this.director.restore(TableExample.this.layout);
        }
    }
}

