/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.Dialogs;
import org.xnap.commons.gui.DirectoryChooser;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.WhatsThis;
import org.xnap.commons.gui.wizard.DefaultWizardPage;
import org.xnap.commons.gui.wizard.WizardDialog;
import org.xnap.commons.i18n.I18nManager;

public class DialogsExample
extends JFrame {
    static /* synthetic */ Class class$0;

    public DialogsExample() {
        this.setTitle("XNap Commons Dialog Example");
        JPanel contentPanel = new JPanel(new GridLayout(0, 1));
        contentPanel.setBorder(GUIHelper.createEmptyBorder(10));
        this.setContentPane(contentPanel);
        JLabel label = new JLabel("Click a button below to show a dialog:");
        this.getContentPane().add(label);
        this.createOptionPaneDialogs();
        this.createFileDialogs();
        this.createDefaultDialogs();
        this.createChooserDialogs();
        this.createWizardDialogs();
    }

    private void createOptionPaneDialogs() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add(buttonPanel);
        JButton button = new JButton("Information");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showInfo(DialogsExample.this, "Provided by Dialogs.showInfo().", "XNap Commons");
            }
        });
        buttonPanel.add(button);
        button = new JButton("Error");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showError((Component)DialogsExample.this, "Provided by Dialogs.showError().", "XNap Commons");
            }
        });
        buttonPanel.add(button);
        button = new JButton("Input");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.requestInput(DialogsExample.this, "Provided by Dialogs.requestInput().", "XNap Commons");
            }
        });
        buttonPanel.add(button);
        button = new JButton("Confirmation");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showConfirmDialog(DialogsExample.this, "Provided by Dialogs.showConfirmDialog().", "XNap Commons", 0, null);
            }
        });
        buttonPanel.add(button);
    }

    private void createFileDialogs() {
        final File[] files = new File[]{new File("File1.txt"), new File("File2.txt"), new File("File3.txt"), new File("File4.txt"), new File("File5.txt"), new File("File6.txt")};
        final File target = new File(System.getProperty("java.io.tmpdir"));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add(buttonPanel);
        JButton button = new JButton("Copy Files");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showCopyDialog(DialogsExample.this, files, target, null);
            }
        });
        buttonPanel.add(button);
        button = new JButton("Move Files");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showMoveDialog(DialogsExample.this, files, target, null);
            }
        });
        buttonPanel.add(button);
        button = new JButton("Delete Files");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showDeleteDialog(DialogsExample.this, files, null);
            }
        });
        buttonPanel.add(button);
    }

    private void createDefaultDialogs() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add(buttonPanel);
        JButton button = new JButton("Default Dialog 1");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultDialog dialog = new DefaultDialog((Frame)DialogsExample.this, DefaultDialog.BUTTON_OKAY | DefaultDialog.BUTTON_APPLY | DefaultDialog.BUTTON_CANCEL | DefaultDialog.BUTTON_CONTEXT_HELP);
                JLabel label = new JLabel("Provided by DefaultDialog class.", 0);
                WhatsThis.setText((JComponent)dialog.getButtonPanel().getComponent(0), "Okay Button Context Help Message.");
                dialog.getMainPanel().add(label);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(button);
        button = new JButton("Default Dialog 2");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultDialog dialog = new DefaultDialog(DefaultDialog.BUTTON_APPLY | DefaultDialog.BUTTON_CANCEL | DefaultDialog.BUTTON_CLOSE | DefaultDialog.BUTTON_CLOSE | DefaultDialog.BUTTON_CONTEXT_HELP | DefaultDialog.BUTTON_HELP | DefaultDialog.BUTTON_OKAY);
                JLabel label = new JLabel("Provided by DefaultDialog class: Displaying all buttons.", 0);
                dialog.getMainPanel().add(label);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(button);
        button = new JButton("Exception");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    throw new Exception("Sample Exception");
                }
                catch (Exception e) {
                    Dialogs.showError(DialogsExample.this, "Provided by Dialogs.showError().", "XNap Commons", e);
                    return;
                }
            }
        });
        buttonPanel.add(button);
    }

    private void createChooserDialogs() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add(buttonPanel);
        JButton button = new JButton("Folder Chooser");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser dialog = new DirectoryChooser();
                dialog.setTitle("Choose Folder");
                if (dialog.showChooseDialog(DialogsExample.this) == 1) {
                    Dialogs.showInfo(DialogsExample.this, "Selected: " + dialog.getSelectedDirectory().getAbsolutePath(), "Folder Chooser");
                }
            }
        });
        buttonPanel.add(button);
    }

    private void createWizardDialogs() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add(buttonPanel);
        JButton button = new JButton("Wizard");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog dialog = new WizardDialog(DialogsExample.this);
                DefaultWizardPage page = new DefaultWizardPage();
                page.setTitle("1. Page");
                page.setDescription("This is the first wizard page");
                page.add(new JLabel("Content"));
                dialog.addPage(page, "page1");
                page = new DefaultWizardPage();
                page.setTitle("2. Page");
                page.setDescription("This is the second wizard page");
                page.add(new JLabel("Content"));
                dialog.addPage(page, "page2");
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(button);
    }

    public static void main(String[] args) {
        I18nManager.getInstance().setDefaultLocale(Locale.GERMAN);
        DialogsExample app = new DialogsExample();
        app.setDefaultCloseOperation(2);
        app.setTitle("XNap-Commons - " + DialogsExample.class);
        app.pack();
        app.setVisible(true);
    }
}

