/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.TextFieldMenu;
import org.xnap.commons.gui.completion.AutomaticDropDownCompletionMode;
import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.CompletionModeMenu;
import org.xnap.commons.gui.completion.DefaultCompletionModel;
import org.xnap.commons.gui.completion.DropDownListCompletionMode;
import org.xnap.commons.gui.completion.FileCompletionModel;
import org.xnap.commons.gui.util.GUIHelper;
import org.xnap.commons.gui.util.PopupListener;
import org.xnap.commons.settings.CompletionModeSetting;
import org.xnap.commons.settings.PropertyResource;
import org.xnap.commons.settings.SettingResource;

public class CompletionExample
extends JFrame {
    private static final String FILE_NAME = "completion-settings";
    private static PropertyResource rs;
    private JPanel panel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CompletionExample() {
        rs = new PropertyResource();
        try {
            rs.load(new File(FILE_NAME));
        }
        catch (IOException ie) {
            System.out.println("Error loading settings file " + ie.getMessage());
        }
        this.addWindowListener(new ClosingHandler());
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(GUIHelper.createEmptyBorder(10));
        this.setContentPane(this.panel);
        this.addFileCompletion();
        this.addCustomCompletion();
        this.addCompletionWithEditMenu();
        this.addFileCompletion();
    }

    private void addLabel(String text) {
        JLabel label = new JLabel(text);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(7, 5, 0, 5);
        this.panel.add((Component)label, constraints);
    }

    private void addTextField(String text, JComponent textField) {
        JLabel label = new JLabel(text);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(7, 5, 0, 5);
        this.panel.add((Component)label, constraints);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)textField, constraints);
    }

    private void addFileCompletion() {
        JTextField jtf = new JTextField(20);
        this.addLabel("Type a filename.");
        this.addTextField("File-System completion", jtf);
        Completion comp = Builder.addCompletion((JTextComponent)jtf, new FileCompletionModel());
        CompletionModeSetting cms = new CompletionModeSetting((SettingResource)rs, "fileCompletion", AutomaticDropDownCompletionMode.class, comp);
    }

    private void addCompletionWithEditMenu() {
        JTextField textField = new JTextField(20);
        this.addLabel("Use the right mouse button to show the context menu.");
        this.addTextField("File-System completion", textField);
        Completion completion = new Completion((JTextComponent)textField, new FileCompletionModel());
        TextFieldMenu menu = new TextFieldMenu();
        menu.addSeparator();
        menu.add(new CompletionModeMenu(completion));
        textField.addMouseListener(new PopupListener(menu));
    }

    private void addCustomCompletion() {
        JTextField jtf = new JTextField(20);
        this.addLabel("Type 'x'");
        this.addTextField("Custom Completion", jtf);
        DefaultCompletionModel cm = new DefaultCompletionModel(new String[]{"xnap", "xnap commons", "xana", "xilef"});
        Completion comp = new Completion((JTextComponent)jtf, cm);
        CompletionModeMenu menu = new CompletionModeMenu(comp);
        jtf.addMouseListener(new PopupListener(menu));
        new CompletionModeSetting((SettingResource)rs, "completion", DropDownListCompletionMode.class, comp);
    }

    private void addPreviousWordCompletion() {
        this.addLabel("Type words starting with x");
        JTextArea jta = new JTextArea();
        Completion comp = new Completion((JTextComponent)jta, false);
        comp.setModel(new DefaultCompletionModel(new Object[]{"xnap", "xnapcommons", "xana", "xilef", "XNap", "xylophon", "xerxes"}));
        comp.setMode(new DropDownListCompletionMode());
        JLabel label = new JLabel("previous word completion");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(7, 5, 0, 5);
        this.panel.add((Component)label, constraints);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.panel.add((Component)new JScrollPane(jta), constraints);
    }

    public static void main(String[] args) {
        CompletionExample app = new CompletionExample();
        app.setDefaultCloseOperation(2);
        app.setTitle("XNap-Commons - " + CompletionExample.class);
        app.pack();
        app.setVisible(true);
    }

    private class ClosingHandler
    extends WindowAdapter {
        ClosingHandler() {
        }

        public void windowClosed(WindowEvent e) {
            try {
                rs.store(new File(CompletionExample.FILE_NAME));
            }
            catch (IOException ie) {
                System.out.println("Error saving settings file " + ie.getMessage());
            }
        }
    }
}

