<?php
// $Id: theme-settings-init.php,v 1.1 2009/08/14 09:06:19 kehan Exp $
/**
 * @file Initialisation of theme settings with default values
 */
if (is_null(theme_get_setting('zen_breadcrumb_title'))) {
  global $theme_key;

  /*
   * Modify the values in $defaults below if you want the subtheme to have
   * different defaults than the main Zen theme. Make sure $defaults exactly
   * matches the $defaults in the theme-settings.php file.
   */
  $defaults = array(
    'zen_block_editing' => 1,
    'zen_breadcrumb' => 'yes',
    'zen_breadcrumb_separator' => ' › ',
    'zen_breadcrumb_home' => 1,
    'zen_breadcrumb_trailing' => 1,
    'zen_breadcrumb_title' => 1,
    'zen_rebuild_registry' => 0,
    'zen_wireframes' => 0,
  );

  // Get default theme settings.
  $settings = theme_get_settings($theme_key);
  // Don't save the toggle_node_info_ variables.
  if (module_exists('node')) {
    foreach (node_get_types() as $type => $name) {
      unset($settings['toggle_node_info_' . $type]);
    }
  }
  // Save default theme settings.
  variable_set(
    str_replace('/', '_', 'theme_'. $theme_key .'_settings'),
    array_merge($defaults, $settings)
  );
  // Force refresh of Drupal internals.
  theme_get_setting('', TRUE);
}
