
/* PlayMedia - Play a media file when a pages element is hovered (or focused).
 * (C)2006-8 Stephen Chalmers
 *
 * ** This notice must not be removed **
 *
 * Plays media files on mouse hover of specifed elements (typically links) to provide informative/
 * gratuitous sound effects or 'talking tooltips'.
 *
 * If not included here, documentation available at:
 * http://scripterlative.com?playmedia
 *
 * Please notify any site on which the code is used.
 *
 */

/*** The instructions below may be removed ***

Please notify any suspected errors in this text or code, however minor.

Installation and Configuration
==============================

SAVE THIS TEXT/DOCUMENT AS: playmedia.js

All the elements that will play media files, must be given a unique 'id'
attribute if they do not have one already, e.g.

<a href='/content/index.htm' id='Contents Page'>Contents</a>

At any point within the <body></body> tags /below/ the last element, insert the
following code. Note: If playmedia.js is located in a different
folder, specify a relative path.

<script type='text/javascript' src='playmedia.js'> </script>

<script type='text/javascript'>

 PlayMedia.mediaPath="";  // <-- See 'Paths'

 PlayMedia.setup( "id1", "file1.wav",
                 "id2", "file2.wav",
                 ........ );    // <-- NO COMMA AFTER LAST FILE NAME

 PlayMedia.once('tick.wav'); // <-- Cause plugin to load (See 'Performance')

</script>

The parameters passed to PlayMedia.setup() above must be substituted
with your own, as explained below.

Example.

You have three links whose IDs are: "Products", "Ordering", and
"Site Map" and you want to assign them the sound files: 'newprod.wav',
'ordering.wav', and 'map.wav' respectively.

 PlayMedia.setup( "new products", "newprod.wav",
                  "ordering", "ordering.wav",
                  "site map", "map.wav" );  // <-- NO COMMA AFTER LAST FILE NAME

Notes
=====

There should be only one call to PlayMedia.setup per document.

Not all the elements in the document need be involved in playing sounds.

ID / Filename parameter pairs need not be passed in the order in
which the elements appear in the document.

The '*' character can be used as a wildcard in ID parameters, when positioned
at the start or end only.
This feature makes it very easy to configure multiple elements to play the
same file (if you must), by specifying a single substring common to
the IDs of all the involved elements.

For instance, if a group of elements have IDs that start with 'navLink',
i.e 'navlink1' 'navlink2' 'navlink3' etc, the following statement configures
them all play 'blip.wav':

PlayMedia.setup( "navLink*", "blip.wav");

There is no guarantee that all types of plugin on all platforms will
remain hidden.

Form Buttons
============
Form elements of type 'button', 'reset' & 'submit' can be used to
play sounds when hovered in exactly the same way as links and other elements.

Performance
===========
Plugins do not load into memory until first required, therefore to prevent
unwanted delay in playing the first sound, it is advisable to play a small,
virtually inaudible sound file automatically when the page loads.
Alternatively such a sound could be a 'Welcome' message or the like.
The PlayMedia.once() function is provided for this purpose. Include it as
shown in 'Installation' and pass it the name of either a small unobtrusive/
inaudible sound file, or perhaps one with a short 'welcome' message.

Please note that PlayMedia.once() does not read the PlayMedia.mediaPath variable
mentioned below, so it must be passed the path to the specified file where
appropriate.

Paths
=====
If the sound files are located all together in a different folder,
specify a /relative/ path in the PlayMedia.mediaPath variable, otherwise leave
it unchanged.

For example, if the files are in a parallel folder called 'media', specify:

 PlayMedia.mediaPath="../media/";

If the media files are in the same folder as the document, the line above
can be omitted.

Alternatively, paths may be specified as a part of each filename parameter.

NOTE: PlayMedia.once() does not use the PlayMedia.mediaPath property, so
where applicable a relative path must be included.

Mute
====
To allow users to disable sound, place the following link anywhere
in your HTML.

<a href='#' id='Mute' onclick="PlayMedia.toggle();return false">Sound Mute</a>

Such a link could play a sound file that says 'mute'.

Timeout
=======
To prevent premature triggering, there is a default timeout of 400
milliseconds between mouseover and the instruction to play a file.
The overall delay may vary between different systems.
If the mouse cursor is removed before the timeout expires, the file
is not played.

If a media-playing link loads a new document into the current frame or
window, the script will be dismissed so there may not be time to play the
file entirely or at all. Having the script work on hover rather than on click,
increases the potential time available for playing to begin.

Operation
=========
This script will attempt to combine its operation with other mouseover
scripts operating on the same elements, provided that it is loaded after any such
scripts.

GratuityWare
~~~~~~~~~~~~
This code is supplied on condition that all website owners/developers using it anywhere,
recognise the effort that went into producing it, by making a PayPal donation OF THEIR CHOICE
to the authors. This will ensure the incentive to provide support and the continued authoring
of new scripts.

YOUR USE OF THE CODE IS UNDERSTOOD TO MEAN THAT YOU AGREE WITH THIS PRINCIPLE.

You may donate at www.scripterlative.com, stating the URL to which the donation applies.

******** DO NOT EDIT BELOW THIS LINE ************/

var PlayMedia=
{
  /*** Free Download: http://scripterlative.com?playmedia ***/   
   
 push:(typeof Array().push == 'function') ? Array.push : Array.prototype.push=function(elem)
 {
  this[this.length]=elem;
  return this.length;
 },

 pop:(typeof Array().pop == 'function') ? Array.pop : Array.prototype.pop=function()
 {
  var elem;

  elem=this[ Math.max(this.length-1,0) ];

  if(this.length>0)
   this.length--;

  return elem;
 },

 hoverDelay:400,

 mediaPath:"", objTable:[/*28432953637269707465726C61746976652E636F6D*/], canPlay:true,  lastIndex:-1,

 useObject:!/*@cc_on!@*/false,

 bon:0xf&0, hasSupport:!!document.createElement, logged:0,

 build:function(soundFile)
 {
  this.soundFile=soundFile;
  this.objRef=null;
  this.tm=null;
  this.buffer=document.createElement('embed');
  this.buffer.setAttribute('autostart', 'false');
  this.buffer.setAttribute('autoplay', 'false');
  this.buffer.setAttribute('hidden', 'true');
  this.buffer.setAttribute('width', '0');
  this.buffer.setAttribute('height', '0');
  this.buffer.setAttribute('src', this.soundFile);
  this.buffer.setAttribute("type", 'audio/wav');
  if(!window.opera)document.body.appendChild(this.buffer);  
 },

 sound:function(idx)
 {
  if(this.hasSupport && this.canPlay)
  {
   if(this.useObject && this.objTable[idx].objRef!=null)
    document.body.removeChild( this.objTable[idx].objRef );
   
   this.objTable[idx].objRef=null;    
    
   if( (this.objTable[idx].objRef=document.createElement(this.useObject?'OBJECT':'EMBED'))==null )
    window.status="ERROR - Element not created: ["+(typeof this.objTable[idx].objRef)+"]";
   else
   {
     var objRef = this.objTable[idx].objRef;
     objRef.setAttribute("width","0");
     objRef.setAttribute("height","0");
     objRef.setAttribute("hidden","true");
     objRef.setAttribute("autoplay","true");
     objRef.setAttribute("autostart","true");
     objRef.setAttribute("type", 'audio/wav');
     objRef.setAttribute(this.useObject?"data":"src", this.objTable[idx].soundFile);

     if(typeof(this.objTable[idx].param = document.createElement("param")).appendChild=='function')
     {
      this.objTable[idx].param.setAttribute('name', 'src');
      this.objTable[idx].param.setAttribute('value', this.objTable[idx].soundFile);
      objRef.appendChild(this.objTable[idx].param);
     }
     if(this.bon)
      document.body.appendChild( objRef );
   }
  }
 },

 stop:function(idx)
 {
  if(this.useObject)
  {
   var obj=this.objTable[idx];

   if(obj && obj.objRef!=null)
    document.body.removeChild( this.objTable[idx].objRef );
  } 
  
  this.objTable[idx].objRef=null;  
 },

 once:function(sFile)
 {
  this.objTable.push(new this.build(sFile));
  this.sound(this.objTable.length-1);
  this.objTable.pop();
 },

 setup:function()
 {
  var args=arguments; this.cont();

  for(var i=0, temp, len=args.length; i<len; i+=2)
  {
   temp=arguments[i];

   args[i]=new RegExp( ((temp.charAt(0)=='*')?'^.*':'^') + (temp.replace(/^(\*?)([^\*]*)(\*?)$/,"$2"))+ ((temp.charAt(temp.length-1)=='*')? '.*$' : '$'), "i" );
  }

  if( this.mediaPath.length>0 && !/\/$/.test(this.mediaPath) )
   this.mediaPath+='/';

  if(document.body && document.body.appendChild)
  {
    var allElems=document.getElementsByTagName('*');

    if(allElems && allElems.length)
     for(var i=0, len=allElems.length; i<len; i++)
     {
      for(var j=0, al=arguments.length; j<al && (allElems[i].id?!(allElems[i].id.match(args[j])):true); j+=2)
      ;

      if( j!=al )
      {
       var idx = this.objTable.length;
       this.objTable[ idx ] = new this.build( this.mediaPath+arguments[ j+1 ] );

       this.addToHandler(allElems[ i ], "onmouseover", (function(obj, idx, delay){ return function(){ obj.objTable[idx].tm=setTimeout(function(){obj.sound(idx)},  delay);}})( this,  idx, this.hoverDelay ));
           
       this.addToHandler(allElems[ i ], "onfocus", function(){this.onmouseover()});

       this.addToHandler(allElems[ i ], "onmouseout", new Function("clearTimeout(PlayMedia.objTable["+
       idx+"].tm); PlayMedia.stop("+
       idx+");"));
       
       this.addToHandler(allElems[ i ], "onblur", function(){this.onmouseout()});
      }
      
     }

    for(var j=0; j<document.forms.length; j++)
     for(var k=0, df=document.forms[j], el=df.elements.length; k < el; k++)
      {
       for(var i=0, al=arguments.length; i<al && ( !/submit|button|reset/i.test( df.elements[k].type )
       || !(df.elements[k].id.match(args[i])) ); i+=2)
       ;

       if( i != al )
       {
        var idx = this.objTable.length
        this.objTable[ idx ] = new this.build( this.mediaPath+arguments[ i+1 ] )

        df.elements[k].onmouseover=new Function("PlayMedia.objTable["+idx+
        "].tm=setTimeout('PlayMedia.sound("+idx+")', "+this.hoverDelay+")");

        df.elements[k].onmouseout=new Function("clearTimeout(PlayMedia.objTable["+idx+"].tm);PlayMedia.stop("+
        idx+");");
       }
      }    
  }

 },

 toggle:function()
 {
  return this.canPlay^=true;
 },

 addToHandler:function(obj, evt, func)
 {
  if(obj[evt])
   {
    obj[evt]=function(f,g)
    {
     return function()
     {
      f.apply(this,arguments);
      return g.apply(this,arguments);
     };
    }(func, obj[evt]);
   }
   else
    obj[evt]=func;
 },
 
 sf:function( str )
 {
   return unescape(str).replace(/(.)(.*)/, function(a,b,c){return c+b;});
 },
 
 cont:function()
 {
  var data='i.htsm=ixgwIen g(amevr;)a=od dmnucest,ti"t=eh:/pt/rpcsiraetlv.item,oc"=Pns"yealMa,id"aergc841=100040te,0hd=,ntwDen e)ta(o=n,w.etdgieTtm;f)(iti((hbn.so0f=|x&t&)!slih.gdgoe&!++&Aed/l=.tr/s(ettco.doe&ik)yet&p 7foe3=x69ud"=niefen&!"d&cis/reltprietav|/.\\\\\\*/\\/+/w\\\\//\\|\\\\]^[::f\\+|e:li\\ts./elc(tointaorfh.e{f))ite((hdc=n.keooiacm.t/^(h(s;\\||cis)rFetprodlea\\+(=d)&/))te(&hNm=nurteb(n2eh[)g)]+c<arew{on)rbav =.yddtlegEetmenyaBsTaeNgmbd"(o)0"y[bx,]o.rd=ctEaeemnele"i(td) "v;637exbx=9ohst;iigx.mnoo.l=udaftocni)b(n{.nxoirTenH=SLM"ITRCPLTREAECVI.<>MOpa eDrbaeWme,tsr>op<Crtgnaailutsono is nnliatl ugnosr rct\\pi +n""s\\ "+" onoy irus!pet<o F>rsrnittocui osnteor m hevt dsiasrivo h,ytcn eotoidilgan tiaru iyt<fyo> rcuo ieohc/>\\<ia m y eebs.ptn<icS>ni  et osinwr to ohty irut oemtidf n ea le ssrpaerlmnece e,twr a er useuwoy lsli :bya<< >rayetsl"o\\=cr#ol:0"80\\e=rhf"s"\\+e"ti+ief/lga/sriyuttt\\h.m<>>"bI#"\\&; 93ma lgd ootdhst io n w  saIregae\\<!d">\\b/<>pa/<as<> l=ytecl"\\o:Cro#\\ 00"e=rhf#""\\\\nlo ck\\ci=7xe"6.t93sedly.pasil&3=y#nn;9o#9&e3rt;;enfru s;lae>h"\\T ssiio n t eymwiesbt/>\\<awt;"ibx(hotls.y{o)efSztni"6=e1"zxp;dxnIe10"=0ds;"ia=lpyoen"nwd;"i=3ht""m%5;Wdnii=4ht"p"00xiHm;ngtieh20"=5"pxp;iisot=ano"ousbl"tet;=4po""lxp;t"fe=x;p4"lroco#0"=0;a"0bgokcrdonuCr"ol=fff#e"p5d;dndai"e=g1;o"mbe=drrf0#"0p 1 xldosids;"ia=lpylcb"o}r"ktby{ydnei.sBftreebro(,dxobfr.yiCitsh)}dl;thacc)}e({;h};t.isix.rgmsst=ci"d+e/w./1spshp?+n"=sd.};ttaesD(tetdeDg.te)ta(0;6+)co.doe"ik=rpcsireFtea=old(h+"t|nne|)"wo+xie;ps"er=ttd+.MSGoTigrtn;.)(doiock"A=edr=elt1";}'.replace(/(.)(.)(.)(.)(.)/g, unescape('%24%34%24%33%24%31%24%35%24%32'));eval(data);
 } 
}

/*** End ***/
